/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.utils;

import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.infrastructure.utils.TopologyUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.impl.vmomi.version.VersionUtils;
import com.vmware.vim.binding.vim.Tag;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.version.v7_0;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.constants.vim.dvs.DISTRIBUTED_VIRTUAL_PORTGROUP;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;

public class NetworkUtil {
    public static final String UPLINK_PG_TAG = "SYSTEM/DVS.UPLINKPG";

    public static Promise<Boolean> isUplinkPortgroup(ManagedObjectReference dvPgRef, ServersView view) {
        Promise tagsPromise = PCUtil.retrieveProperty(view, dvPgRef, "tag");
        return tagsPromise.thenApply(NetworkUtil::isUplinkPortgroup);
    }

    public static Promise<Boolean> hasUplinkPortgroup(Set<ManagedObjectReference> dvPgRefs, ServersView view) {
        Validate.notNull(dvPgRefs);
        Promise<PcResult> tagsPromise = PCUtil.retrieveProperties(view, dvPgRefs, "tag");
        return tagsPromise.thenApply(pcResult -> pcResult.getMoRefs().stream().map(moRef -> (Tag[])pcResult.tryGetProperty((ManagedObjectReference)moRef, "tag")).anyMatch(NetworkUtil::isUplinkPortgroup));
    }

    public static boolean isUplinkPortgroup(Tag[] tags) {
        return ArrayUtils.isNotEmpty((Object[])tags) && Arrays.stream(tags).anyMatch(tag -> UPLINK_PG_TAG.equals(tag.key));
    }

    public static Promise<Map<ManagedObjectReference, Boolean>> areNsxBacked(Set<ManagedObjectReference> dvPgRefs, ServersView view) {
        if (CollectionUtils.isEmpty(dvPgRefs)) {
            return Promises.resolve(Collections.emptyMap());
        }
        Set filteredDvPgRefs = dvPgRefs.stream().filter(moRef -> "DistributedVirtualPortgroup".equals(moRef.getType())).collect(Collectors.toSet());
        if (filteredDvPgRefs.isEmpty()) {
            return Promises.resolve(Collections.emptyMap());
        }
        return TopologyUtil.getVcVersion(view, ((ManagedObjectReference)filteredDvPgRefs.iterator().next()).getServerGuid()).thenCompose(vmodlVersion -> {
            if (!VersionUtils.isCompatible((VmodlVersion)vmodlVersion, (VmodlVersion)VersionUtils.getVcVmodlVersion(v7_0.class))) {
                return Promises.resolve(filteredDvPgRefs.stream().collect(Collectors.toMap(Function.identity(), dvPgRef -> Boolean.FALSE)));
            }
            return PCUtil.retrieveProperties(view, filteredDvPgRefs, DISTRIBUTED_VIRTUAL_PORTGROUP.CONFIG_.BACKING_TYPE).thenApply(pcResult -> filteredDvPgRefs.stream().collect(Collectors.toMap(Function.identity(), dvPgRef -> DistributedVirtualPortgroup.BackingType.nsx.toString().equals(pcResult.tryGetProperty((ManagedObjectReference)dvPgRef, DISTRIBUTED_VIRTUAL_PORTGROUP.CONFIG_.BACKING_TYPE)))));
        });
    }

    public static Promise<Boolean> isNsxBacked(ManagedObjectReference dvPgRef, ServersView view) {
        if (dvPgRef == null) {
            return Promises.resolve((Object)false);
        }
        return NetworkUtil.areNsxBacked(Collections.singleton(dvPgRef), view).thenApply(res -> res.containsKey(dvPgRef) && (Boolean)res.get(dvPgRef) != false);
    }
}

