/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.utils;

import com.vmware.srm.client.infrastructure.exceptions.ExceptionUtil;
import com.vmware.srm.client.infrastructure.requestHandlers.context.HmsRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.context.SrmRequestContext;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsPairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmPairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServersView;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologyUtil.class);

    public static Promise<SrmServer> getSrmServer(SrmServersView view, String serverGuid, boolean peer) {
        if (peer) {
            return view.getSrmBy(serverGuid).thenCompose(SrmServer::getPair).thenCompose(pairSetup -> {
                if (pairSetup == null) {
                    throw ExceptionUtil.getSrmNotPairedException(serverGuid);
                }
                return pairSetup.getPairServer();
            });
        }
        return view.getSrmBy(serverGuid);
    }

    public static Promise<SrmServer> getSrmServer(SrmServersView view, ManagedObjectReference moref, boolean peer) {
        return TopologyUtil.getSrmServer(view, moref.getServerGuid(), peer);
    }

    public static Promise<SrmServer> getSrmServer(SrmRequestContext context, boolean peer) {
        return peer ? ((SrmPairSetup)context.pairSetup()).getPairServer() : Promises.resolve(context.extServer());
    }

    public static Promise<Void> loginRemoteSite(SrmServersView view, ManagedObjectReference localSrmMoRef) {
        return TopologyUtil.getSrmServer(view, localSrmMoRef, false).thenCompose(TopologyUtil::loginRemoteSite);
    }

    public static Promise<Void> loginRemoteSite(SrmServer server) {
        return server.getPair().thenCompose(pairSetup -> {
            if (pairSetup == null) {
                throw ExceptionUtil.getSrmNotPairedException(server.guid());
            }
            return pairSetup.remoteLogin();
        });
    }

    public static Promise<Void> loginRemoteSite(HmsRequestContext context) {
        return ((HmsPairSetup)context.pairSetup()).remoteLogin();
    }

    public static Promise<Void> loginRemoteSite(SrmServer server, boolean peer) {
        Promise serverPromise = peer ? server.getPair().thenCompose(PairSetup::getPairServer) : Promises.resolve((Object)server);
        return serverPromise.thenCompose(TopologyUtil::loginRemoteSite);
    }

    public static Promise<SrmService> getSrmService(SrmServersView view, ManagedObjectReference moref, boolean peer) {
        return TopologyUtil.getSrmServer(view, moref, peer).thenApply(srmService -> {
            if (srmService == null) {
                throw ExceptionUtil.getSrmNotPairedException(moref.getServerGuid());
            }
            return (SrmService)srmService.service();
        });
    }

    public static Promise<SrmService> getSrmService(SrmRequestContext context, boolean peer) {
        return TopologyUtil.getSrmServer(context, peer).thenApply(Server::service);
    }

    public static Promise<VcServer> getVc(SrmRequestContext context, boolean peer) {
        return TopologyUtil.getSrmServer(context, peer).thenApply(ExtensionServer::vc);
    }

    public static Promise<VcServer> getVc(SrmServersView view, ManagedObjectReference srmMoRef, boolean peer) {
        return TopologyUtil.getSrmServer(view, srmMoRef, peer).thenApply(ExtensionServer::vc);
    }

    public static Promise<VcServer> getVc(SrmServersView view, String srmGuid, boolean peer) {
        return TopologyUtil.getSrmServer(view, srmGuid, peer).thenApply(ExtensionServer::vc);
    }

    public static Promise<ManagedObjectReference> loginRemoteHms(HmsServer sourceHmsServer, String targetHmsGuid) {
        Validate.notNull((Object)sourceHmsServer, (String)"sourceHmsServer");
        Validate.notEmpty((String)targetHmsGuid, (String)"targetHmsGuid");
        return TopologyUtil.findHmsPairSetup(sourceHmsServer, targetHmsGuid).thenCompose(pair -> pair.remoteLogin().thenApply(unused -> pair.pairServerVmomiRef()));
    }

    public static Promise<HmsPairSetup> findHmsPairSetup(HmsServer sourceHmsServer, String targetHmsGuid) {
        Validate.notNull((Object)sourceHmsServer, (String)"sourceHmsServer");
        Validate.notEmpty((String)targetHmsGuid, (String)"targetHmsGuid");
        return sourceHmsServer.getPairs().reduce(new ArrayList(), (pairs, pair) -> {
            if (pair.pairServerGuid().equals(targetHmsGuid)) {
                pairs.add(pair);
            }
            return pairs;
        }).thenApply(pairSetups -> {
            if (pairSetups.size() == 0) {
                LOGGER.error("Cannot find remote HMS server for {}", (Object)targetHmsGuid);
                throw new IllegalStateException("missing pair");
            }
            if (pairSetups.size() > 1) {
                LOGGER.error("Multiple pairs found for {}", (Object)targetHmsGuid);
                throw new IllegalStateException("multiple pairs");
            }
            return (HmsPairSetup)pairSetups.get(0);
        });
    }

    public static Promise<VmodlVersion> getVcVersion(ServersView view, String vcGuid) {
        Validate.notNull((Object)view, (String)"serversView");
        Validate.notEmpty((String)vcGuid, (String)"vcGuid");
        return view.getServerBy(vcGuid).thenApply(VcServer.class::cast).thenApply(Server::service).thenCompose(Service::getVersion);
    }
}

