/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.identity.websso.client.AssertionConsumerService;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.identity.websso.client.SingleLogoutService;
import com.vmware.srm.client.infrastructure.websso.WebSsoWorkflow;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class SPConfigFactory {
    private static final String ALIAS = "DRaaS H5 UI";
    private static final String SIGNATURE_ALG = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";

    public SPConfiguration create(URI appBaseUrl, X509Certificate certificate, PrivateKey privateKey, String ssoPath, String sloPath) throws URISyntaxException {
        String entityId = appBaseUrl.toString();
        String ssoUrl = WebSsoWorkflow.addPath(appBaseUrl, ssoPath).toString();
        AssertionConsumerService acsHttp = new AssertionConsumerService(ssoUrl, true, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 0);
        String sloUrl = WebSsoWorkflow.addPath(appBaseUrl, sloPath).toString();
        SingleLogoutService sloHttp = new SingleLogoutService(sloUrl, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        SingleLogoutService sloSoap = new SingleLogoutService(sloUrl, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        return new SPConfiguration(ALIAS, entityId, true, privateKey, certificate, SIGNATURE_ALG, Arrays.asList("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress"), Arrays.asList(acsHttp), Arrays.asList(sloHttp, sloSoap));
    }
}

