/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.wstrust.client;

import com.vmware.identity.wstrust.client.impl.ValidateUtil;
import com.vmware.vim.sso.client.Advice;
import com.vmware.vim.sso.client.SamlToken;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class TokenSpec {
    private final long _tokenLifetimeSec;
    private final DelegationSpec _delegationSpec;
    private final boolean _isRenewable;
    private final Confirmation _confirmation;
    private final Set<String> _audienceRestriction;
    private final List<Advice> _advice;

    private TokenSpec(long tokenLifetimeSec, DelegationSpec delegationSpec, boolean isRenewable, Confirmation confirmation, Set<String> audienceRestriction, List<Advice> advice) {
        ValidateUtil.validatePositiveNumber(tokenLifetimeSec, "token lifetime");
        this._tokenLifetimeSec = tokenLifetimeSec;
        this._delegationSpec = delegationSpec;
        this._isRenewable = isRenewable;
        this._confirmation = confirmation;
        this._audienceRestriction = audienceRestriction;
        this._advice = advice;
    }

    public long getTokenLifetime() {
        return this._tokenLifetimeSec;
    }

    public DelegationSpec getDelegationSpec() {
        return this._delegationSpec;
    }

    public boolean isRenewable() {
        return this._isRenewable;
    }

    public Confirmation getConfirmation() {
        return this._confirmation;
    }

    public Set<String> getAudienceRestriction() {
        return this._audienceRestriction;
    }

    public List<Advice> getAdvice() {
        return this._advice;
    }

    public String toString() {
        return "TokenSpec [tokenLifetimeSec=" + this._tokenLifetimeSec + ", delegationSpec=" + this._delegationSpec + ", isRenewable=" + this._isRenewable + ", confirmation=" + (Object)((Object)this._confirmation) + ", audienceRestriction=" + this._audienceRestriction + ", advice=" + this._advice + "]";
    }

    public static class Builder {
        private final long _tokenLifetime;
        private DelegationSpec _delegationSpec;
        private boolean _isRenewable;
        private Confirmation _confirmation = Confirmation.DEFAULT;
        private Set<String> _audienceRestriction = Collections.emptySet();
        private List<Advice> _advice = Collections.emptyList();

        public Builder(long tokenLifetime) {
            ValidateUtil.validatePositiveNumber(tokenLifetime, "token lifetime");
            this._tokenLifetime = tokenLifetime;
        }

        public Builder delegationSpec(DelegationSpec delegationSpec) {
            ValidateUtil.validateNotNull(delegationSpec, "Token delegation spec");
            this._delegationSpec = delegationSpec;
            return this;
        }

        public Builder renewable(boolean isRenewable) {
            this._isRenewable = isRenewable;
            return this;
        }

        public Builder confirmation(Confirmation confirmation) {
            ValidateUtil.validateNotNull((Object)confirmation, "Confirmation type");
            this._confirmation = confirmation;
            return this;
        }

        public Builder audienceRestriction(Set<String> audienceRestriction) {
            ValidateUtil.validateNotNull(audienceRestriction, "Audience restriction list");
            this._audienceRestriction = Collections.unmodifiableSet(audienceRestriction);
            return this;
        }

        public Builder advice(List<Advice> advice) {
            ValidateUtil.validateNotNull(advice, "Advice");
            this._advice = Collections.unmodifiableList(advice);
            return this;
        }

        public TokenSpec createTokenSpec() {
            return new TokenSpec(this._tokenLifetime, this._delegationSpec, this._isRenewable, this._confirmation, this._audienceRestriction, this._advice);
        }
    }

    public static enum Confirmation {
        DEFAULT,
        NONE;

    }

    public static final class DelegationSpec {
        private final boolean _isDelegable;
        private final String _delegateTo;
        private final SamlToken _actAsToken;

        public DelegationSpec(boolean isDelegable) {
            this._isDelegable = isDelegable;
            this._delegateTo = null;
            this._actAsToken = null;
            assert (this.invariantRespected());
        }

        public DelegationSpec(boolean isDelegable, String delegateTo) {
            this._isDelegable = isDelegable;
            this._delegateTo = delegateTo;
            this._actAsToken = null;
            assert (this.invariantRespected());
        }

        public DelegationSpec(SamlToken actAsToken, boolean isDelegable) {
            ValidateUtil.validateNotNull(actAsToken, "ActAs token");
            this._isDelegable = isDelegable;
            this._delegateTo = null;
            this._actAsToken = actAsToken;
            assert (this.invariantRespected());
        }

        public boolean isDelegable() {
            return this._isDelegable;
        }

        public String getDelegateTo() {
            return this._delegateTo;
        }

        public SamlToken getActAsToken() {
            return this._actAsToken;
        }

        private boolean invariantRespected() {
            return this._delegateTo == null || this._actAsToken == null;
        }

        public String toString() {
            return "DelegationSpec [isDelegable=" + this._isDelegable + ", delegateTo=" + this._delegateTo + "]";
        }
    }
}

