/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.wstrust.client.impl.ssl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

class SslUtil {
    private static final String HEX = "0123456789ABCDEF";
    private static final String THUMBPRINT_ALGO = "SHA-1";

    static String computeCertificateThumbprint(X509Certificate cert) throws CertificateEncodingException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(THUMBPRINT_ALGO);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        byte[] digest = md.digest(cert.getEncoded());
        StringBuilder thumbprint = new StringBuilder();
        int len = digest.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                thumbprint.append(':');
            }
            byte b = digest[i];
            thumbprint.append(HEX.charAt((b & 0xF0) >> 4));
            thumbprint.append(HEX.charAt(b & 0xF));
        }
        return thumbprint.toString();
    }

    private SslUtil() {
    }
}

