/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.config;

import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.config.Configurator;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.ProtocolHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringConfigurator
implements Configurator {
    private static final String DEFAULT_TC_SERVER_CONFIG = "vapi-tcserver-spring.xml";
    private static final String DEFAULT_HTTP_CONFIG = "vapi-http-spring.xml";
    private static final String DEFAULT_HTTPS_CONFIG = "vapi-https-spring.xml";
    private static final String PROVIDER_BEAN_ID = "apiProvider";
    private static final String HTTP_SERVER_BEAN_ID = "httpOnlyServer";
    private static final String HTTPS_SERVER_BEAN_ID = "httpsOnlyServer";
    private static final String HTTP_HTTPS_SERVER_BEAN_ID = "httpAndHttpsServer";
    private static final Logger logger = LoggerFactory.getLogger(SpringConfigurator.class);
    private AbstractRefreshableConfigApplicationContext ctx;
    private URL httpUrl;
    private URL httpsUrl;

    public SpringConfigurator(List<String> configFiles) {
        Validate.notEmpty(configFiles);
        this.loadSpringContext(configFiles, null);
    }

    public SpringConfigurator(String uri, String providerSpringConfig) {
        Validate.notNull(providerSpringConfig);
        this.httpUrl = this.parseUrl(uri, "http");
        ArrayList<String> configs = new ArrayList<String>();
        configs.add(DEFAULT_TC_SERVER_CONFIG);
        configs.add(DEFAULT_HTTP_CONFIG);
        configs.add(providerSpringConfig);
        Properties configProps = new Properties();
        this.prepareHttpConfigProperties(this.httpUrl, configProps);
        configProps.put("httpServer", HTTP_SERVER_BEAN_ID);
        this.loadSpringContext(configs, configProps);
    }

    public SpringConfigurator(String uri, String secureUri, String keystore, String password, String keypassword, String providerSpringConfig) {
        Validate.notNull(providerSpringConfig);
        this.httpUrl = this.parseUrl(uri, "http");
        this.httpsUrl = this.parseUrl(secureUri, "https");
        Properties configProps = this.prepareConfigProperties(this.httpUrl, this.httpsUrl, keystore, password, keypassword);
        ArrayList<String> configs = new ArrayList<String>();
        configs.add(DEFAULT_TC_SERVER_CONFIG);
        configs.add(DEFAULT_HTTPS_CONFIG);
        if (this.httpUrl != null) {
            configs.add(DEFAULT_HTTP_CONFIG);
        }
        configs.add(providerSpringConfig);
        String serverBeanId = this.httpUrl == null ? HTTPS_SERVER_BEAN_ID : HTTP_HTTPS_SERVER_BEAN_ID;
        configProps.put("httpServer", serverBeanId);
        this.loadSpringContext(configs, configProps);
    }

    private void loadSpringContext(List<String> configs, Properties configProps) {
        this.ctx = new ClassPathXmlApplicationContext();
        if (configProps != null) {
            PropertyPlaceholderConfigurer propsPostProcessor = new PropertyPlaceholderConfigurer();
            propsPostProcessor.setProperties(configProps);
            if (logger.isDebugEnabled()) {
                logger.debug("Loading Spring configs files: " + configs);
            }
            this.ctx.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)propsPostProcessor);
        }
        this.ctx.setConfigLocations(configs.toArray(new String[configs.size()]));
        this.ctx.refresh();
    }

    private URL parseUrl(String url, String urlType) {
        if (url == null) {
            return null;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            String msg = MessageFactory.getMessage("vapi.http.invalidarguments", urlType + " url").toString();
            throw new RuntimeException(msg);
        }
    }

    private Properties prepareConfigProperties(URL httpUrl, URL httpsUrl, String keystore, String password, String keyPassword) {
        Properties result = new Properties();
        if (httpUrl != null) {
            this.prepareHttpConfigProperties(httpUrl, result);
        }
        if (httpsUrl != null) {
            this.prepareSecureHttpConfigProperties(httpUrl, result);
        }
        String invalidArgs = null;
        if (keystore == null) {
            invalidArgs = "keystore path";
        } else if (password == null) {
            invalidArgs = "keystore password";
        }
        if (invalidArgs != null) {
            String msg = MessageFactory.getMessage("vapi.http.invalidarguments", invalidArgs).toString();
            throw new RuntimeException(msg);
        }
        result.setProperty("keystore.path", keystore);
        result.setProperty("keystore.password", password);
        if (keyPassword != null) {
            result.setProperty("key.password", keyPassword);
        }
        return result;
    }

    private void prepareHttpConfigProperties(URL httpUrl, Properties props) {
        props.setProperty("http.port", String.valueOf(httpUrl.getPort()));
        props.setProperty("http.path", httpUrl.getPath());
    }

    private void prepareSecureHttpConfigProperties(URL httpUrl, Properties props) {
        props.setProperty("https.port", String.valueOf(this.httpsUrl.getPort()));
        props.setProperty("https.path", this.httpsUrl.getPath());
    }

    @Override
    public ApiProvider getApiProvider() {
        return (ApiProvider)this.ctx.getBean(PROVIDER_BEAN_ID, ApiProvider.class);
    }

    @Override
    public List<ProtocolHandler> getProtocolHandlers() {
        return new ArrayList<ProtocolHandler>(this.ctx.getBeansOfType(ProtocolHandler.class).values());
    }
}

