/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.data;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ValueVisitor;

public final class StringValue
implements DataValue {
    private static final long serialVersionUID = 1L;
    private final String value;

    public StringValue(String value) {
        if (value == null) {
            throw new CoreException(MessageFactory.getMessage("vapi.data.string.null.string", new String[0]));
        }
        this.value = value;
    }

    @Override
    public DataType getType() {
        return DataType.STRING;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof StringValue) {
            StringValue str = (StringValue)o;
            return this.value.equals(str.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public StringValue copy() {
        return this;
    }
}

