/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol;

import com.fasterxml.jackson.core.JsonFactory;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.type.ErrorType;
import com.vmware.vapi.bindings.type.MapType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.client.Configuration;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.ClassLoaderUtil;
import com.vmware.vapi.internal.bindings.OperationDef;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.internal.bindings.convert.NameToTypeResolver;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;
import com.vmware.vapi.internal.bindings.convert.impl.DefaultConverterFactory;
import com.vmware.vapi.internal.bindings.convert.impl.JavaClassStructConverter;
import com.vmware.vapi.internal.bindings.convert.impl.JavaUtilCalendarRfc3339DateTimeConverter;
import com.vmware.vapi.internal.bindings.convert.impl.JavaUtilMapStructValueMapConverter;
import com.vmware.vapi.internal.bindings.convert.impl.MapBasedNameToTypeResolver;
import com.vmware.vapi.internal.client.Protocol;
import com.vmware.vapi.internal.protocol.client.rest.BindingsOperationRestMetadataProvider;
import com.vmware.vapi.internal.protocol.client.rest.DefaultBodyConverter;
import com.vmware.vapi.internal.protocol.client.rest.DefaultRequestExecutorFactory;
import com.vmware.vapi.internal.protocol.client.rest.DefaultResponseParser;
import com.vmware.vapi.internal.protocol.client.rest.OperationRestMetadataProvider;
import com.vmware.vapi.internal.protocol.client.rest.RequestBuilderFactory;
import com.vmware.vapi.internal.protocol.client.rest.RequestExecutor;
import com.vmware.vapi.internal.protocol.client.rest.RequestExecutorFactory;
import com.vmware.vapi.internal.protocol.client.rest.ResponseParser;
import com.vmware.vapi.internal.protocol.client.rest.RestClientApiProvider;
import com.vmware.vapi.internal.protocol.client.rest.RestProtocolConnection;
import com.vmware.vapi.internal.protocol.client.rest.RestRequestBuilderFactory;
import com.vmware.vapi.internal.protocol.client.rest.StatusCodeErrorConverter;
import com.vmware.vapi.internal.protocol.client.rpc.RestTransport;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientRestTransport;
import com.vmware.vapi.internal.protocol.common.DirectDeserializer;
import com.vmware.vapi.internal.protocol.common.DirectSerializer;
import com.vmware.vapi.internal.protocol.common.http.UrlUtil;
import com.vmware.vapi.internal.protocol.common.json.JsonDirectDeserializer;
import com.vmware.vapi.internal.protocol.common.json.JsonDirectSerializer;
import com.vmware.vapi.protocol.ProtocolConnection;
import com.vmware.vapi.protocol.client.http.RequestPreProcessor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestProtocol
implements Protocol {
    private static final String DEFINITIONS_CLASS_NAME_SUFFIX = "Definitions";
    private static final String OPERATION_DEFS_FIELD_NAME = "__operationDefs";
    private static final Logger LOGGER = LoggerFactory.getLogger(RestProtocol.class);
    private static final Protocol INSTANCE = new RestProtocol();
    public static final String REST_REQUEST_AUTHENTICATOR_CFG = "rest.request.authenticator";
    public static final String REST_REQUEST_EXECUTOR_CFG = "rest.request.executor";

    private RestProtocol() {
    }

    public static Protocol getInstance() {
        return INSTANCE;
    }

    @Override
    public Protocol.ApiProviderCardinality getApiProviderCardinality() {
        return Protocol.ApiProviderCardinality.PER_STUB;
    }

    @Override
    public ProtocolConnection getProtocolConnection(String url, Configuration config) {
        return new RestProtocolConnection(this.buildRestClientApiProvider(url, config));
    }

    @Override
    public TypeConverter getTypeConverter(StubConfigurationBase stubConfig) {
        Set<ErrorType> stubConfigErrors = null;
        if (stubConfig != null) {
            stubConfigErrors = stubConfig.getErrorTypes();
        }
        Map<String, StructType> errorTypes = MapBasedNameToTypeResolver.augmentWithStandardErrors(stubConfigErrors);
        MapBasedNameToTypeResolver errorTypeResolver = new MapBasedNameToTypeResolver(errorTypes);
        return new TypeConverterImpl(new RestStubConverterFactory(errorTypeResolver), true, true);
    }

    CloseableHttpClient resolveHttpClient(Configuration config) {
        CloseableHttpClient apacheHttpClient = config.getProperty("apache.bio.http.client", CloseableHttpClient.class);
        if (apacheHttpClient == null) {
            throw new RuntimeException("Didn't receive apache client");
        }
        return apacheHttpClient;
    }

    RequestConfig resolveDefaultRequestConfiguration(Configuration config) {
        return config.getProperty("apache.http.request.config", RequestConfig.class);
    }

    ApiProvider buildRestClientApiProvider(String url, Configuration config) {
        ApacheClientRestTransport apacheRestTransport = new ApacheClientRestTransport(this.resolveHttpClient(config), this.resolveDefaultRequestConfiguration(config));
        JsonFactory jsonFactory = new JsonFactory();
        ResponseParser responseParser = this.buildResponseParser(jsonFactory);
        RestClientApiProvider provider = new RestClientApiProvider(this.buildRequestExecutor(apacheRestTransport, responseParser, config), this.buildRequestBuilderFactory(url, jsonFactory, config));
        RequestPreProcessor authenticator = this.buildRestAuthenticator(config);
        if (authenticator != null) {
            provider.setPreProcessors(Arrays.asList(authenticator));
        }
        return provider;
    }

    private RequestExecutor buildRequestExecutor(RestTransport transport, ResponseParser parser, Configuration config) {
        RequestExecutorFactory executorFactory = config.getProperty(REST_REQUEST_EXECUTOR_CFG, RequestExecutorFactory.class);
        if (executorFactory == null) {
            executorFactory = new DefaultRequestExecutorFactory();
        }
        return executorFactory.createRequestExecutor(transport, parser);
    }

    protected RequestPreProcessor buildRestAuthenticator(Configuration config) {
        return config.getProperty(REST_REQUEST_AUTHENTICATOR_CFG, RequestPreProcessor.class);
    }

    RequestBuilderFactory buildRequestBuilderFactory(String url, JsonFactory jsonFactory, Configuration config) {
        return new RestRequestBuilderFactory(url, this.buildSerializer(jsonFactory), this.buildRestMetadataProvider(config), new UrlUtil());
    }

    ResponseParser buildResponseParser(JsonFactory jsonFactory) {
        DirectDeserializer jsonDeserializer = this.buildDeserializer(jsonFactory);
        DefaultBodyConverter bodyConverter = new DefaultBodyConverter(jsonDeserializer);
        StatusCodeErrorConverter errorConverter = new StatusCodeErrorConverter(bodyConverter);
        return new DefaultResponseParser(bodyConverter, errorConverter);
    }

    DirectSerializer buildSerializer(JsonFactory jsonFactory) {
        return new JsonDirectSerializer(jsonFactory);
    }

    OperationRestMetadataProvider buildRestMetadataProvider(Configuration config) {
        return new BindingsOperationRestMetadataProvider(this.resolveRestMetadata(config));
    }

    DirectDeserializer buildDeserializer(JsonFactory jsonFactory) {
        return new JsonDirectDeserializer(jsonFactory);
    }

    List<OperationDef> resolveRestMetadata(Configuration config) {
        Class vapiIface = config.getProperty("vapi.interface", Class.class);
        if (vapiIface == null) {
            String errorMsg = "Failed to load REST metadata for the service, since its Class instance is not specified.";
            LOGGER.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        String definitionsClassName = vapiIface.getName() + DEFINITIONS_CLASS_NAME_SUFFIX;
        try {
            ClassLoader cl = ClassLoaderUtil.getServiceClassLoader();
            Class<?> definitionsClass = cl.loadClass(definitionsClassName);
            Field operDefsField = definitionsClass.getDeclaredField(OPERATION_DEFS_FIELD_NAME);
            operDefsField.setAccessible(false);
            Object value = operDefsField.get(null);
            List operDefValue = (List)value;
            return operDefValue;
        }
        catch (Exception ex) {
            String errorMsg = "Failed to load REST metadata for target service";
            LOGGER.error(errorMsg);
            throw new RuntimeException(errorMsg, ex);
        }
    }

    static final class RestStubConverterFactory
    extends DefaultConverterFactory {
        private final UniTypeConverter<StructValue, StructType> skipUnsetFieldsStructConverter = new JavaClassStructConverter<StructValue, StructType>(StructValue.class, Structure.class, true);
        private final UniTypeConverter<DataValue, MapType> structMapConverter = new JavaUtilMapStructValueMapConverter();
        private final JavaUtilCalendarRfc3339DateTimeConverter rfc3339DateTimeConverter = new JavaUtilCalendarRfc3339DateTimeConverter();

        RestStubConverterFactory(NameToTypeResolver nameToTypeResolver) {
            super(nameToTypeResolver);
        }

        @Override
        public UniTypeConverter<StructValue, StructType> getStructConverter() {
            return this.skipUnsetFieldsStructConverter;
        }

        @Override
        public UniTypeConverter<DataValue, MapType> getMapConverter() {
            return this.structMapConverter;
        }

        @Override
        public PrimitiveConverter<StringValue> getDateTimeConverter() {
            return this.rfc3339DateTimeConverter;
        }
    }
}

