/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientHeadersProvider;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.ConnectionMonitor;
import com.vmware.vapi.internal.protocol.client.rpc.http.SslClientUtil;
import com.vmware.vapi.internal.util.DefaultThreadFactory;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.util.concurrent.ThreadFactory;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheNioHttpClientBuilder {
    private NHttpClientConnectionManager connManager;
    private static Logger logger = LoggerFactory.getLogger(ApacheNioHttpClientBuilder.class);
    private ConnectionMonitor.CleanableConnectionPool pool;

    public CloseableHttpAsyncClient buildAndConfigure(final HttpConfiguration httpConfig) {
        Validate.notNull(httpConfig);
        try {
            this.connManager = this.createConnectionManager(httpConfig);
            HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setConnectionManager(this.connManager).setUserAgent(ApacheHttpUtil.VAPI_USER_AGENT).setThreadFactory((ThreadFactory)new DefaultThreadFactory("vAPI-I/O reactor-")).setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    return httpConfig.getKeepAlivePeriod();
                }
            });
            HttpConfiguration.HeadersProvider headersProvider = httpConfig.getHeadersProvider();
            if (headersProvider != null) {
                builder.addInterceptorFirst((HttpRequestInterceptor)new ApacheClientHeadersProvider(headersProvider));
            }
            CloseableHttpAsyncClient client = builder.build();
            client.start();
            return client;
        }
        catch (IOReactorException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ConnectionMonitor.CleanableConnectionPool registerClientWithConnectionMonitor() {
        if (this.connManager == null) {
            throw new IllegalStateException();
        }
        if (this.pool == null) {
            this.pool = new ConnectionMonitor.CleanableConnectionPool(){

                @Override
                public void closeExpiredConnections() {
                    ApacheNioHttpClientBuilder.this.connManager.closeExpiredConnections();
                }
            };
            ConnectionMonitor.register(this.pool);
        } else {
            logger.warn("Unable to register client more than once!");
        }
        return this.pool;
    }

    private NHttpClientConnectionManager createConnectionManager(HttpConfiguration config) throws IOReactorException {
        ConnectingIOReactor ioreactor = this.createConnectionIOReactor(config);
        Registry<SchemeIOSessionStrategy> schemeRegistry = this.createAsyncSchemeRegistry(config);
        PoolingNHttpClientConnectionManager cm = new PoolingNHttpClientConnectionManager(ioreactor, schemeRegistry);
        cm.setMaxTotal(config.getMaxConnections());
        cm.setDefaultMaxPerRoute(config.getMaxConnections());
        return cm;
    }

    private ConnectingIOReactor createConnectionIOReactor(HttpConfiguration config) throws IOReactorException {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(config.getIoThreadCount()).setSoTimeout(config.getSoTimeout()).setConnectTimeout(config.getConnectTimeout()).build();
        return new DefaultConnectingIOReactor(ioReactorConfig, (ThreadFactory)new DefaultThreadFactory("vAPI-I/O dispatcher-"));
    }

    private Registry<SchemeIOSessionStrategy> createAsyncSchemeRegistry(HttpConfiguration config) {
        HttpConfiguration.SslConfiguration sslConfig = config.getSslConfiguration();
        X509HostnameVerifier hostnameVerifier = SslClientUtil.createHostnameVerifier(sslConfig.isHostnameVerificationDisabled(), SSLIOSessionStrategy.STRICT_HOSTNAME_VERIFIER);
        return RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(SslClientUtil.createSslContext(sslConfig), sslConfig.getEnabledProtocols(), sslConfig.getEnabledCipherSuites(), hostnameVerifier)).build();
    }
}

