/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http.handle;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.http.handle.NioDecoratorConsumer;
import com.vmware.vapi.internal.protocol.client.rpc.http.handle.NioMultiResponseConsumer;
import com.vmware.vapi.internal.protocol.client.rpc.http.handle.NioSingleResponseConsumer;
import com.vmware.vapi.internal.protocol.client.rpc.http.handle.NioStreamingResponseConsumer;
import com.vmware.vapi.internal.protocol.common.http.impl.ChunkedTransferEncodingFrameDeserializer;
import java.io.IOException;
import java.util.Collection;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioMainResponseConsumer
extends NioDecoratorConsumer {
    private final CorrelatingClient.ResponseCallbackFactory cbFactory;
    private final Collection<String> acceptTypes;
    private final AbortHandle abortHandle;
    private final ExecutionContext ctx;
    private static Logger logger = LoggerFactory.getLogger(NioMainResponseConsumer.class);

    public NioMainResponseConsumer(CorrelatingClient.ResponseCallbackFactory cbFactory, ExecutionContext ctx, Collection<String> acceptTypes, AbortHandle abortHandle) {
        this.cbFactory = cbFactory;
        this.ctx = ctx;
        this.acceptTypes = acceptTypes;
        this.abortHandle = abortHandle;
    }

    @Override
    public void responseReceived(HttpResponse response) throws IOException, HttpException {
        String contentType = this.getContentType(response);
        CorrelatingClient.ResponseCallbackParams params = new CorrelatingClient.ResponseCallbackParams(contentType);
        CorrelatingClient.ResponseCallback cb = this.cbFactory.createResponseCallback(params);
        switch (contentType) {
            case "application/vnd.vmware.vapi.stream.json": {
                this.decorated = new NioStreamingResponseConsumer(new ChunkedTransferEncodingFrameDeserializer(), cb, this.abortHandle, this.ctx);
                break;
            }
            case "application/vnd.vmware.vapi.framed": {
                this.decorated = new NioMultiResponseConsumer(new ChunkedTransferEncodingFrameDeserializer(), cb);
                break;
            }
            default: {
                this.decorated = new NioSingleResponseConsumer(cb, this.acceptTypes, this.abortHandle);
            }
        }
        this.decorated.responseReceived(response);
    }

    private String getContentType(HttpResponse response) {
        Header ct = response.getFirstHeader("Content-Type");
        String contentType = "";
        if (ct != null) {
            contentType = ct.getValue();
        }
        logger.debug("Receiving HTTP response with content-type '" + contentType + "'");
        return contentType;
    }
}

