/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http.handle;

import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.common.http.BinaryInput;
import com.vmware.vapi.internal.protocol.common.http.FrameDeserializer;
import com.vmware.vapi.internal.protocol.common.http.impl.ByteBufferBinaryInput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.http.HttpResponse;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AsyncByteConsumer;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioMultiResponseConsumer
extends AsyncByteConsumer<HttpResponse> {
    private volatile HttpResponse httpResponse;
    private final CorrelatingClient.ResponseCallback callback;
    private final FrameDeserializer deserializer;
    private static Logger logger = LoggerFactory.getLogger(NioMultiResponseConsumer.class);

    public NioMultiResponseConsumer(FrameDeserializer deserializer, CorrelatingClient.ResponseCallback callback) {
        this.deserializer = deserializer;
        this.callback = callback;
    }

    protected void onResponseReceived(HttpResponse response) {
        this.httpResponse = response;
    }

    protected void onByteReceived(ByteBuffer buf, IOControl ioctrl) throws IOException {
        byte[] frame;
        ByteBufferBinaryInput input = new ByteBufferBinaryInput(buf);
        while ((frame = this.readFrame(input)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Received response frame with size " + frame.length);
            }
            this.callback.received(new ByteArrayInputStream(frame), CorrelatingClient.NO_OP_CONTROL);
        }
    }

    protected HttpResponse buildResult(HttpContext context) {
        logger.debug("Streaming HTTP response complete");
        return this.httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFrame(BinaryInput input) throws IOException {
        FrameDeserializer frameDeserializer = this.deserializer;
        synchronized (frameDeserializer) {
            return this.deserializer.readFrame(input);
        }
    }
}

