/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http.handle;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.diagnostics.LogDiagnosticUtil;
import com.vmware.vapi.diagnostics.Slf4jMDCLogConfigurator;
import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.core.abort.AbortListener;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.common.http.ApacheHttpClientExceptionTranslator;
import com.vmware.vapi.internal.protocol.common.http.BinaryInput;
import com.vmware.vapi.internal.protocol.common.http.FrameDeserializer;
import com.vmware.vapi.internal.protocol.common.http.impl.ByteBufferBinaryInput;
import com.vmware.vapi.internal.util.Validate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpResponse;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AsyncByteConsumer;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioStreamingResponseConsumer
extends AsyncByteConsumer<HttpResponse>
implements AbortListener {
    private volatile HttpResponse httpResponse;
    private final CorrelatingClient.ResponseCallback callback;
    private final FrameDeserializer deserializer;
    private final AbortHandle abortHandle;
    private final ExecutionContext ctx;
    private CorrelatingClient.TransportControl transportControl;
    private static Logger logger = LoggerFactory.getLogger(NioStreamingResponseConsumer.class);
    private volatile AbortState abortState;

    public NioStreamingResponseConsumer(FrameDeserializer deserializer, CorrelatingClient.ResponseCallback callback, AbortHandle abortHandle, ExecutionContext ctx) {
        Validate.notNull(deserializer);
        Validate.notNull(callback);
        this.deserializer = deserializer;
        this.callback = callback;
        this.ctx = ctx;
        this.abortHandle = abortHandle;
        this.abortState = AbortState.INITIAL;
    }

    protected void onResponseReceived(HttpResponse response) {
        this.httpResponse = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onByteReceived(ByteBuffer buf, IOControl ioctrl) throws IOException {
        Slf4jMDCLogConfigurator logConfig = new Slf4jMDCLogConfigurator();
        try {
            logConfig.configureContext(LogDiagnosticUtil.getDiagnosticContext(this.ctx));
            logger.debug("OnByteReceived event triggered.");
            ioctrl.suspendInput();
            ByteBufferBinaryInput input = new ByteBufferBinaryInput(buf.asReadOnlyBuffer());
            NioControl control = new NioControl(ioctrl, input, this.callback, this.abortHandle, this.deserializer, this.ctx);
            this.registerStreamingAbortListener(control);
            control.resumeRead();
        }
        finally {
            logConfig.cleanUpContext(LogDiagnosticUtil.getDiagnosticKeys());
        }
    }

    private void registerStreamingAbortListener(CorrelatingClient.TransportControl control) {
        this.transportControl = control;
        logger.trace("Updated transport control reference - %h.");
        if (this.abortHandle == null) {
            logger.debug("Abort listener not registered - no abort handle is supplied.");
            return;
        }
        if (this.abortState.equals((Object)AbortState.INITIAL)) {
            logger.trace("AbortListener is being attached.");
            this.abortHandle.addAbortListener(this);
            this.abortState = AbortState.REGISTERED;
            if (this.abortHandle.isAborted()) {
                this.onAbort();
            }
        }
    }

    protected HttpResponse buildResult(HttpContext context) {
        Slf4jMDCLogConfigurator logConfig = new Slf4jMDCLogConfigurator();
        try {
            logConfig.configureContext(LogDiagnosticUtil.getDiagnosticContext(this.ctx));
            logger.debug("Streaming HTTP response complete");
        }
        finally {
            logConfig.cleanUpContext(LogDiagnosticUtil.getDiagnosticKeys());
        }
        return this.httpResponse;
    }

    @Override
    public synchronized void onAbort() {
        logger.trace("On abort event has been invoked.");
        if (this.abortState.equals((Object)AbortState.REGISTERED)) {
            try {
                logger.debug("Shutting down streaming channel.");
                this.transportControl.cancel();
            }
            catch (Exception e) {
                logger.debug("IOControl shutdown failed.", (Throwable)e);
            }
            finally {
                this.abortState = AbortState.ABORTED;
            }
        }
    }

    private static class NioControl
    implements CorrelatingClient.TransportControl {
        private final FrameDeserializer deserializer;
        private final ExecutionContext ctx;
        private IOControl ioControl;
        private ByteBufferBinaryInput input;
        private CorrelatingClient.ResponseCallback cb;
        private AbortHandle abortHandle;
        private volatile boolean aborted = false;
        private volatile boolean finished = false;
        private volatile boolean readSuspended = false;
        private ReentrantLock lock;

        public NioControl(IOControl ioControl, ByteBufferBinaryInput input, CorrelatingClient.ResponseCallback cb, AbortHandle abortHandle, FrameDeserializer deselrializer, ExecutionContext ctx) {
            this.ioControl = ioControl;
            this.input = input;
            this.cb = cb;
            this.deserializer = deselrializer;
            this.ctx = ctx;
            this.abortHandle = abortHandle;
            this.lock = new ReentrantLock();
        }

        @Override
        public void suspendRead() {
            logger.trace(String.format("Suspending read in TransportControl - %h.", this));
            this.readSuspended = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resumeRead() {
            block8: {
                logger.trace(String.format("Resuming read in TransportControl - %h.", this));
                Slf4jMDCLogConfigurator logConfig = new Slf4jMDCLogConfigurator();
                if (this.lock.isHeldByCurrentThread()) {
                    this.readSuspended = false;
                    logger.trace(String.format("The same thread is already reading frames in TransportControl - %h.", this));
                    return;
                }
                this.lock.lock();
                this.readSuspended = false;
                byte[] frame = null;
                try {
                    if (this.input == null) break block8;
                    logConfig.configureContext(LogDiagnosticUtil.getDiagnosticContext(this.ctx));
                    while (!this.readSuspended && !this.aborted) {
                        logger.trace(String.format("Reading frames in TransportControl - %h.", this));
                        frame = this.readFrame(this.input);
                        if (frame == null || frame.length == 0) {
                            this.input = null;
                            logger.debug(String.format("Finished reading - request additional input in TransportControl - %h.", this));
                            this.finished = true;
                            this.ioControl.requestInput();
                            break;
                        }
                        this.cb.received(new ByteArrayInputStream(frame), this);
                    }
                }
                catch (IOException ex) {
                    logger.debug("Error during reading frames.", (Throwable)ex);
                    this.cb.failed(ApacheHttpClientExceptionTranslator.translate(ex, this.abortHandle, ""));
                }
                finally {
                    this.lock.unlock();
                    logConfig.cleanUpContext(LogDiagnosticUtil.getDiagnosticKeys());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] readFrame(BinaryInput input) throws IOException {
            FrameDeserializer frameDeserializer = this.deserializer;
            synchronized (frameDeserializer) {
                return this.deserializer.readFrame(input);
            }
        }

        @Override
        public void cancel() {
            logger.debug(String.format("Cancelling the streaming frame desirialization in TransportControl - %h.", this));
            try {
                if (!this.finished) {
                    logger.debug(String.format("Shutting down underlying channel in TransportControl - %h.", this));
                    this.ioControl.shutdown();
                }
                this.aborted = true;
                if (this.lock.tryLock()) {
                    this.input = null;
                    this.lock.unlock();
                }
                logger.debug(String.format("Streaming frame desirialization cancelled in TransportControl - %h.", this));
            }
            catch (IOException e) {
                logger.warn("Exception while trying to shutdown the IOcontrol", (Throwable)e);
            }
        }
    }

    private static enum AbortState {
        INITIAL,
        REGISTERED,
        ABORTED;

    }
}

