/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.UserSession;
import com.vmware.vim.binding.vim.version.v7_0_2_0;
import com.vmware.vim.binding.vim.version.version1;
import com.vmware.vim.binding.vim.version.version2;
import com.vmware.vim.binding.vim.version.version3;
import com.vmware.vim.binding.vim.version.version5;
import com.vmware.vim.binding.vim.version.version7;
import com.vmware.vim.binding.vim.version.version8;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.MethodName;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.internal;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.secret;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@managed
@versionClass(value=version1.class)
@wsdlName(value="SessionManager")
public interface SessionManager
extends ManagedObject {
    @readonly
    @name(value="sessionList")
    @privilege(value="Sessions.TerminateSession")
    @versionClass(value=version1.class)
    @optional
    @map
    public void getSessionList(@optional Future<UserSession[]> var1);

    @readonly
    @name(value="currentSession")
    @privilege(value="System.Anonymous")
    @versionClass(value=version1.class)
    @optional
    public void getCurrentSession(@optional Future<UserSession> var1);

    @readonly
    @name(value="message")
    @privilege(value="System.View")
    @versionClass(value=version1.class)
    @optional
    public void getMessage(@optional Future<String> var1);

    @readonly
    @name(value="messageLocaleList")
    @privilege(value="System.Anonymous")
    @versionClass(value=version1.class)
    @optional
    @map
    public void getMessageLocaleList(@optional Future<String[]> var1);

    @readonly
    @name(value="supportedLocaleList")
    @privilege(value="System.Anonymous")
    @versionClass(value=version1.class)
    @optional
    @map
    public void getSupportedLocaleList(@optional Future<String[]> var1);

    @readonly
    @name(value="defaultLocale")
    @privilege(value="System.Anonymous")
    @versionClass(value=version1.class)
    public void getDefaultLocale(Future<String> var1);

    @versionClass(value=version3.class)
    @wsdlName(value="AcquireCloneTicket")
    @privilege(value="System.View")
    public void acquireCloneTicket(@secret Future<String> var1);

    @versionClass(value=version7.class)
    @wsdlName(value="AcquireGenericServiceTicket")
    @privilege(value="System.Anonymous")
    public void acquireGenericServiceTicket(@name(value="spec") @versionClass(value=version7.class) ServiceRequestSpec var1, Future<GenericServiceTicket> var2);

    @versionClass(value=version1.class)
    @wsdlName(value="AcquireLocalTicket")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin"})
    public void acquireLocalTicket(@name(value="userName") @versionClass(value=version1.class) String var1, Future<LocalTicket> var2);

    @versionClass(value=version5.class)
    @wsdlName(value="AcquireSessionTicket")
    @privilege(value="System.Anonymous")
    @internal
    @faults(value={"NotFound", "TooManyTickets", "NoHost", "NotSupportedHost", "InvalidLogin"})
    @Deprecated
    public void acquireSessionTicket(@name(value="serviceKey") @versionClass(value=version5.class) @optional String var1, @secret Future<String> var2);

    @versionClass(value=version3.class)
    @wsdlName(value="CloneSession")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin"})
    public void cloneSession(@name(value="cloneTicket") @versionClass(value=version3.class) @secret String var1, Future<UserSession> var2);

    @versionClass(value=version2.class)
    @wsdlName(value="ImpersonateUser")
    @privilege(value="Sessions.ImpersonateUser")
    @faults(value={"InvalidLogin", "InvalidLocale"})
    public void impersonateUser(@name(value="userName") @versionClass(value=version2.class) String var1, @name(value="locale") @versionClass(value=version2.class) @optional String var2, Future<UserSession> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="Login")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin", "InvalidLocale"})
    public void login(@name(value="userName") @versionClass(value=version1.class) String var1, @name(value="password") @versionClass(value=version1.class) @secret String var2, @name(value="locale") @versionClass(value=version1.class) @optional String var3, Future<UserSession> var4);

    @versionClass(value=version5.class)
    @wsdlName(value="LoginBySSLThumbprint")
    @privilege(value="System.Anonymous")
    @internal
    @faults(value={"InvalidLogin", "NoClientCertificate", "UserNotFound", "InvalidLocale", "NotSupported"})
    public void loginBySSLThumbprint(@name(value="locale") @versionClass(value=version5.class) @optional String var1, Future<UserSession> var2);

    @versionClass(value=version2.class)
    @wsdlName(value="LoginBySSPI")
    @privilege(value="System.Anonymous")
    @faults(value={"SSPIChallenge", "InvalidLogin", "InvalidLocale"})
    public void loginBySSPI(@name(value="base64Token") @versionClass(value=version2.class) String var1, @name(value="locale") @versionClass(value=version2.class) @optional String var2, Future<UserSession> var3);

    @versionClass(value=version5.class)
    @wsdlName(value="LoginBySessionTicket")
    @privilege(value="System.Anonymous")
    @internal
    @faults(value={"InvalidTicket", "UserNotFound", "NotSupported"})
    @Deprecated
    public void loginBySessionTicket(@name(value="ticketData") @versionClass(value=version5.class) @secret String var1, Future<UserSession> var2);

    @versionClass(value=version8.class)
    @wsdlName(value="LoginByToken")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin", "InvalidLocale"})
    public void loginByToken(@name(value="locale") @versionClass(value=version8.class) @optional String var1, Future<UserSession> var2);

    @versionClass(value=version5.class)
    @wsdlName(value="LoginExtensionByCertificate")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin", "InvalidLocale", "NoClientCertificate"})
    @Deprecated
    public void loginExtensionByCertificate(@name(value="extensionKey") @versionClass(value=version5.class) String var1, @name(value="locale") @versionClass(value=version5.class) @optional String var2, Future<UserSession> var3);

    @versionClass(value=version2.class)
    @wsdlName(value="LoginExtensionBySubjectName")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin", "InvalidLocale", "NotFound", "NoClientCertificate", "NoSubjectName"})
    @Deprecated
    public void loginExtensionBySubjectName(@name(value="extensionKey") @versionClass(value=version2.class) String var1, @name(value="locale") @versionClass(value=version2.class) @optional String var2, Future<UserSession> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="Logout")
    @privilege(value="System.View")
    public void logout(Future<Void> var1);

    @versionClass(value=version2.class)
    @wsdlName(value="SessionIsActive")
    @privilege(value="Sessions.ValidateSession")
    public void sessionIsActive(@name(value="sessionID") @versionClass(value=version2.class) String var1, @name(value="userName") @versionClass(value=version2.class) String var2, Future<Boolean> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="SetLocale")
    @privilege(value="System.View")
    @faults(value={"InvalidLocale"})
    public void setLocale(@name(value="locale") @versionClass(value=version1.class) String var1, Future<Void> var2);

    @versionClass(value=version1.class)
    @wsdlName(value="TerminateSession")
    @privilege(value="Sessions.TerminateSession")
    @faults(value={"NotFound"})
    public void terminate(@name(value="sessionId") @versionClass(value=version1.class) @map String[] var1, Future<Void> var2);

    @versionClass(value=version1.class)
    @wsdlName(value="UpdateServiceMessage")
    @privilege(value="Sessions.GlobalMessage")
    public void updateMessage(@name(value="message") @versionClass(value=version1.class) String var1, Future<Void> var2);

    @versionClass(value=version8.class)
    @wsdlName(value="SessionManagerVmomiServiceRequestSpec")
    @data
    @propertyOrder(value={"method"})
    public static class VmomiServiceRequestSpec
    extends ServiceRequestSpec {
        private static final long serialVersionUID = 1L;
        public MethodName method;

        public VmomiServiceRequestSpec() {
        }

        public VmomiServiceRequestSpec(MethodName method) {
            this.method = method;
        }

        @versionClass(value=version8.class)
        public MethodName getMethod() {
            return this.method;
        }

        @versionClass(value=version8.class)
        public void setMethod(MethodName method) {
            this.method = method;
        }

        @Override
        public String toString() {
            StringBuilder objString = new StringBuilder(120);
            objString.append("(vim.VmomiServiceRequestSpec) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("method = ");
            objString.append(this.getMethod());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version7.class)
    @wsdlName(value="SessionManagerServiceRequestSpec")
    @data
    public static class ServiceRequestSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;

        public String toString() {
            StringBuilder objString = new StringBuilder(80);
            objString.append("(vim.ServiceRequestSpec) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version1.class)
    @wsdlName(value="SessionManagerLocalTicket")
    @data
    @propertyOrder(value={"userName", "passwordFilePath"})
    public static class LocalTicket
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String userName;
        public String passwordFilePath;

        public LocalTicket() {
        }

        public LocalTicket(String userName, String passwordFilePath) {
            this.userName = userName;
            this.passwordFilePath = passwordFilePath;
        }

        @versionClass(value=version1.class)
        public String getUserName() {
            return this.userName;
        }

        @versionClass(value=version1.class)
        public void setUserName(String userName) {
            this.userName = userName;
        }

        @versionClass(value=version1.class)
        public String getPasswordFilePath() {
            return this.passwordFilePath;
        }

        @versionClass(value=version1.class)
        public void setPasswordFilePath(String passwordFilePath) {
            this.passwordFilePath = passwordFilePath;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(160);
            objString.append("(vim.LocalTicket) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("userName = ");
            objString.append(this.getUserName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("passwordFilePath = ");
            objString.append(this.getPasswordFilePath());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version7.class)
    @wsdlName(value="SessionManagerHttpServiceRequestSpec")
    @data
    @propertyOrder(value={"method", "url"})
    public static class HttpServiceRequestSpec
    extends ServiceRequestSpec {
        private static final long serialVersionUID = 1L;
        public String method;
        public String url;

        public HttpServiceRequestSpec() {
        }

        public HttpServiceRequestSpec(String method, String url) {
            this.method = method;
            this.url = url;
        }

        @optional
        @versionClass(value=version7.class)
        public String getMethod() {
            return this.method;
        }

        @optional
        @versionClass(value=version7.class)
        public void setMethod(String method) {
            this.method = method;
        }

        @versionClass(value=version7.class)
        public String getUrl() {
            return this.url;
        }

        @versionClass(value=version7.class)
        public void setUrl(String url) {
            this.url = url;
        }

        @Override
        public String toString() {
            StringBuilder objString = new StringBuilder(160);
            objString.append("(vim.HttpServiceRequestSpec) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("method = ");
            objString.append(this.getMethod());
            objString.append(",\n");
            objString.append("   ");
            objString.append("url = ");
            objString.append(this.getUrl());
            objString.append("\n}");
            return objString.toString();
        }

        @versionClass(value=version7.class)
        @wsdlName(value="SessionManagerHttpServiceRequestSpecMethod")
        public static enum Method {
            httpOptions,
            httpGet,
            httpHead,
            httpPost,
            httpPut,
            httpDelete,
            httpTrace,
            httpConnect;

        }
    }

    @versionClass(value=version7.class)
    @wsdlName(value="SessionManagerGenericServiceTicket")
    @data
    @propertyOrder(value={"id", "hostName", "sslThumbprint", "ticketType"})
    public static class GenericServiceTicket
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String id;
        public String hostName;
        public String sslThumbprint;
        public String ticketType;

        public GenericServiceTicket() {
        }

        public GenericServiceTicket(String id, String hostName, String sslThumbprint, String ticketType) {
            this.id = id;
            this.hostName = hostName;
            this.sslThumbprint = sslThumbprint;
            this.ticketType = ticketType;
        }

        @secret
        @versionClass(value=version7.class)
        public String getId() {
            return this.id;
        }

        @secret
        @versionClass(value=version7.class)
        public void setId(String id) {
            this.id = id;
        }

        @optional
        @versionClass(value=version8.class)
        public String getHostName() {
            return this.hostName;
        }

        @optional
        @versionClass(value=version8.class)
        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @optional
        @versionClass(value=version8.class)
        public String getSslThumbprint() {
            return this.sslThumbprint;
        }

        @optional
        @versionClass(value=version8.class)
        public void setSslThumbprint(String sslThumbprint) {
            this.sslThumbprint = sslThumbprint;
        }

        @optional
        @versionClass(value=v7_0_2_0.class)
        public String getTicketType() {
            return this.ticketType;
        }

        @optional
        @versionClass(value=v7_0_2_0.class)
        public void setTicketType(String ticketType) {
            this.ticketType = ticketType;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(240);
            objString.append("(vim.GenericServiceTicket) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("id = ");
            if (this.getId() == null) {
                objString.append("null");
            } else {
                objString.append("(not shown)");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("hostName = ");
            objString.append(this.getHostName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("sslThumbprint = ");
            objString.append(this.getSslThumbprint());
            objString.append(",\n");
            objString.append("   ");
            objString.append("ticketType = ");
            objString.append(this.getTicketType());
            objString.append("\n}");
            return objString.toString();
        }

        @versionClass(value=v7_0_2_0.class)
        @wsdlName(value="SessionManagerGenericServiceTicketTicketType")
        public static enum TicketType {
            HttpNfcServiceTicket,
            HostServiceTicket,
            VcServiceTicket;

        }
    }
}

