/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.reactive.impl;

import com.vmware.dr.ui.tools.reactive.Subscriber;
import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberWrapper<T>
implements Subscriber<T> {
    private final Logger LOGGER = LoggerFactory.getLogger(SubscriberWrapper.class);
    private static final int IDLE = 0;
    private static final int NOTIFY = 1;
    private static final int COMPLETING = 3;
    private static final int COMPLETE = 4;
    protected final Subscriber<? super T> _delegate;
    private final ThreadContext _context = ThreadContext.get();
    private final Queue<Node> _queue = new LinkedBlockingQueue<Node>();
    private final AtomicInteger _state = new AtomicInteger(0);
    private boolean _cancelled;
    private Exception _err;
    private final AtomicBoolean _complete = new AtomicBoolean(false);

    public static <T> Subscriber<T> wrap(Subscriber<? super T> delegate) {
        return new SubscriberWrapper<T>(delegate);
    }

    public SubscriberWrapper(Subscriber<? super T> delegate) {
        Validate.notNull(delegate, (String)"delegate");
        this._delegate = delegate;
    }

    public String toString() {
        return "Wrapper for '" + this._delegate + "'";
    }

    @Override
    public void onNext(T item) {
        this._queue.add(new Node(item));
        block2: while (this._state.compareAndSet(0, 1)) {
            while (!this._queue.isEmpty()) {
                if (this._state.get() > 1) {
                    this.doComplete();
                    break block2;
                }
                Node next = this._queue.poll();
                if (next == null) continue;
                try {
                    ThreadContext.setupContext(() -> this._delegate.onNext(node.item), (ThreadContext)this._context);
                }
                catch (Throwable t) {
                    this._err = Exceptions.wrap(t);
                    this._state.set(3);
                    this.doComplete();
                    break block2;
                }
            }
            if (!this._state.compareAndSet(1, 0)) {
                this.doComplete();
                break;
            }
            if (!this._queue.isEmpty()) continue;
        }
        if (this._state.get() > 1) {
            this._queue.clear();
        }
    }

    @Override
    public void onComplete(boolean cancelled) {
        if (!this._complete.compareAndSet(false, true)) {
            return;
        }
        this._cancelled = cancelled;
        do {
            if (this._state.compareAndSet(0, 3)) {
                this.doComplete();
                return;
            }
            int state = this._state.get();
            if (state <= 1) continue;
            return;
        } while (!this._state.compareAndSet(1, 3));
    }

    @Override
    public void onError(Exception err) {
        Validate.notNull((Object)err, (String)"err");
        if (!this._complete.compareAndSet(false, true)) {
            return;
        }
        this._err = err;
        do {
            if (this._state.compareAndSet(0, 3)) {
                this.doComplete();
                return;
            }
            int state = this._state.get();
            if (state <= 1) continue;
            return;
        } while (!this._state.compareAndSet(1, 3));
    }

    private void doComplete() {
        if (!this._state.compareAndSet(3, 4)) {
            return;
        }
        try {
            ThreadContext.setupContext(() -> {
                if (this._err == null) {
                    this._delegate.onComplete(this._cancelled);
                } else {
                    this._delegate.onError(this._err);
                }
            }, (ThreadContext)this._context);
        }
        catch (Throwable t) {
            this.LOGGER.warn("Delegate '{}' failed.", this._delegate, (Object)t);
        }
    }

    private class Node {
        final T item;

        Node(T item) {
            this.item = item;
        }
    }
}

