/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.reactive.impl.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executors {
    private static final int EXEC_CORE_SIZE = 16;
    private static final Logger LOGGER = LoggerFactory.getLogger(Executors.class);
    private static final ThreadPoolExecutor EXEC = new ThreadPoolExecutor(16, 16, 60L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), (ThreadFactory)new ThreadFactoryImpl("srm-reactive-thread")){

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t != null) {
                LOGGER.warn("Task finished with error: ", t);
            }
        }
    };

    public static ExecutorService getExecutor() {
        return EXEC;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EXEC.shutdown();
            }
        });
    }

    public static class ThreadFactoryImpl
    implements ThreadFactory {
        final AtomicInteger nextThread = new AtomicInteger(1);
        final String threadPrefix;

        public ThreadFactoryImpl(String prefix) {
            this.threadPrefix = prefix + "-%s";
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = String.format(this.threadPrefix, this.nextThread.getAndIncrement());
            Thread t = new Thread(r, name){

                @Override
                public void setContextClassLoader(ClassLoader cl) {
                    super.setContextClassLoader(cl);
                    if (Executors.class.getClassLoader() != cl) {
                        LOGGER.warn("Overriding classloader with: '{}'", (Object)cl, (Object)new RuntimeException());
                    }
                }
            };
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            t.setContextClassLoader(Executors.class.getClassLoader());
            return t;
        }
    }
}

