/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.srm.client.topology.client.view.availability.hms.HmsPairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmPairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.ServersViewRecorder;
import com.vmware.srm.client.topology.impl.view.availability.PairSetupImpl;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServersViewRecorderImpl
implements ServersViewRecorder {
    private static final String APPENDER_NAME = "TOPOLOGY_RECORD_FILE";
    private static final String RECORD_LOGGER_LABEL = "dr.client.record";
    private static final String CATALINA_BASE_PROP = "catalina.base";
    private static final String LOGS_DIR = "logs";
    private static final String RECORD_LOG_FILE = "topology-record.log";
    private static final String RECORD_LOG_FILE_PATTERN = "topology-record.%i.log.gz";
    private static final String RECORD_LOG_SIZE = "512K";
    private static final String PATTERN_LAYOUT = "%c %m%n%throwable";
    private static final Logger LOCAL_RECORD_LOGGER;
    private static final Logger REMOTE_RECORD_LOGGER;

    @Override
    public void recordVc(VcServer vcServer) {
        Logger logger = vcServer.isLocal() ? LOCAL_RECORD_LOGGER : REMOTE_RECORD_LOGGER;
        URI vcUrl = vcServer.url();
        String vcGuid = vcServer.guid();
        URI pbmUrl = vcServer.spbmService().getServerUrl();
        vcServer.spbmService().getGuid().onSuccess(pbmGuid -> logger.info("VC: url '{}' guid '{}'. PBM: url '{}' guid '{}'", new Object[]{vcUrl, vcGuid, pbmUrl, pbmGuid}));
    }

    @Override
    public void recordSrm(SrmServer srm) {
        Logger logger = srm.isLocal() ? LOCAL_RECORD_LOGGER : REMOTE_RECORD_LOGGER;
        URI srmUrl = srm.url();
        String srmGuid = srm.guid();
        String vcGuid = srm.vc().guid();
        logger.info("SRM: url '{}' guid '{}' vcGuid '{}'", new Object[]{srmUrl, srmGuid, vcGuid});
    }

    @Override
    public void recordSrmPair(SrmPairSetup ps) {
        Logger logger = ((SrmServer)ps.server()).isLocal() ? LOCAL_RECORD_LOGGER : REMOTE_RECORD_LOGGER;
        String srmGuid = ((SrmServer)ps.server()).guid();
        URI pairLsppUrl = ((PairSetupImpl)((Object)ps)).pairLsppUrl();
        String pairLsppThumbprint = ((PairSetupImpl)((Object)ps)).pairLsppThumbprint();
        logger.info("SrmPairSetup: srmGuid '{}' pairLsppUrl '{}' pairLsppTp '{}' pairServerName '{}' pairServerGuid '{}' pairVcGuid '{}' pairVcName '{}' pairServerRef '{}' pairVcUrl '{}' pairSrmUrl '{}'", new Object[]{srmGuid, pairLsppUrl, pairLsppThumbprint, ps.pairServerName(), ps.pairServerGuid(), ps.pairVcGuid(), ps.pairVcName(), ps.pairServerVmomiRef(), ps.pairVcUrl(), ps.pairSrmUrl()});
    }

    @Override
    public void recordHms(HmsServer hms) {
        Logger logger = hms.isLocal() ? LOCAL_RECORD_LOGGER : REMOTE_RECORD_LOGGER;
        URI hmsUrl = hms.url();
        String hmsGuid = hms.guid();
        String vcGuid = hms.vc().guid();
        logger.info("HMS: url '{}' guid '{}' vcGuid '{}'", new Object[]{hmsUrl, hmsGuid, vcGuid});
    }

    @Override
    public void recordHmsPair(HmsPairSetup ps) {
        Logger logger = ((HmsServer)ps.server()).isLocal() ? LOCAL_RECORD_LOGGER : REMOTE_RECORD_LOGGER;
        String hmsGuid = ((HmsServer)ps.server()).guid();
        URI pairLsppUrl = ((PairSetupImpl)((Object)ps)).pairLsppUrl();
        String pairLsppThumbprint = ((PairSetupImpl)((Object)ps)).pairLsppThumbprint();
        logger.info("HmsPairSetup: hmsGuid '{}' pairLsppUrl '{}' pairLsppTp '{}' pairServerName '{}' pairServerGuid '{}' pairVcGuid '{}' pairVcName '{}' pairServerRef '{}' isROBO '{}'", new Object[]{hmsGuid, pairLsppUrl, pairLsppThumbprint, ps.pairServerName(), ps.pairServerGuid(), ps.pairVcGuid(), ps.pairVcName(), ps.pairServerVmomiRef(), ps.isSelfPair()});
    }

    static {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        String catalinaBase = System.getProperty(CATALINA_BASE_PROP);
        Path recordLogFile = Paths.get(catalinaBase, LOGS_DIR, RECORD_LOG_FILE);
        String pattern = Paths.get(catalinaBase, LOGS_DIR).toAbsolutePath().toString();
        if (!pattern.endsWith(File.separator)) {
            pattern = pattern + File.separator;
        }
        pattern = pattern + RECORD_LOG_FILE_PATTERN;
        DefaultRolloverStrategy rs = DefaultRolloverStrategy.newBuilder().withMax("1").build();
        SizeBasedTriggeringPolicy tp = SizeBasedTriggeringPolicy.createPolicy((String)RECORD_LOG_SIZE);
        PatternLayout pl = PatternLayout.newBuilder().withPattern(PATTERN_LAYOUT).build();
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName(APPENDER_NAME)).withFileName(recordLogFile.toAbsolutePath().toString()).withFilePattern(pattern).withStrategy((RolloverStrategy)rs).withPolicy((TriggeringPolicy)tp).setLayout((Layout)pl)).build();
        appender.start();
        config.addAppender((Appender)appender);
        AppenderRef ar = AppenderRef.createAppenderRef((String)APPENDER_NAME, null, null);
        LoggerConfig lc = LoggerConfig.createLogger((boolean)false, (Level)Level.TRACE, (String)RECORD_LOGGER_LABEL, (String)"false", (AppenderRef[])new AppenderRef[]{ar}, null, (Configuration)config, null);
        lc.addAppender((Appender)appender, null, null);
        config.addLogger(RECORD_LOGGER_LABEL, lc);
        ctx.updateLoggers();
        LOCAL_RECORD_LOGGER = LoggerFactory.getLogger((String)"dr.client.record.local");
        REMOTE_RECORD_LOGGER = LoggerFactory.getLogger((String)"dr.client.record.remote");
    }
}

