/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.dr.ui.tools.utilities.Disposable;
import com.vmware.srm.client.topology.impl.sso.DrSecurityTokenService;
import com.vmware.srm.client.topology.impl.sso.SsoFacade;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.exception.AuthenticationFailedException;
import java.net.URI;
import java.security.PrivateKey;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenProviderImpl
implements TokenProvider,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenProviderImpl.class);
    private final AtomicReference<DrSecurityTokenService> _stsRef = new AtomicReference<Object>(null);
    private final AtomicBoolean _disposed = new AtomicBoolean(false);

    @Override
    public boolean isTokenAvailable() {
        this.checkIfDisposed();
        DrSecurityTokenService sts = this._stsRef.get();
        return sts != null && SsoFacade.getTokenManager().getCurrentTokenFor(sts) != null;
    }

    @Override
    public SamlToken getToken() throws TokenProvider.AuthenticationTokenNotAvailable {
        this.checkIfDisposed();
        DrSecurityTokenService sts = this._stsRef.get();
        if (sts == null) {
            throw new TokenProvider.AuthenticationTokenNotAvailable(URI.create("unknown"));
        }
        SamlToken result = SsoFacade.getTokenManager().getCurrentTokenFor(sts);
        if (result == null) {
            throw new TokenProvider.AuthenticationTokenNotAvailable(sts.getUrl());
        }
        return result;
    }

    @Override
    public PrivateKey getPrivateKey() {
        this.checkIfDisposed();
        DrSecurityTokenService sts = this._stsRef.get();
        if (sts == null) {
            throw new IllegalStateException("sts");
        }
        return sts.getPrivateKey();
    }

    @Override
    public void login(String username, String password) throws TokenProvider.TokenExists, TokenProvider.AcquireTokenFailed {
        this.checkIfDisposed();
        DrSecurityTokenService sts = this._stsRef.get();
        if (sts == null) {
            throw new IllegalStateException("sts");
        }
        try {
            SsoFacade.getTokenManager().acquireToken(sts, username, password);
            if (this._disposed.get()) {
                SsoFacade.getTokenManager().releaseToken(sts);
                throw new RuntimeException(this.toString() + " is disposed.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to acquire token by credentials", (Throwable)e);
            if (e instanceof AuthenticationFailedException) {
                throw new TokenProvider.InvalidCredentialsException(e);
            }
            throw new TokenProvider.AcquireTokenFailed(sts.getUrl(), (Throwable)e);
        }
    }

    @Override
    public void login(SamlToken suToken, SamlToken actAsToken) {
        this.checkIfDisposed();
        DrSecurityTokenService sts = this._stsRef.get();
        if (sts == null) {
            throw new IllegalStateException("sts");
        }
        try {
            SsoFacade.getTokenManager().acquireImpersonatingToken(sts, suToken, actAsToken);
            if (this._disposed.get()) {
                SsoFacade.getTokenManager().releaseToken(sts);
                throw new RuntimeException(this.toString() + " is disposed.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to acquire impersonating token", (Throwable)e);
            if (e instanceof AuthenticationFailedException) {
                throw new TokenProvider.InvalidCredentialsException(e);
            }
            throw new TokenProvider.AcquireTokenFailed(sts.getUrl(), (Throwable)e);
        }
    }

    @Override
    public SamlToken acquireDelegatedToken(String delegateTo) throws TokenProvider.AuthenticationTokenNotAvailable, TokenProvider.AcquireTokenFailed {
        this.getToken();
        DrSecurityTokenService sts = this._stsRef.get();
        if (sts == null) {
            throw new IllegalStateException("sts");
        }
        try {
            return SsoFacade.getTokenManager().acquireDelegatedToken(sts, delegateTo);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to acquire delegated token", (Throwable)e);
            throw new TokenProvider.AcquireTokenFailed(sts.getUrl(), (Throwable)e);
        }
    }

    public void setSts(DrSecurityTokenService sts) {
        Validate.notNull((Object)sts, (String)"sts");
        this.checkIfDisposed();
        DrSecurityTokenService prev = this._stsRef.getAndSet(sts);
        if (prev != null) {
            this.disposeSts(prev);
        }
        if (this._disposed.get()) {
            this.disposeSts(sts);
            this.checkIfDisposed();
        }
    }

    public DrSecurityTokenService getSts() {
        return this._stsRef.get();
    }

    public void dispose() {
        if (this._disposed.getAndSet(true)) {
            return;
        }
        DrSecurityTokenService sts = this._stsRef.getAndSet(null);
        if (sts != null) {
            this.disposeSts(sts);
        }
    }

    private void checkIfDisposed() {
        if (this._disposed.get()) {
            throw new RuntimeException(this.toString() + " is disposed.");
        }
    }

    private void disposeSts(DrSecurityTokenService sts) {
        try {
            SsoFacade.getTokenManager().releaseToken(sts);
        }
        catch (Exception exc) {
            LOGGER.warn("Failed to dispose '{}'", (Object)sts, (Object)exc);
        }
        finally {
            sts.dispose();
        }
    }
}

