/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi;

import com.vmware.dr.ui.tools.utilities.OpIdAccessor;
import com.vmware.srm.client.topology.impl.utils.Exceptions;
import com.vmware.srm.client.topology.impl.vmomi.ConnectionParams;
import com.vmware.srm.client.topology.impl.vmomi.osgi.VmodlContextInitializer;
import com.vmware.srm.client.topology.impl.vmomi.ssl.Verifiers;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.ext.RequestRetryCallback;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfigurationCompiler;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationCompilerImpl;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientUtils.class);
    private static final int MAX_CONNECTIONS = 20;
    private static final int MAX_CONNECTIONS_PER_ROUTE = 20;

    public static ThumbprintVerifier createVerifier(String thumbprint) {
        return new Verifiers.DefaultVerifier(thumbprint);
    }

    public static ThumbprintVerifier createLoggingVerifier() {
        return new Verifiers.LoggingVerifier();
    }

    public static HttpConfiguration createHttpConfig(URI proxy, ThumbprintVerifier verifier, KeyStore keyStore) {
        HttpConfiguration httpConfig = HttpConfiguration.Factory.newInstance();
        if (proxy != null) {
            httpConfig.setDefaultProxy(proxy.getHost(), proxy.getPort(), proxy.getScheme());
        }
        httpConfig.setThumbprintVerifier(verifier);
        httpConfig.setTrustStore(keyStore);
        httpConfig.setMaxConnections(20);
        httpConfig.setDefaultMaxConnectionsPerRoute(20);
        httpConfig.setConnectTimeoutMs(ConnectionParams.getConnectTimeout());
        httpConfig.setTimeoutMs(ConnectionParams.getSocketTimeout());
        return httpConfig;
    }

    public static HttpClientConfiguration createClientConfig(HttpConfiguration httpConfig, Executor exe, InvocationInterceptor intercept, RequestRetryCallback callback) {
        HttpClientConfiguration clientConfig = HttpClientConfiguration.Factory.newInstance();
        clientConfig.setExecutor(exe);
        clientConfig.setHttpConfiguration(httpConfig);
        clientConfig.setInvocationInterceptor(intercept);
        clientConfig.setRequestRetryCallback(callback);
        clientConfig.setHttpConfigurationCompiler((HttpConfigurationCompiler)new Compiler(httpConfig.getTrustStore()));
        return clientConfig;
    }

    public static Client createVmomiClient(URI server, Class<? extends Annotation> vmodlVersion, HttpClientConfiguration clientConfig, VmodlContextInitializer vmodlInitializer) {
        if (vmodlInitializer == null) {
            throw new IllegalArgumentException("vmodlInitializer");
        }
        ClientUtils.waitToComplete(vmodlInitializer);
        return Client.Factory.createClient((URI)server, vmodlVersion, (VmodlContext)vmodlInitializer.getVmodlContext(), (ClientConfiguration)clientConfig);
    }

    public static void setOperationId(Stub stub) {
        String opId = OpIdAccessor.get();
        if (StringUtils.isEmpty((String)opId)) {
            LOGGER.warn("No opId defined for '{}'", (Object)stub);
            return;
        }
        RequestContext ctx = stub._getRequestContext();
        if (ctx == null) {
            ctx = new RequestContextImpl();
            stub._setRequestContext(ctx);
        }
        ctx.put((Object)"operationID", (Object)opId);
    }

    public static void setAuthenticationData(Stub stub, SamlToken token, PrivateKey key) {
        RequestContextImpl context = new RequestContextImpl();
        RequestContext prevContext = stub._getRequestContext();
        if (prevContext != null) {
            context.putAll((Map)prevContext);
        }
        context.setSignInfo((SignInfo)new SignInfoImpl(key, token));
        stub._setRequestContext((RequestContext)context);
    }

    private static <T extends ManagedObject> T createStub(ManagedObjectReference ref, Client client, VmodlTypeMap typeMap) {
        Class<T> clazz = ClientUtils.getClass(ref, typeMap);
        ManagedObject result = client.createStub(clazz, ref);
        ClientUtils.setOperationId((Stub)result);
        return (T)result;
    }

    public static <T extends ManagedObject> Class<T> getClass(ManagedObjectReference ref, VmodlTypeMap typeMap) {
        ManagedObjectType vmodlType = ClientUtils.getType(ref, typeMap);
        return vmodlType.getTypeClass();
    }

    public static ManagedObjectType getType(ManagedObjectReference ref, VmodlTypeMap typeMap) {
        if (ref == null || ref.getType() == null) {
            throw new IllegalArgumentException("ref");
        }
        VmodlType vmodlType = typeMap.getVmodlType(ref.getType());
        if (!(vmodlType instanceof ManagedObjectType)) {
            throw new RuntimeException("No class registered for " + ref);
        }
        return (ManagedObjectType)vmodlType;
    }

    public static ManagedObjectReference createMoRef(VmodlTypeMap typeMap, Class<? extends ManagedObject> moClass, String guid, String id) {
        if (moClass == null) {
            throw new IllegalArgumentException("moClass");
        }
        if (id == null) {
            throw new IllegalArgumentException("id");
        }
        VmodlType type = typeMap.getVmodlType(moClass);
        if (type == null) {
            throw new IllegalArgumentException("moClass");
        }
        return ClientUtils.createMoRef(type.getWsdlName(), id, guid);
    }

    public static ManagedObjectReference cloneMoRef(ManagedObjectReference ref, VmodlTypeMap typeMap) {
        if (ref == null) {
            throw new IllegalArgumentException("ref");
        }
        VmodlType type = typeMap.getVmodlType(ref.getType());
        if (!(type instanceof ManagedObjectType)) {
            throw new RuntimeException("No class registered for " + ref);
        }
        return ClientUtils.createMoRef(typeMap, type.getTypeClass(), ref.getServerGuid(), ref.getValue());
    }

    public static ManagedObjectReference createMoRef(String type, String value, String guid) {
        ManagedObjectReference moref = new ManagedObjectReference();
        moref.setType(type);
        moref.setValue(value);
        moref.setServerGuid(guid);
        return moref;
    }

    public static <T extends ManagedObject> T createLoginStub(ManagedObjectReference ref, Client client, VmodlTypeMap typeMap, SamlToken token, PrivateKey key) {
        T mo = ClientUtils.createStub(ref, client, typeMap);
        ClientUtils.setAuthenticationData((Stub)mo, token, key);
        return mo;
    }

    public static TypeName getTypeName(String wsdlType) {
        return new TypeNameImpl(VmodlTypeMap.Factory.getTypeMap().getVmodlType(wsdlType));
    }

    public static VmodlContext waitToComplete(VmodlContextInitializer loader) {
        try {
            loader.waitToComplete();
            return loader.getVmodlContext();
        }
        catch (VmodlContextInitializer.VmodlContextInitException e) {
            throw Exceptions.getRuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Exceptions.getRuntimeException(e);
        }
    }

    private static class Compiler
    extends HttpConfigurationCompilerImpl {
        private final KeyStore _trustStore;

        Compiler(KeyStore trustStore) {
            this._trustStore = trustStore;
        }

        protected KeyStore loadTrustStore(HttpConfiguration config) {
            return this._trustStore;
        }
    }
}

