/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.hms;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.osgi.VmodlContextInitializer;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.HttpConfigurationManager;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VersionsXmlServiceImpl;
import com.vmware.vim.binding.hms.ServiceInstance;
import com.vmware.vim.binding.hms.ServiceInstanceContent;
import com.vmware.vim.binding.hms.version.internal.version12;
import com.vmware.vim.binding.hms.version.internal.versions;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.KeyStore;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

public class HmsServiceImpl
extends VersionsXmlServiceImpl<ServiceInstance, ServiceInstanceContent>
implements HmsService {
    private static final String VERSIONS_PATH = "/versions/hms-supported-versions.xml";
    private static final Class<? extends Annotation> MIN_SUPPORTED_VERSION = version12.class;
    public static final Class<? extends Annotation> VERSION = versions.HMS_VERSION_DOTTED;
    public static final ManagedObjectReference SERVICE_INSTANCE;
    public static final VmodlContextInitializer VMODL_INIT;
    private static final HmsHttpConfigurationManager MANAGER;

    public HmsServiceImpl(URI server, KeyStore store, TokenProvider tokenProvider) {
        super(server, HmsServiceImpl.MANAGER.getConfiguration(), VMODL_INIT, MIN_SUPPORTED_VERSION, tokenProvider, SERVICE_INSTANCE, "HBR Management Server", VERSIONS_PATH, MANAGER.getHttpClient());
        MANAGER.addThumbprints(store);
    }

    @Override
    protected String getServerGuid(ServiceInstanceContent content) {
        return content.getSiteUuid();
    }

    @Override
    protected Promise<ServiceInstanceContent> retrieveContent(ServiceInstance serviceInstance) {
        FuturePromise result = new FuturePromise();
        serviceInstance.getContent((Future)result);
        return result;
    }

    @Override
    protected Promise<Void> login(ServiceInstanceContent content, String locale) {
        return this.createLoginStub(content.getSessionManager()).thenCompose(sm -> {
            FuturePromise result = new FuturePromise();
            String adaptedLocale = locale.replace('-', '_');
            sm.login(null, null, adaptedLocale, (Future)result);
            return result;
        }).thenApply(unused -> null);
    }

    @Override
    protected Promise<Void> logout(ServiceInstanceContent content) {
        return this.createFreeStub(content.getSessionManager()).thenCompose(sm -> {
            FuturePromise result = new FuturePromise();
            sm.logout((Future)result);
            return result;
        });
    }

    static {
        MANAGER = new HmsHttpConfigurationManager();
        VmodlContext context = VmodlContext.createContext((String[])new String[0], (boolean)false);
        VMODL_INIT = new VmodlContextInitializer(context, VERSION);
        SERVICE_INSTANCE = ClientUtils.createMoRef("HmsServiceInstance", "service-instance", null);
    }

    private static final class HmsHttpConfigurationManager
    extends HttpConfigurationManager {
        private HmsHttpConfigurationManager() {
        }

        private HttpConfiguration getConfiguration() {
            return this._httpConfiguration;
        }

        @Override
        protected CloseableHttpAsyncClient getHttpClient() {
            return super.getHttpClient();
        }
    }
}

