/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.PromiseResult;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.impl.vmomi.invocation.ShutdownException;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.Coordinator;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.LoggingMethodInterceptor;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.ManagedObjectProxy;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang.Validate;

abstract class ManagedMethodInterceptor
implements MethodInterceptor {
    private final Coordinator _coordinator;
    private final URI _server;
    private final String _serverDescription;

    ManagedMethodInterceptor(final URI server, String serverDescription) {
        this._coordinator = new Coordinator(){

            @Override
            String getHost() {
                return server.getHost();
            }

            @Override
            void doShutdown() {
                ManagedMethodInterceptor.this.onShutdown();
            }
        };
        this._server = server;
        this._serverDescription = serverDescription.intern();
    }

    public final Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
        Validate.notEmpty((Object[])args, (String)"args");
        Validate.notEmpty((Object[])args);
        Validate.isTrue((boolean)(args[args.length - 1] instanceof Future));
        ManagedObjectProxy moProxy = (ManagedObjectProxy)proxy;
        ManagedObjectReference moRef = moProxy._getRef();
        Promise moPromise = this.createDelegateStub(moRef).thenApply(mo -> {
            RequestContext rc = moProxy._getRequestContext();
            if (rc != null) {
                ((Stub)mo)._setRequestContext(rc);
            }
            return mo;
        });
        Future lastArg = (Future)args[args.length - 1];
        if (!(lastArg instanceof Promise)) {
            FuturePromise promiseArg = new FuturePromise();
            promiseArg.onSuccess(arg_0 -> ((Future)lastArg).set(arg_0)).onError(arg_0 -> ((Future)lastArg).setException(arg_0));
            args[args.length - 1] = promiseArg;
            lastArg = promiseArg;
        }
        Future futureArg = lastArg;
        moPromise.thenCompose(mo -> {
            Supplier<Promise> supplier = () -> this.process(moProxy, (ManagedObject)mo, method, methodProxy, args, (Map<String, Object>)new ConcurrentHashMap<String, Object>(), 0);
            return this._coordinator.invoke(supplier);
        }).onSuccess(arg_0 -> ((Future)futureArg).set(arg_0)).onError(exc -> futureArg.setException((Exception)exc));
        return null;
    }

    abstract Promise<? extends ManagedObject> createDelegateStub(ManagedObjectReference var1);

    abstract Promise<Boolean> shouldRetryRequest(ManagedObject var1, Method var2, Map<String, Object> var3, Exception var4, int var5);

    abstract void beforeMethodInvoked(ManagedObject var1, Method var2, Object[] var3, Map<String, Object> var4);

    abstract Object afterMethodInvoked(ManagedObject var1, Method var2, Object[] var3, Map<String, Object> var4, Object var5);

    abstract Throwable afterMethodInvoked(ManagedObject var1, Method var2, Object[] var3, Map<String, Object> var4, Throwable var5);

    final void shutdown() {
        this._coordinator.shutdown();
    }

    abstract void onShutdown();

    private Promise process(ManagedObjectProxy moProxy, ManagedObject mo, Method method, MethodProxy methodProxy, Object[] args, Map<String, Object> context, int failedTries) {
        Promise result;
        try {
            this.beforeMethodInvoked(mo, method, args, context);
        }
        catch (RuntimeException re) {
            return Promises.reject((Exception)re);
        }
        try {
            result = this.invokeMethod(moProxy, mo, method, methodProxy, args);
        }
        catch (Throwable t) {
            Throwable transformedExc;
            try {
                transformedExc = this.afterMethodInvoked(mo, method, args, context, t);
            }
            catch (RuntimeException innerRe) {
                t.addSuppressed(innerRe);
                return Promises.reject((Exception)Exceptions.wrap((Throwable)t));
            }
            return Promises.reject((Exception)Exceptions.wrap((Throwable)transformedExc));
        }
        return result.materialize().thenCompose(promiseResult -> {
            PromiseResult pr = (PromiseResult)promiseResult;
            if (pr.isSuccessful()) {
                Object trasnformedResult = this.afterMethodInvoked(mo, method, args, context, pr.getResult());
                return Promises.resolve((Object)trasnformedResult);
            }
            Exception cause = pr.getError();
            if ((cause = Exceptions.wrap((Throwable)this.afterMethodInvoked(mo, method, args, context, cause))) instanceof ShutdownException) {
                return Promises.reject((Exception)cause);
            }
            Exception finalCause = cause;
            return this.shouldRetryRequest(mo, method, context, cause, failedTries + 1).thenCompose(retry -> {
                if (retry.booleanValue()) {
                    return this.process(moProxy, mo, method, methodProxy, args, new ConcurrentHashMap<String, Object>(), failedTries + 1);
                }
                return Promises.reject((Exception)finalCause);
            });
        });
    }

    private Promise invokeMethod(ManagedObjectProxy moProxy, ManagedObject mo, Method method, MethodProxy methodProxy, Object[] args) throws Throwable {
        Object[] fixedArgs = Arrays.copyOf(args, args.length);
        FuturePromise result = new FuturePromise();
        fixedArgs[fixedArgs.length - 1] = result;
        new LoggingMethodInterceptor(mo, this._server, this._serverDescription).intercept(moProxy, method, fixedArgs, methodProxy);
        return result;
    }
}

