/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.tool.ConfigurablesWrapper;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.impex.tool.JaxbContextLoader;
import com.vmware.srm.client.impex.tool.SrmConfigWorkflow;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.impex.tool.io.IOHelper;
import com.vmware.srm.client.impex.workflow.UserInteractor;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import java.io.File;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public final class XmlExportEngine {
    private static final String WHITESPACE_CHARS = "\\s\\u0009\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000";
    private static final String SPECIAL_CHARS = "<>:\"/\\\\|?*\u0000";

    public Promise<Void> export(SrmServersDataWrapper srmServersDataWrapper, Boolean formatted, String path) {
        if (((SrmServer)srmServersDataWrapper.getRemotePair().server()).vc().guid() == null) {
            return Promises.reject((Exception)new IllegalStateException("Remote site is down."));
        }
        Callable<Promise> exportTask = () -> new SrmConfigWorkflow().exportConfigurables().thenCompose(configurablesWrapper -> this.buildFilePath(path, srmServersDataWrapper).thenCompose(filePath -> this.write((ConfigurablesWrapper)configurablesWrapper, Paths.get(filePath, new String[0]).toFile(), formatted)));
        try {
            return (Promise)ImpexExportSrmContext.executeWith(exportTask, (SrmServersDataWrapper)srmServersDataWrapper);
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
    }

    private Promise<String> buildFilePath(String path, SrmServersDataWrapper serversDataWrapper) {
        String pathToUse = path == null ? null : (path.endsWith(File.separator) ? path : path + File.separator);
        return serversDataWrapper.getLocalServer().getName().thenCombine(serversDataWrapper.getRemoteServer().getName(), (localServerName, remoteServerName) -> {
            Date currentDate = new Date();
            String timeStamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(currentDate);
            String name = localServerName + '_' + remoteServerName + '_' + timeStamp + ".xml";
            name = name.replaceAll("[\\s\\u0009\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000<>:\"/\\\\|?*\u0000]", "_");
            return pathToUse == null ? name : pathToUse + name;
        });
    }

    private Promise<Void> write(ConfigurablesWrapper configurablesWrapper, File outputFile, Boolean formatted) {
        IOHelper ioHelper = UserInteractor.getIoHelper();
        ioHelper.writeln("Writing to file started.");
        try {
            Marshaller jaxbMarshaller = JaxbContextLoader.getJaxbContext().createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)formatted);
            jaxbMarshaller.marshal((Object)configurablesWrapper, outputFile);
        }
        catch (JAXBException e) {
            return Promises.reject((Exception)new RuntimeException(String.format("Error writing to the file %s, error: %s.", outputFile, e.getCause())));
        }
        ioHelper.writeln("Writing to file finished.");
        return Promises.resolve(null);
    }
}

