/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.tool.io.IOHelper;
import com.vmware.srm.client.impex.tool.io.InputWaiterRequester;
import com.vmware.srm.client.impex.tool.io.args.Arguments;
import com.vmware.srm.client.impex.tool.io.data.Credentials;
import com.vmware.srm.client.impex.tool.io.data.KeyStoreData;
import com.vmware.srm.client.impex.tool.io.data.Lspp;
import com.vmware.srm.client.impex.tool.io.request.FinalRequest;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class CmdInputWR
extends InputWaiterRequester {
    private final Arguments _args;
    private final AtomicBoolean _localCredentialsRequested = new AtomicBoolean(false);
    private final AtomicBoolean _remoteCredentialsRequested = new AtomicBoolean(false);

    public CmdInputWR(IOHelper ioHelper, Arguments arguments) {
        super(ioHelper);
        this._args = arguments;
    }

    @Override
    public Promise<Lspp> promptForLspp() {
        return Promises.resolve((Object)this._args.getLspp());
    }

    @Override
    public Promise<Boolean> promptForThumbprint(String host, String thumbprint) {
        return Promises.resolve((Object)true);
    }

    @Override
    public Promise<Boolean> promptForUsingLocalKeyStore(String host) {
        return Promises.resolve((Object)this._args.isLocalUseKs());
    }

    @Override
    public Promise<Credentials> promptForLocalCredentials(String host) {
        if (this._localCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Local credentials have already been requested."));
        }
        return Promises.resolve((Object)((Object)this._args.getLocalCredentials()));
    }

    @Override
    public Promise<KeyStoreData> promptForLocalKeyStoreData() {
        if (this._localCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Local keystore data has already been requested."));
        }
        return Promises.resolve((Object)this._args.getLocalKsData());
    }

    @Override
    public Promise<String> promptForSrmServer(Map<String, String> guidToName) {
        if (this._args.getLocalSrmGuid() != null) {
            return Promises.resolve((Object)this._args.getLocalSrmGuid());
        }
        return Promises.resolve((Object)this.getSrmServerGuid(guidToName, this._args.getLocalSrmName()));
    }

    @Override
    public Promise<Boolean> promptForUsingRemoteKeyStore(String host) {
        return Promises.resolve((Object)this._args.isRemoteUseKs());
    }

    @Override
    public Promise<Credentials> promptForRemoteCredentials(String srmName) {
        if (this._remoteCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Remote credentials have already been requested."));
        }
        return Promises.resolve((Object)((Object)this._args.getRemoteCredentials()));
    }

    @Override
    public Promise<KeyStoreData> promptForRemoteKeyStoreData() {
        if (this._remoteCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Remote keystore data has already been requested."));
        }
        return Promises.resolve((Object)this._args.getRemoteKsData());
    }

    @Override
    public InputWaiterRequester.AmErrorHandling continueOnAmError() {
        return InputWaiterRequester.AmErrorHandling.CONTINUE;
    }

    @Override
    public Promise<Credentials> promptForAmCredentials(String amName) {
        return Promises.reject((Exception)new RuntimeException("Importing array managers is only supported using properties file or interactively."));
    }

    @Override
    public void complete(int exitCode, String completionMessage) {
        this._requests.add(new FinalRequest(exitCode, completionMessage));
    }
}

