/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.tool.io.IOHelper;
import com.vmware.srm.client.impex.tool.io.InputWaiterRequester;
import com.vmware.srm.client.impex.tool.io.data.Credentials;
import com.vmware.srm.client.impex.tool.io.data.KeyStoreData;
import com.vmware.srm.client.impex.tool.io.data.Lspp;
import com.vmware.srm.client.impex.tool.io.request.BooleanRequest;
import com.vmware.srm.client.impex.tool.io.request.CredentialsRequest;
import com.vmware.srm.client.impex.tool.io.request.FinalRequest;
import com.vmware.srm.client.impex.tool.io.request.KeyStoreRequest;
import com.vmware.srm.client.impex.tool.io.request.LsppRequest;
import com.vmware.srm.client.impex.tool.io.request.SrmSelectionRequest;
import java.util.Map;

public class ConsoleInputWR
extends InputWaiterRequester {
    public ConsoleInputWR(IOHelper ioHelper) {
        super(ioHelper);
    }

    @Override
    public Promise<Lspp> promptForLspp() {
        LsppRequest lsppRequest = new LsppRequest(this._ioHelper);
        this._requests.add(lsppRequest);
        return lsppRequest.getResult();
    }

    @Override
    public Promise<Boolean> promptForThumbprint(String host, String thumbprint) {
        return this.promptForBoolAnswer(String.format("Host %s has untrusted certificate with SHA-1 Thumbprint: %s .\nAccept thumbprint?", host, thumbprint));
    }

    @Override
    public Promise<Boolean> promptForUsingLocalKeyStore(String host) {
        return this.promptForUsingKeyStore(host);
    }

    @Override
    public Promise<Credentials> promptForLocalCredentials(String host) {
        return this.promptForCredentials(host);
    }

    @Override
    public Promise<KeyStoreData> promptForLocalKeyStoreData() {
        return this.promptForKeyStoreData();
    }

    @Override
    public Promise<String> promptForSrmServer(Map<String, String> guidToName) {
        SrmSelectionRequest srmSelectionRequest = new SrmSelectionRequest(this._ioHelper, guidToName);
        this._requests.add(srmSelectionRequest);
        return srmSelectionRequest.getResult();
    }

    @Override
    public Promise<Boolean> promptForUsingRemoteKeyStore(String host) {
        return this.promptForUsingKeyStore(host);
    }

    @Override
    public Promise<Credentials> promptForRemoteCredentials(String srmName) {
        return this.promptForCredentials(String.format("pair site '%s'", srmName));
    }

    @Override
    public Promise<KeyStoreData> promptForRemoteKeyStoreData() {
        return this.promptForKeyStoreData();
    }

    @Override
    public InputWaiterRequester.AmErrorHandling continueOnAmError() {
        return InputWaiterRequester.AmErrorHandling.PROMPT;
    }

    @Override
    public Promise<Credentials> promptForAmCredentials(String amName) {
        return this.promptForBoolAnswer(String.format("Do you want to import array manager '%s' ?", amName)).thenCompose(answer -> {
            if (!answer.booleanValue()) {
                return Promises.reject((Exception)new InputWaiterRequester.RejectedException("User cancelled."));
            }
            return this.promptForCredentials(amName);
        });
    }

    @Override
    public void complete(int exitCode, String completionMessage) {
        this._requests.add(new FinalRequest(exitCode, completionMessage));
    }

    private Promise<Boolean> promptForBoolAnswer(String question) {
        BooleanRequest booleanRequest = new BooleanRequest(this._ioHelper, question);
        this._requests.add(booleanRequest);
        return booleanRequest.getResult();
    }

    private Promise<Credentials> promptForCredentials(String target) {
        CredentialsRequest credentialsRequest = new CredentialsRequest(this._ioHelper, target);
        this._requests.add(credentialsRequest);
        return credentialsRequest.getResult();
    }

    private Promise<Boolean> promptForUsingKeyStore(String host) {
        return this.promptForBoolAnswer(String.format("Use Java keystore to log in on %s?", host));
    }

    private Promise<KeyStoreData> promptForKeyStoreData() {
        KeyStoreRequest keyStoreRequest = new KeyStoreRequest(this._ioHelper);
        this._requests.add(keyStoreRequest);
        return keyStoreRequest.getResult();
    }
}

