/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io;

import com.vmware.srm.client.impex.tool.io.data.KeyStoreData;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.lang.Validate;

public class KeyStoreManager {
    private final X509Certificate _certificate;
    private final PrivateKey _key;

    public static KeyStoreManager build(KeyStoreData keyStoreData) {
        if (keyStoreData == null) {
            return null;
        }
        try {
            return new KeyStoreManager(keyStoreData);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Unable to handle the provided key store type: " + e.getMessage(), e);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException("Unable to load key store: " + e.getMessage(), e);
        }
    }

    public KeyStoreManager(KeyStoreData data) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        KeyStore keyStore = KeyStoreManager.retrieveKeyStore(data);
        this._certificate = KeyStoreManager.retrieveCertificate(keyStore, data.getCertAlias());
        this._key = KeyStoreManager.retrieveKey(keyStore, data.getKeyAlias(), data.getKeyPass());
        data.reset();
    }

    public X509Certificate getCertificate() {
        return this._certificate;
    }

    public PrivateKey getKey() {
        return this._key;
    }

    private static KeyStore retrieveKeyStore(KeyStoreData data) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        Validate.notNull(data, "KeyStoreData");
        KeyStore keyStore = KeyStore.getInstance(data.getKeyStoreType());
        try (FileInputStream is = new FileInputStream(data.getKeyStorePath());){
            keyStore.load(is, data.getKeyStorePass());
        }
        return keyStore;
    }

    private static X509Certificate retrieveCertificate(KeyStore keyStore, String certAlias) {
        Certificate cert;
        try {
            cert = keyStore.getCertificate(certAlias);
        }
        catch (KeyStoreException error) {
            throw new RuntimeException(String.format("Unable to retrieve certificate for alias: '%s'. %s", certAlias, error.getMessage()), error);
        }
        if (cert == null) {
            throw new RuntimeException(String.format("Unable to find certificate in key store for alias: '%s'.", certAlias));
        }
        if (!(cert instanceof X509Certificate)) {
            throw new RuntimeException(String.format("Certificate type is not X509, but: '%s'.", cert.getClass().getName()));
        }
        return (X509Certificate)cert;
    }

    private static PrivateKey retrieveKey(KeyStore keyStore, String keyAlias, char[] keyPass) {
        PrivateKey privateKey;
        try {
            privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyPass);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException error) {
            throw new RuntimeException(String.format("Unable to retrieve private key for key alias '%s', check the provided password. %s", keyAlias, error.getMessage()), error);
        }
        if (privateKey == null) {
            throw new RuntimeException(String.format("Unable to find private key for key alias '%s' in key store.", keyAlias));
        }
        return privateKey;
    }
}

