/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.cis.authn;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vim.sso.client.SamlToken;
import java.security.PrivateKey;
import java.util.Objects;

public final class SamlAuthenticationData {
    private final SamlToken token;
    private final String tokenXml;
    private final PrivateKey key;

    private SamlAuthenticationData(SamlToken token, PrivateKey key) {
        Objects.requireNonNull(token);
        this.token = token;
        this.key = key;
        this.tokenXml = token.toXml();
    }

    private SamlAuthenticationData(String tokenXml, PrivateKey key) {
        Objects.requireNonNull(tokenXml);
        this.token = null;
        this.key = key;
        this.tokenXml = tokenXml;
    }

    public SamlToken getSamlToken() {
        if (this.token == null) {
            throw new IllegalStateException("No parsed token data provided");
        }
        return this.token;
    }

    public String getSamlTokenXml() {
        return this.tokenXml;
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }

    public static final SamlAuthenticationData createInstance(ExecutionContext.SecurityContext ctx) {
        Validate.notNull((Object)ctx);
        Validate.isTrue((ctx.getProperty("authn_scheme_id").equals("com.vmware.vapi.std.security.saml_hok_token") || ctx.getProperty("authn_scheme_id").equals("com.vmware.vapi.std.security.saml_bearer_token") ? 1 : 0) != 0);
        Object tokenObject = ctx.getProperty("samlToken");
        boolean isSamlToken = tokenObject instanceof SamlToken;
        boolean isString = tokenObject instanceof String;
        if (!isSamlToken && !isString) {
            throw new IllegalStateException("Incorrectly constructed security context");
        }
        Object privateKeyObject = ctx.getProperty("privateKey");
        if (privateKeyObject != null && !(privateKeyObject instanceof PrivateKey)) {
            throw new IllegalStateException("Unknown object under the private key id");
        }
        if (isSamlToken) {
            return new SamlAuthenticationData((SamlToken)tokenObject, (PrivateKey)privateKeyObject);
        }
        return new SamlAuthenticationData((String)tokenObject, (PrivateKey)privateKeyObject);
    }
}

