/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.groups;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroup;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.dr.replication.ProtectionGroup;
import com.vmware.vim.binding.dr.storage.ArrayInfo;
import com.vmware.vim.binding.dr.storage.ReplicatedArrayPair;
import com.vmware.vim.binding.dr.storageProvider.GroupProtectionDetails;
import com.vmware.vim.binding.dr.storageProvider.GroupRecoveryDetails;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;

public abstract class StorageProviderSettingsConverter<T extends IeVmProtectionGroup>
implements ConfigurableConverter {
    protected final PcResult _pcResult;

    public StorageProviderSettingsConverter(PcResult pcResult) {
        this._pcResult = pcResult;
    }

    public void fromVmodl(T ieProtectionGroup, ManagedObjectReference vmProtectionGroup) {
        ((IeVmProtectionGroup)ieProtectionGroup).setProviderType(IeVmProtectionGroup.IeProviderType.Abr);
        ProtectionGroup.ReplicationProviderGroupDetails details = (ProtectionGroup.ReplicationProviderGroupDetails)this._pcResult.getProperty(vmProtectionGroup, "providerDetails");
        if (details == null) {
            return;
        }
        if (details instanceof GroupProtectionDetails) {
            this.convertProtectionDetails(vmProtectionGroup, (GroupProtectionDetails)details, ieProtectionGroup);
            return;
        }
        if (details instanceof GroupRecoveryDetails) {
            this.convertRecoveryDetails(vmProtectionGroup, (GroupRecoveryDetails)details, ieProtectionGroup);
            return;
        }
        throw new IllegalStateException("ProtectionGroupProviderDetails not null && not GPD && not GRD.");
    }

    protected void convertProtectionDetails(ManagedObjectReference vmProtectionGroup, GroupProtectionDetails details, T ieProtectionGroup) {
        ManagedObjectReference apRef = details.array;
        ArrayInfo arrayInfo = (ArrayInfo)this._pcResult.getProperty(apRef, "info");
        ((IeVmProtectionGroup)ieProtectionGroup).setArrayPairKey(arrayInfo.getKey());
    }

    protected void convertRecoveryDetails(ManagedObjectReference vmProtectionGroup, GroupRecoveryDetails details, T ieProtectionGroup) {
        ManagedObjectReference apRef = details.array;
        ReplicatedArrayPair.Peer peer = (ReplicatedArrayPair.Peer)this._pcResult.getProperty(apRef, "peer");
        if (peer == null) {
            return;
        }
        ((IeVmProtectionGroup)ieProtectionGroup).setArrayPairKey(peer.getArrayId());
    }
}

