/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.groups;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.groups.IeProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroupFaultDomain;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroupReplicationGroup;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.dr.vvolProvider.DomainInfo;
import com.vmware.vim.binding.dr.vvolProvider.GroupDetails;
import com.vmware.vim.binding.vim.vm.replication.FaultDomainId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.constants.dr.replication.VM_PROTECTION_GROUP;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VvolProviderSettingsConverter<T extends IeVmProtectionGroup>
implements ConfigurableConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VvolProviderSettingsConverter.class);
    private final PcResult _pcResult;
    private final DomainInfo[] _localDomainInfos;
    private final DomainInfo[] _remoteDomainInfos;

    public VvolProviderSettingsConverter(PcResult pcResult, DomainInfo[] localDomainInfos, DomainInfo[] remoteDomainInfos) {
        this._pcResult = pcResult;
        this._localDomainInfos = localDomainInfos;
        this._remoteDomainInfos = remoteDomainInfos;
    }

    public void fromVmodl(T ieProtectionGroup, ManagedObjectReference vvolProtectionGroup) {
        ((IeVmProtectionGroup)ieProtectionGroup).setProviderType(IeVmProtectionGroup.IeProviderType.Vvol);
        GroupDetails vvolDetails = (GroupDetails)this._pcResult.getProperty(vvolProtectionGroup, ((IeProtectionGroup)ieProtectionGroup).isProtectedSiteLocal() ? "providerDetails" : VM_PROTECTION_GROUP.PEER_.PROVIDER_DETAILS);
        this.convertGroupDetails(ieProtectionGroup, vvolDetails);
    }

    protected void convertGroupDetails(T ieProtectionGroup, GroupDetails vvolDetails) {
        List<IeVmProtectionGroupReplicationGroup> replicationGroups;
        String domainInfoName;
        String domainInfoId;
        FaultDomainId pgFaultDomain = vvolDetails.getDomain();
        if (pgFaultDomain == null) {
            domainInfoId = null;
            domainInfoName = null;
            LOGGER.error("vVol protection group '{}' has no fault domain.", (Object)((IeProtectionGroup)ieProtectionGroup).getName());
        } else {
            domainInfoId = pgFaultDomain.id;
            domainInfoName = Arrays.stream(((IeProtectionGroup)ieProtectionGroup).isProtectedSiteLocal() ? this._localDomainInfos : this._remoteDomainInfos).filter(info -> domainInfoId.equals(info.id.id)).map(DomainInfo::getName).findFirst().orElseGet(() -> {
                LOGGER.error("vVol protection group '{}' fault domain with id: '{}' cannot be found.", (Object)ieProtectionGroup.getName(), (Object)faultDomainId.id);
                return null;
            });
        }
        Object[] pgReplicationGroups = vvolDetails.getReplicationGroups();
        if (ArrayUtils.isEmpty((Object[])pgReplicationGroups)) {
            replicationGroups = null;
            LOGGER.warn("No replication groups for vVol protection group: '{}'.", (Object)((IeProtectionGroup)ieProtectionGroup).getName());
        } else {
            replicationGroups = Arrays.stream(pgReplicationGroups).map(replicationGroup -> new IeVmProtectionGroupReplicationGroup(replicationGroup.replicationGroup.deviceGroupId.id, replicationGroup.name)).collect(Collectors.toList());
        }
        ((IeVmProtectionGroup)ieProtectionGroup).setFaultDomain(new IeVmProtectionGroupFaultDomain(domainInfoId, domainInfoName, replicationGroups));
    }
}

