/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.groups;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.impex.configurables.groups.IeSrmConfigSpProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeSrmConfigVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.SpProtectionGroupConverter;
import com.vmware.srm.client.impex.configurables.groups.SrmConfigSpProtectionGroupConverter;
import com.vmware.srm.client.impex.configurables.groups.SrmConfigVmProtectionGroupConverter;
import com.vmware.srm.client.impex.configurables.groups.VmProtectionGroupConverter;
import com.vmware.srm.client.impex.exporters.groups.ProtectionGroupFolderExporter;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.impex.utils.GroupUtil;
import com.vmware.srm.client.impex.utils.MappingUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.vmomi.pbm.SpbmService;
import com.vmware.vim.binding.dr.vvolProvider.DomainInfo;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;

public class SrmConfigProtectionGroupFoldersExporter
extends ProtectionGroupFolderExporter<IeSrmConfigVmProtectionGroup, IeSrmConfigSpProtectionGroup> {
    @Override
    protected Promise<PcResult> getProtectionGroups() {
        SrmServersDataWrapper serversData = ImpexExportSrmContext.getServersDataWrapper();
        ManagedObjectReference storageManager = serversData.getLocalContent().storageManager;
        return GroupUtil.getProtectionGroups((ServersView)serversData.getView(), this.rootFolderMoRef, storageManager);
    }

    @Override
    protected Promise<SpProtectionGroupConverter<IeSrmConfigSpProtectionGroup>> getSppgExporter(PcResult pgPcResult) {
        SrmServersDataWrapper serversData = ImpexExportSrmContext.getServersDataWrapper();
        SpbmService localSpbmService = ((SrmServer)serversData.getLocalPair().server()).vc().spbmService();
        SpbmService remoteSpbmService = ((SrmServer)serversData.getRemotePair().server()).vc().spbmService();
        Promise<Profile[]> localProfilesPromise = MappingUtil.getProfiles(localSpbmService);
        Promise<Profile[]> remoteProfilesPromise = MappingUtil.getProfiles(remoteSpbmService);
        return localProfilesPromise.thenCombine(remoteProfilesPromise, (localProfiles, remoteProfiles) -> new SrmConfigSpProtectionGroupConverter(pgPcResult, (Profile[])localProfiles, (Profile[])remoteProfiles));
    }

    @Override
    protected Promise<VmProtectionGroupConverter<IeSrmConfigVmProtectionGroup>> getVmpgExporter(PcResult pgPcResult) {
        Promise<DomainInfo[]> localDomainInfosPromise = GroupUtil.getDomainInfos(true);
        Promise<DomainInfo[]> remoteDomainInfosPromise = GroupUtil.getDomainInfos(false);
        return localDomainInfosPromise.thenCombine(remoteDomainInfosPromise, (localDomainInfos, remoteDomainInfos) -> new SrmConfigVmProtectionGroupConverter(pgPcResult, (DomainInfo[])localDomainInfos, (DomainInfo[])remoteDomainInfos));
    }
}

