/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.folders.groups.vm;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.impex.configurables.groups.IeSrmConfigVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroupProperties;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.IeDeviceInfo;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.networkBacking.IeNetworkDeviceBackingLocator;
import com.vmware.srm.client.impex.importers.folders.groups.vm.RecoveryLocationSettingsConverter;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.vim.binding.dr.replication.ProtectedVm;
import com.vmware.vim.binding.dr.vimext.DeviceInfo;
import com.vmware.vim.binding.dr.vimext.NetworkDeviceBackingLocator;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.dr.replication.PROTECTED_VM;
import com.vmware.vim.vmomi.core.Future;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedVmUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtectedVmUpdater.class);
    private final RecoveryLocationSettingsConverter _rlsConverter;
    private final InventoryExtractor.VmKeysLookup _vmKeysLookup;

    public ProtectedVmUpdater(RecoveryLocationSettingsConverter rlsConverter, InventoryExtractor.InventoryLookup inventory) {
        this._rlsConverter = rlsConverter;
        this._vmKeysLookup = inventory.getVmKeysLookup();
    }

    public Promise<Void> reconfigureProtectedVmsRls(IeSrmConfigVmProtectionGroup ieVmPg, ManagedObjectReference pgMoRef) {
        Validate.notNull((Object)ieVmPg);
        Validate.notNull((Object)pgMoRef);
        LOGGER.info("Updating network mappings for protected VMs for protection group '{}' with id '{}'.", (Object)ieVmPg.getName(), (Object)ieVmPg.getId());
        List<IeVmProtectionGroupProperties> protectionProperties = ieVmPg.getProtectionProperties();
        if (CollectionUtils.isEmpty(protectionProperties)) {
            LOGGER.info("No protection properties for (empty) protection group '{}' with id '{}'.", (Object)ieVmPg.getName(), (Object)ieVmPg.getId());
            return Promises.resolve(null);
        }
        List ieVmsToReconfigure = protectionProperties.stream().filter(prop -> prop.isVmProtected() && this.hasNetworkDevices((IeVmProtectionGroupProperties)prop)).collect(Collectors.toList());
        return this.retrieveProtectedVmProperties(pgMoRef).thenCompose(pcResult -> {
            HashMap<String, ManagedObjectReference> iUuidToProtectedVmMoRef = new HashMap<String, ManagedObjectReference>();
            pcResult.getMoRefs().forEach(protectedVmMoRef -> {
                String iUuid = (String)pcResult.tryGetProperty(protectedVmMoRef, PROTECTED_VM.VM_INFO_.INSTANCE_UUID, error -> {
                    LOGGER.warn("Unable to get UUID for protected VM '{}'.", protectedVmMoRef, error);
                    return null;
                });
                if (iUuid != null) {
                    iUuidToProtectedVmMoRef.put(iUuid, (ManagedObjectReference)protectedVmMoRef);
                }
            });
            return this.reconfigureRls(ieVmPg, ieVmsToReconfigure, (PcResult)pcResult, (Map<String, ManagedObjectReference>)iUuidToProtectedVmMoRef);
        });
    }

    private Promise<PcResult> retrieveProtectedVmProperties(ManagedObjectReference pgMoRef) {
        ObjectSpecBuilder builder = new ObjectSpecBuilder(pgMoRef, true);
        builder.traverseTo("protectedVm");
        PropertyCollector.PropertySpec propertySpec = PCUtil.createPropertySpec((String)"DrReplicationProtectedVm", (String[])new String[]{PROTECTED_VM.VM_INFO_.INSTANCE_UUID, "recoveryLocationSettings"});
        PropertyCollector.FilterSpec filterSpec = PCUtil.createFilterSpec((PropertyCollector.ObjectSpec)builder.build(), (PropertyCollector.PropertySpec[])new PropertyCollector.PropertySpec[]{propertySpec});
        return PCUtil.retrieveProperties((ServersView)ImpexImportSrmContext.get().getServersDataWrapper().getView(), (PropertyCollector.FilterSpec[])new PropertyCollector.FilterSpec[]{filterSpec});
    }

    private Promise<Void> reconfigureRls(IeVmProtectionGroup ieVmPg, List<IeVmProtectionGroupProperties> ieVmsToReconfigure, PcResult pcResult, Map<String, ManagedObjectReference> iUuidToProtectedVmMoRef) {
        if (ieVmsToReconfigure.isEmpty()) {
            LOGGER.warn("Done updating network mappings, no protected VMs for protection group '{}' with id '{}'.", (Object)ieVmPg.getName(), (Object)ieVmPg.getId());
            return Promises.resolve(null);
        }
        SrmService srmService = IContextUtil.getSrmService(ieVmPg.isProtectedSiteLocal());
        return Streams.from(ieVmsToReconfigure).flatMap(ieVmToReconfigure -> {
            String uuid = (String)this._vmKeysLookup.get(ieVmToReconfigure.getId());
            if (uuid == null) {
                LOGGER.warn("Unable to reconfigure RLS: Protected VM UUID not found for VM with id '{}'.", (Object)ieVmToReconfigure.getId());
                return Promises.resolve(null);
            }
            ManagedObjectReference protectedVmMoRef = (ManagedObjectReference)iUuidToProtectedVmMoRef.get(uuid);
            if (protectedVmMoRef == null) {
                LOGGER.warn("Unable to reconfigure RLS: Protected VM MoRef not found for VM with id '{}'.", (Object)ieVmToReconfigure.getId());
                return Promises.resolve(null);
            }
            List<IeDeviceInfo> ieDeviceInfos = Arrays.stream(ieVmToReconfigure.getRecoverySettings().getDeviceInfos()).filter(ieDeviceInfo -> ieDeviceInfo.getLocator() instanceof IeNetworkDeviceBackingLocator).collect(Collectors.toList());
            ProtectedVm protectedVm = (ProtectedVm)srmService.createStub(protectedVmMoRef);
            ProtectedVm.RecoveryLocationSettings rls = (ProtectedVm.RecoveryLocationSettings)pcResult.tryGetProperty(protectedVmMoRef, "recoveryLocationSettings", error -> {
                LOGGER.warn("Unable to get RLS for protected VM '{}' with id '{}'.", new Object[]{protectedVmMoRef, ieVmToReconfigure.getId(), error});
                return null;
            });
            return this.updateRls(protectedVm, rls, ieDeviceInfos, ieVmPg);
        }).collect().thenApply(unused -> {
            LOGGER.info("Done updating network mappings for protected VMs for protection group '{}' with id '{}'.", (Object)ieVmPg.getName(), (Object)ieVmPg.getId());
            return null;
        });
    }

    private Promise<Void> updateRls(ProtectedVm protectedVm, ProtectedVm.RecoveryLocationSettings rls, List<IeDeviceInfo> ieNetworkDeviceInfos, IeVmProtectionGroup ieVmPg) {
        if (Objects.isNull(rls)) {
            LOGGER.debug("RLS is null for ieVmPg '{}' with id '{}'.", (Object)ieVmPg.getName(), (Object)ieVmPg.getId());
            return Promises.resolve(null);
        }
        boolean hasUpdatedRls = false;
        Object[] deviceInfos = rls.getProtectedDevice();
        if (ArrayUtils.isEmpty((Object[])deviceInfos)) {
            return Promises.resolve(null);
        }
        ImpexImportSrmContext context = ImpexImportSrmContext.get();
        Map keyToIeDeviceInfo = ieNetworkDeviceInfos.stream().collect(Collectors.toMap(IeDeviceInfo::getKey, Function.identity()));
        for (Object deviceInfo : deviceInfos) {
            if (!(deviceInfo.getBacking() instanceof NetworkDeviceBackingLocator)) continue;
            IeDeviceInfo ieDeviceInfo = (IeDeviceInfo)keyToIeDeviceInfo.get(((DeviceInfo)deviceInfo).key);
            if (ieDeviceInfo == null) {
                LOGGER.debug("Unable to reconfigure already protected VM's network mapping for protection group '{}' with ID '{}': unable to find ieDeviceInfo - VM was not protected during export.", (Object)ieVmPg.getName(), (Object)ieVmPg.getId());
                context.addError(ImpexL10N.localize("group.protectedVm.reconfigureNetworkMapping", ieVmPg.getName()));
                continue;
            }
            this._rlsConverter.reconfigureNetworkDeviceBackingLocator(ieDeviceInfo.getLocator(), (NetworkDeviceBackingLocator)deviceInfo.getBacking());
            hasUpdatedRls = true;
        }
        if (!hasUpdatedRls) {
            return Promises.resolve(null);
        }
        FuturePromise taskMoRefFp = new FuturePromise();
        protectedVm.reconfigureRecoveryLocationSettings(rls, (Future)taskMoRefFp);
        return taskMoRefFp.thenCompose(context::monitor).thenApply(unused -> null);
    }

    private boolean hasNetworkDevices(IeVmProtectionGroupProperties prop) {
        return Objects.nonNull(prop.getRecoverySettings()) && ArrayUtils.isNotEmpty((Object[])prop.getRecoverySettings().getDeviceInfos()) && Arrays.stream(prop.getRecoverySettings().getDeviceInfos()).anyMatch(deviceInfo -> deviceInfo.getLocator() instanceof IeNetworkDeviceBackingLocator);
    }
}

