/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.folders.groups.vm;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.configurables.groups.IeSrmConfigVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.VmPgSettingsConverter;
import com.vmware.srm.client.impex.importers.folders.groups.GroupImporter;
import com.vmware.srm.client.impex.importers.folders.groups.vm.RecoveryLocationSettingsConverter;
import com.vmware.srm.client.impex.importers.folders.groups.vm.VmGroupProtector;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.GroupUtil;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.vim.binding.dr.replication.ReplicationManager;
import com.vmware.vim.binding.dr.replication.VmProtectionGroup;
import com.vmware.vim.binding.dr.vvolProvider.DomainInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmGroupImporter
extends GroupImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VmGroupImporter.class);
    private final InventoryExtractor.InventoryLookup _inventory;
    private final VmGroupProtector _vmProtector;
    private final DomainInfo[] _localDomainInfos;
    private final DomainInfo[] _remoteDomainInfos;

    public VmGroupImporter(InventoryExtractor.InventoryLookup inventory, RecoveryLocationSettingsConverter rlsConverter, DomainInfo[] localDomainInfos, DomainInfo[] remoteDomainInfos) {
        this._inventory = inventory;
        this._vmProtector = new VmGroupProtector(this._inventory, rlsConverter);
        this._localDomainInfos = localDomainInfos;
        this._remoteDomainInfos = remoteDomainInfos;
    }

    public Promise<ManagedObjectReference> createVmProtectionGroup(IeSrmConfigVmProtectionGroup ieVmPg, ManagedObjectReference parent, Map<String, ManagedObjectReference> arrayPairKeyToMoRef) {
        if (ieVmPg == null || parent == null) {
            return Promises.reject((Exception)new IllegalArgumentException("VM protection group or parent."));
        }
        LOGGER.info("Starting ProtectionGroup '{}' creation.", (Object)ieVmPg.getName());
        if (ieVmPg.isProtectedSiteLocal()) {
            return GroupUtil.getProviders(true).thenCompose(localProviders -> this.createVmProtectionGroup(ieVmPg, (ManagedObjectReference[])localProviders, parent, true, arrayPairKeyToMoRef));
        }
        return this.getPeerFolderPromise(parent).thenCombineCompose(GroupUtil.getProviders(false), (peerFolder, remoteProviders) -> this.createVmProtectionGroup(ieVmPg, (ManagedObjectReference[])remoteProviders, (ManagedObjectReference)peerFolder, false, arrayPairKeyToMoRef));
    }

    public Promise<Void> protectVms(IeSrmConfigVmProtectionGroup ieVmPg, ManagedObjectReference protectionGroup) {
        return this._vmProtector.protectVms(ieVmPg, protectionGroup).onSuccess(done -> LOGGER.info("Protected VMs for ProtectionGroup '{}' successfully.", (Object)ieVmPg.getName())).onError(error -> LOGGER.warn("Failed to protect VMs for ProtectionGroup '{}'.", (Object)ieVmPg.getName(), error));
    }

    private Promise<ManagedObjectReference> createVmProtectionGroup(IeSrmConfigVmProtectionGroup ieVmPg, ManagedObjectReference[] providers, ManagedObjectReference parent, boolean local, Map<String, ManagedObjectReference> arrayPairKeyToMoRef) {
        ManagedObjectReference provider;
        IeVmProtectionGroup.IeProviderType type = ieVmPg.getProviderType();
        if (type == null) {
            return Promises.reject((Exception)new IllegalArgumentException("Provider type."));
        }
        switch (type) {
            case Hbr: {
                provider = GroupUtil.getProvider(providers, "DrReplicationHbrProvider");
                break;
            }
            case Abr: {
                provider = GroupUtil.getProvider(providers, "DrReplicationStorageProvider");
                break;
            }
            case Vvol: {
                provider = GroupUtil.getProvider(providers, "DrReplicationVvolProvider");
                break;
            }
            default: {
                return Promises.reject((Exception)new RuntimeException("Unable to retrieve provider for provider type: '" + (Object)((Object)type) + "'."));
            }
        }
        DomainInfo[] domainInfos = null;
        if ("DrReplicationVvolProvider".equals(provider.getType())) {
            domainInfos = local ? this._localDomainInfos : this._remoteDomainInfos;
        }
        VmProtectionGroup.Settings vmProtectionGroupSettings = VmPgSettingsConverter.toVmodl(ieVmPg, this._inventory, arrayPairKeyToMoRef, domainInfos);
        return this.createVmProtectionGroup(parent, vmProtectionGroupSettings, provider, local);
    }

    private Promise<ManagedObjectReference> createVmProtectionGroup(ManagedObjectReference parent, VmProtectionGroup.Settings settings, ManagedObjectReference provider, boolean local) {
        ReplicationManager replicationManager = GroupUtil.getReplicationManager(local);
        ManagedObjectReference remoteSite = local ? ImpexImportSrmContext.get().getServersDataWrapper().getLocalPair().pairServerVmomiRef() : ImpexImportSrmContext.get().getServersDataWrapper().getRemotePair().pairServerVmomiRef();
        FuturePromise taskPromise = new FuturePromise();
        replicationManager.createVmProtectionGroup(parent, settings, provider, remoteSite, (Future)taskPromise);
        return taskPromise.thenCompose(taskMoRef -> ImpexImportSrmContext.get().monitor((ManagedObjectReference)taskMoRef));
    }
}

