/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.folders.plans;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.configurables.Configurable;
import com.vmware.srm.client.impex.configurables.folders.IeFolder;
import com.vmware.srm.client.impex.configurables.plans.IeRecoveryPlan;
import com.vmware.srm.client.impex.importers.folders.FolderImporter;
import com.vmware.srm.client.impex.importers.folders.plans.PlanImporter;
import com.vmware.srm.client.impex.importers.folders.plans.PlanNetworkMappingsUpdater;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.dr.Folder;
import com.vmware.vim.binding.dr.fault.DuplicateName;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.constants.dr.recovery.RECOVERY_PLAN;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanFolderImporter
extends FolderImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanFolderImporter.class);
    private final PlanImporter _creator;
    private final PlanNetworkMappingsUpdater _updater;
    private final ManagedObjectReference _rootFolder;
    private final boolean _local;

    public PlanFolderImporter(ManagedObjectReference rootFolder, PcResult basicRPsPcResult, PlanImporter planImporter, PlanNetworkMappingsUpdater updater, boolean local) {
        super(IContextUtil.getSrmService(local), basicRPsPcResult);
        this._creator = planImporter;
        this._updater = updater;
        this._rootFolder = rootFolder;
        this._local = local;
    }

    public Promise<Promises.PromiseResultAccessor> create() {
        IeFolder parentFolder = ImpexImportSrmContext.get().getConfigurablesWrapper().getRecoveryPlanRootFolder();
        if (parentFolder == null || this._rootFolder == null) {
            LOGGER.warn("Invalid folder format");
            return Promises.resolve(null);
        }
        return this.createFolders(parentFolder, this._rootFolder);
    }

    private Promise<Promises.PromiseResultAccessor> createFolders(IeFolder ieParentFolder, ManagedObjectReference parentMoRef) {
        if (ieParentFolder.getChildren() == null || parentMoRef == null) {
            LOGGER.debug("Plan folder, children or parent ref is null.");
            return Promises.resolve(null);
        }
        ArrayList<Promise> created = new ArrayList<Promise>();
        ArrayList<Promise> createdDeeper = new ArrayList<Promise>();
        Folder folder = (Folder)this._srmService.createStub(parentMoRef);
        for (Configurable configurable : ieParentFolder.getChildren()) {
            if (configurable instanceof IeFolder) {
                IeFolder childFolder = (IeFolder)configurable;
                Promise childPromise = this.createFolder(parentMoRef, folder, childFolder.getName()).onSuccess(folderMoRef -> {
                    if (folderMoRef == null) {
                        ImpexImportSrmContext.get().addError(ImpexL10N.localize("plan.folder", childFolder.getName()));
                    }
                });
                created.add(childPromise);
                createdDeeper.add(childPromise.thenCompose(child -> this.createFolders(childFolder, (ManagedObjectReference)child)));
                continue;
            }
            if (configurable instanceof IeRecoveryPlan) {
                IeRecoveryPlan ieRp = (IeRecoveryPlan)configurable;
                if (ieRp.isRecoverySiteLocal() != this._local) continue;
                Promise rpMoRefPromise = this._creator.create(ieRp, parentMoRef).materialize().thenCompose(pr -> {
                    if (pr.isSuccessful()) {
                        LOGGER.info("Recovery plan '{}' successfully created.", (Object)ieRp.getName());
                        return Promises.resolve((Object)pr.getResult());
                    }
                    String message = ImpexL10N.localize("plan.create", ieRp.getName());
                    Exception error = pr.getError();
                    LOGGER.warn(message, (Throwable)error);
                    ImpexImportSrmContext.get().addError(message, error);
                    if (error instanceof DuplicateName) {
                        ManagedObjectReference existingRp = this.getExistingRecoveryPlan(parentMoRef, ieRp.getName());
                        if (existingRp == null) {
                            LOGGER.debug("Recovery plan '{}' does not exist.", (Object)ieRp.getName());
                            return Promises.reject((Exception)error);
                        }
                        if (ImpexImportSrmContext.get().getImportConfig().allowOverrideProtectionSettings()) {
                            return this._updater.updateRecoveryPlan(ieRp, existingRp).thenApply(unused -> existingRp);
                        }
                        return Promises.resolve((Object)existingRp);
                    }
                    return Promises.reject((Exception)pr.getError());
                });
                created.add(rpMoRefPromise);
                continue;
            }
            LOGGER.warn("Unexpected child type '{}'.", (Object)configurable);
        }
        if (!created.isEmpty()) {
            createdDeeper.add(Promises.allWithException((Promise[])created.toArray(new Promise[created.size()])));
        }
        if (createdDeeper.isEmpty()) {
            LOGGER.debug("No plan folder and children results.");
            return Promises.resolve(null);
        }
        return Promises.allWithException((Promise[])createdDeeper.toArray(new Promise[createdDeeper.size()])).thenApply(unused -> null);
    }

    private ManagedObjectReference getExistingRecoveryPlan(ManagedObjectReference parent, String name) {
        if (parent == null || name == null) {
            throw new IllegalArgumentException("Arguments parent, name or both are null.");
        }
        Object[] children = (ManagedObjectReference[])this._basicElementsPcResult.getProperty(parent, "childEntity");
        if (ArrayUtils.isEmpty((Object[])children)) {
            return null;
        }
        for (Object child : children) {
            String childName;
            String type = child.getType();
            if (!"DrRecoveryRecoveryPlan".equals(type) || !(childName = (String)this._basicElementsPcResult.getProperty((ManagedObjectReference)child, RECOVERY_PLAN.INFO_.NAME)).equals(name)) continue;
            return child;
        }
        return null;
    }
}

