/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.inventory;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.configurables.inventory.IeInventory;
import com.vmware.srm.client.impex.configurables.inventory.IeInventoryFolder;
import com.vmware.srm.client.impex.configurables.inventory.IeInventoryTree;
import com.vmware.srm.client.impex.configurables.inventory.InventoryConverter;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeDatacenter;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeDatastore;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeDistributedVirtualPortgroup;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeHost;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeNetwork;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeVirtualMachine;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.computeRes.IeSrmConfigComputeResource;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.resPool.IeSrmConfigResourcePool;
import com.vmware.srm.client.impex.tool.ConfigurablesWrapper;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.impex.utils.Lookup;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.vim.VIRTUAL_MACHINE;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InventoryExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryExtractor.class);

    protected abstract SrmServersDataWrapper getServersDataWrapper();

    protected abstract ConfigurablesWrapper getConfigurablesWrapper();

    public Promise<InventoryLookup> traverse() {
        ConcurrentHashMap<String, ManagedObjectReference> inventory = new ConcurrentHashMap<String, ManagedObjectReference>();
        ConcurrentHashMap<String, String> vmIdToKey = new ConcurrentHashMap<String, String>();
        Promise<Void> traverseLocalInventory = this.traverseInventory(inventory, vmIdToKey, true);
        Promise<Void> traverseRemoteInventory = this.traverseInventory(inventory, vmIdToKey, false);
        return traverseLocalInventory.thenCombine(traverseRemoteInventory, (lUnused, rUnused) -> new InventoryLookup(inventory, vmIdToKey));
    }

    private Promise<Void> traverseInventory(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, boolean local) {
        SrmServersDataWrapper serversData = this.getServersDataWrapper();
        String vcGuid = local ? ((SrmServer)serversData.getLocalPair().server()).vc().guid() : ((SrmServer)serversData.getRemotePair().server()).vc().guid();
        IeInventoryTree ieTree = this.getTree(this.getConfigurablesWrapper().getInventory(), local);
        if (ieTree == null || ieTree.getRoot() == null) {
            LOGGER.debug("Tree or its root is null for guid: '{}'.", (Object)vcGuid);
            return Promises.resolve(null);
        }
        return PCUtil.retrieveProperties((ServersView)serversData.getView(), (PropertyCollector.FilterSpec[])new PropertyCollector.FilterSpec[]{InventoryConverter.getFilterSpec(vcGuid)}).thenApply(pcResult -> {
            ManagedObjectReference root = InventoryConverter.getRootFolder(vcGuid);
            ManagedObjectReference[] children = (ManagedObjectReference[])pcResult.getProperty(root, "childEntity");
            List<IeInventory> ieChildren = ieTree.getRoot().getChildren();
            this.getInventory(inventory, vmIdToKey, (PcResult)pcResult, children, ieChildren);
            return null;
        });
    }

    private void getInventory(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, ManagedObjectReference[] entities, List<IeInventory> ieEntities) {
        Arrays.stream(entities).forEach(entity -> {
            switch (entity.getType()) {
                case "Folder": {
                    this.extractFolder(inventory, vmIdToKey, pcResult, (ManagedObjectReference)entity, ieEntities);
                    break;
                }
                case "Datacenter": {
                    this.extractDatacenter(inventory, vmIdToKey, pcResult, (ManagedObjectReference)entity, ieEntities);
                    break;
                }
                case "VirtualMachine": {
                    this.extractVm(inventory, vmIdToKey, pcResult, (ManagedObjectReference)entity, (List<? extends IeInventory>)ieEntities);
                    break;
                }
                case "ComputeResource": 
                case "ClusterComputeResource": {
                    this.extractComputeResource(inventory, vmIdToKey, pcResult, (ManagedObjectReference)entity, ieEntities);
                    break;
                }
                case "Network": 
                case "OpaqueNetwork": {
                    this.extractNetwork(inventory, pcResult, (ManagedObjectReference)entity, (List<? extends IeInventory>)ieEntities);
                    break;
                }
                case "DistributedVirtualPortgroup": {
                    this.extractDvp(inventory, pcResult, (ManagedObjectReference)entity, ieEntities);
                    break;
                }
                default: {
                    LOGGER.warn("Unexpected entity found '{}'", entity);
                }
            }
        });
    }

    private void extractFolder(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, ManagedObjectReference folder, List<IeInventory> ieEntities) {
        String name = (String)pcResult.getProperty(folder, "name");
        IeInventoryFolder ieFolder = this.getMatch(IeInventoryFolder.class, name, ieEntities);
        if (ieFolder == null) {
            LOGGER.debug("IeFolder is null");
            return;
        }
        ManagedObjectReference[] children = (ManagedObjectReference[])pcResult.getProperty(folder, "childEntity");
        if (inventory.putIfAbsent(ieFolder.getId(), folder) != null) {
            LOGGER.debug("Folder with id: '{}' and moRef: '{}' is already put.", (Object)ieFolder.getId(), (Object)folder);
        }
        this.getInventory(inventory, vmIdToKey, pcResult, children, ieFolder.getChildren());
    }

    private void extractDatacenter(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, ManagedObjectReference datacenter, List<IeInventory> ieEntities) {
        String name = (String)pcResult.getProperty(datacenter, "name");
        IeDatacenter ieDc = this.getMatch(IeDatacenter.class, name, ieEntities);
        if (ieDc == null) {
            LOGGER.debug("IeDatacenter is null");
            return;
        }
        if (inventory.putIfAbsent(ieDc.getId(), datacenter) != null) {
            LOGGER.debug("Datacenter with id: '{}' and moRef: '{}' is already put.", (Object)ieDc.getId(), (Object)datacenter);
        }
        this.extractDatastores(inventory, pcResult, datacenter, ieDc);
        ManagedObjectReference vmFolder = (ManagedObjectReference)pcResult.getProperty(datacenter, "vmFolder");
        IeInventoryFolder ieVmFolder = ieDc.getVmFolder();
        if (ieVmFolder != null && ieVmFolder.getId() != null) {
            if (inventory.putIfAbsent(ieVmFolder.getId(), vmFolder) != null) {
                LOGGER.debug("Vm folder with id: '{}' and moRef: '{}' is already put.", (Object)ieVmFolder.getId(), (Object)vmFolder);
            }
            ManagedObjectReference[] vmChildren = (ManagedObjectReference[])pcResult.getProperty(vmFolder, "childEntity");
            this.getInventory(inventory, vmIdToKey, pcResult, vmChildren, ieVmFolder.getChildren());
        }
        ManagedObjectReference hostFolder = (ManagedObjectReference)pcResult.getProperty(datacenter, "hostFolder");
        IeInventoryFolder ieHostFolder = ieDc.getHostFolder();
        if (ieHostFolder != null && ieHostFolder.getId() != null) {
            if (inventory.putIfAbsent(ieDc.getHostFolder().getId(), hostFolder) != null) {
                LOGGER.debug("Host folder with id: '{}' and moRef: '{}' is already put.", (Object)ieDc.getHostFolder().getId(), (Object)hostFolder);
            }
            ManagedObjectReference[] hostChildren = (ManagedObjectReference[])pcResult.getProperty(hostFolder, "childEntity");
            this.getInventory(inventory, vmIdToKey, pcResult, hostChildren, ieHostFolder.getChildren());
        }
        ManagedObjectReference networkFolder = (ManagedObjectReference)pcResult.getProperty(datacenter, "networkFolder");
        IeInventoryFolder ieNetworkFolder = ieDc.getNetworkFolder();
        if (ieNetworkFolder != null && ieNetworkFolder.getId() != null) {
            if (inventory.putIfAbsent(ieNetworkFolder.getId(), networkFolder) != null) {
                LOGGER.debug("Network folder with id: '{}' and moRef: '{}' is already put.", (Object)ieNetworkFolder.getId(), (Object)networkFolder);
            }
            ManagedObjectReference[] networkFolderChildren = (ManagedObjectReference[])pcResult.getProperty(networkFolder, "childEntity");
            this.getInventory(inventory, vmIdToKey, pcResult, networkFolderChildren, ieNetworkFolder.getChildren());
        }
    }

    private void extractNetwork(Map<String, ManagedObjectReference> inventory, PcResult pcResult, ManagedObjectReference network, List<? extends IeInventory> ieEntities) {
        String name = (String)pcResult.getProperty(network, "name");
        IeNetwork ieNetwork = this.getMatch(IeNetwork.class, name, ieEntities);
        if (ieNetwork != null && inventory.putIfAbsent(ieNetwork.getId(), network) != null) {
            LOGGER.debug("Network with id: '{}' and moRef: '{}' is already put.", (Object)ieNetwork.getId(), (Object)network);
        }
    }

    private void extractDvp(Map<String, ManagedObjectReference> inventory, PcResult pcResult, ManagedObjectReference dvp, List<IeInventory> ieEntities) {
        String name = (String)pcResult.getProperty(dvp, "name");
        IeDistributedVirtualPortgroup ieDvp = this.getMatch(IeDistributedVirtualPortgroup.class, name, ieEntities);
        if (ieDvp != null && inventory.putIfAbsent(ieDvp.getId(), dvp) != null) {
            LOGGER.debug("Network with id: '{}' and moRef: '{}' is already put.", (Object)ieDvp.getId(), (Object)dvp);
        }
    }

    private void extractDatastores(Map<String, ManagedObjectReference> inventory, PcResult pcResult, ManagedObjectReference datacenter, IeDatacenter ieDc) {
        ManagedObjectReference[] datastores = (ManagedObjectReference[])pcResult.getProperty(datacenter, "datastore");
        Arrays.stream(datastores).forEach(datastore -> {
            String name = (String)pcResult.getProperty(datastore, "name");
            IeDatastore ieDatastore = this.getMatch(IeDatastore.class, name, ieDc.getDatastores());
            if (ieDatastore != null && inventory.putIfAbsent(ieDatastore.getId(), (ManagedObjectReference)datastore) != null) {
                LOGGER.debug("Datastore with id: '{}' and moRef: '{}' is already put.", (Object)ieDatastore.getId(), datastore);
            }
        });
    }

    private void extractVm(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, ManagedObjectReference vm, List<? extends IeInventory> ieEntities) {
        String key;
        String name = (String)pcResult.getProperty(vm, "name");
        IeVirtualMachine ieVm = this.getMatch(IeVirtualMachine.class, name, ieEntities);
        if (ieVm == null) {
            LOGGER.debug("IeVm is null");
            return;
        }
        String id = ieVm.getId();
        if (inventory.putIfAbsent(id, vm) != null) {
            LOGGER.debug("VM with id: '{}' and moRef: '{}' is already put in inventory, current record: '{}'.", new Object[]{id, vm, inventory.get(id)});
        }
        if ((key = (String)pcResult.tryGetProperty(vm, VIRTUAL_MACHINE.CONFIG_.INSTANCE_UUID)) == null) {
            LOGGER.info("Unable to retrieve instance UUID for VM with id: '{}' and moRef: '{}', vmIdToKey record: '{}'.", new Object[]{id, vm, vmIdToKey.getOrDefault(id, "no record")});
        } else if (vmIdToKey.putIfAbsent(id, key) != null) {
            LOGGER.debug("VM with id: '{}', moRef: '{}', and instance UUID: '{}' is already put in vmKeys, current record: '{}'.", new Object[]{id, vm, key, vmIdToKey.get(id)});
        }
    }

    private void extractVmInfo(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, IeSrmConfigResourcePool ieResourcePool, ManagedObjectReference resourcePool) {
        ManagedObjectReference[] vms = (ManagedObjectReference[])pcResult.getProperty(resourcePool, "vm");
        Arrays.stream(vms).forEach(vm -> this.extractVm(inventory, vmIdToKey, pcResult, (ManagedObjectReference)vm, ieResourcePool.getVirtualMachines()));
    }

    private void extractHosts(Map<String, ManagedObjectReference> inventory, PcResult pcResult, ManagedObjectReference[] hosts, List<IeHost> ieHosts) {
        Arrays.stream(hosts).forEach(host -> {
            String name = (String)pcResult.getProperty(host, "name");
            IeHost ieHost = this.getMatch(IeHost.class, name, ieHosts);
            if (ieHost != null && inventory.putIfAbsent(ieHost.getId(), (ManagedObjectReference)host) != null) {
                LOGGER.debug("Host with id: '{}' and moRef: '{}' is already put.", (Object)ieHost.getId(), host);
            }
        });
    }

    private void extractComputeResource(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, ManagedObjectReference computeResource, List<IeInventory> ieEntities) {
        String name = (String)pcResult.getProperty(computeResource, "name");
        IeSrmConfigComputeResource ieComputeResource = this.getMatch(IeSrmConfigComputeResource.class, name, ieEntities);
        if (ieComputeResource == null) {
            LOGGER.debug("IeComputeResource is null");
            return;
        }
        ManagedObjectReference[] hosts = (ManagedObjectReference[])pcResult.getProperty(computeResource, "host");
        this.extractHosts(inventory, pcResult, hosts, ieComputeResource.getHosts());
        IeSrmConfigResourcePool ieResourcePool = (IeSrmConfigResourcePool)ieComputeResource.getResourcePool();
        if (ieResourcePool == null) {
            LOGGER.debug("IeResourcePool is null");
            return;
        }
        ManagedObjectReference resourcePool = (ManagedObjectReference)pcResult.getProperty(computeResource, "resourcePool");
        if (ieResourcePool.getId() != null && inventory.putIfAbsent(ieResourcePool.getId(), resourcePool) != null) {
            LOGGER.debug("Resource pool with id: '{}' and moRef: '{}' is already put.", (Object)ieResourcePool.getId(), (Object)resourcePool);
        }
        ManagedObjectReference[] resourcePoolChildren = (ManagedObjectReference[])pcResult.getProperty(resourcePool, "resourcePool");
        this.extractResourcePoolChildren(inventory, vmIdToKey, pcResult, resourcePoolChildren, ieResourcePool.getChildren(), false);
    }

    private void extractResourcePoolChildren(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, ManagedObjectReference[] resourcePools, List<IeSrmConfigResourcePool> ieResourcePools, boolean extractVms) {
        Arrays.stream(resourcePools).forEach(resourcePool -> {
            String name = (String)pcResult.getProperty(resourcePool, "name");
            if ("ResourcePool".equals(resourcePool.getType())) {
                IeSrmConfigResourcePool ieResourcePool = this.getMatch(IeSrmConfigResourcePool.class, name, ieResourcePools);
                this.extractResourcePoolInfo(inventory, vmIdToKey, pcResult, ieResourcePool, (ManagedObjectReference)resourcePool, extractVms);
                if (extractVms) {
                    this.extractVmInfo(inventory, vmIdToKey, pcResult, ieResourcePool, (ManagedObjectReference)resourcePool);
                }
            } else if ("VirtualApp".equals(resourcePool.getType())) {
                IeSrmConfigResourcePool ieVirtualApp = this.getMatch(IeSrmConfigResourcePool.class, name, ieResourcePools);
                this.extractResourcePoolInfo(inventory, vmIdToKey, pcResult, ieVirtualApp, (ManagedObjectReference)resourcePool, true);
                this.extractVmInfo(inventory, vmIdToKey, pcResult, ieVirtualApp, (ManagedObjectReference)resourcePool);
            }
        });
    }

    private void extractResourcePoolInfo(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, IeSrmConfigResourcePool ieResourcePool, ManagedObjectReference resourcePool, boolean extractVms) {
        if (ieResourcePool == null || ieResourcePool.getId() == null) {
            return;
        }
        if (inventory.putIfAbsent(ieResourcePool.getId(), resourcePool) != null) {
            LOGGER.debug("Resource pool with id: '{}' and moRef: '{}' is already put.", (Object)ieResourcePool.getId(), (Object)resourcePool);
        }
        ManagedObjectReference[] resourcePoolChildren = (ManagedObjectReference[])pcResult.getProperty(resourcePool, "resourcePool");
        this.extractResourcePoolChildren(inventory, vmIdToKey, pcResult, resourcePoolChildren, ieResourcePool.getChildren(), extractVms);
    }

    private <T> T getMatch(Class<T> type, String name, List<? extends IeInventory> ieEntities) {
        Objects.requireNonNull(type);
        if (name == null) {
            LOGGER.debug("Match name is null for type '{}'.", (Object)type.getName());
            return null;
        }
        if (ieEntities == null) {
            LOGGER.debug("Match entities are null for type '{}' and name '{}'.", (Object)type.getName(), (Object)name);
            return null;
        }
        T result = ieEntities.stream().filter(ieEntity -> name.equals(ieEntity.getName()) && ieEntity.getId() != null && type.isInstance(ieEntity)).findFirst().map(type::cast).orElse(null);
        if (result == null) {
            LOGGER.warn("No match found for '{}', with type '{}'.", (Object)name, (Object)type.getName());
        }
        return result;
    }

    private IeInventoryTree getTree(Collection<IeInventoryTree> trees, boolean isLocal) {
        return trees.stream().filter(tree -> tree.isLocal() == isLocal).findFirst().orElse(null);
    }

    public static class InventoryLookup
    extends Lookup<String, ManagedObjectReference> {
        private final Map<String, String> _vmIdToKey;

        InventoryLookup(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey) {
            super(inventory);
            this._vmIdToKey = vmIdToKey;
        }

        public VmKeysLookup getVmKeysLookup() {
            return new VmKeysLookup(this._vmIdToKey);
        }
    }

    public static class VmKeysLookup
    extends Lookup<String, String> {
        public VmKeysLookup(Map<String, String> vmIdToKey) {
            super(vmIdToKey);
        }
    }
}

