/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.wstrust.client.impl.processors.request;

import com.vmware.identity.wstrust.client.impl.SoapMessage;
import com.vmware.identity.wstrust.client.impl.Util;
import com.vmware.identity.wstrust.client.impl.exception.ParserException;
import com.vmware.identity.wstrust.client.impl.processors.request.RequestBuilderImpl;
import com.vmware.vim.sso.client.SamlToken;
import javax.xml.bind.JAXBContext;
import org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SecurityHeaderType;

public final class RenewTokenRequestBuilder
extends RequestBuilderImpl {
    private static final String RENEW_REQUEST_TYPE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew";
    private static final String RENEW_SOAP_ACTION = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Renew";
    private static final String RENEW_TARGET_ELEMENT_NAME = "RenewTarget";
    private final SamlToken _token;
    private final long _tokenLifetimeSec;

    public RenewTokenRequestBuilder(SamlToken token, long tokenLifetime, JAXBContext jaxbContext, int requestValidityInSeconds) {
        super(jaxbContext, requestValidityInSeconds, RENEW_SOAP_ACTION);
        assert (token != null);
        assert (tokenLifetime > 0L) : tokenLifetime;
        this._token = token;
        this._tokenLifetimeSec = tokenLifetime;
    }

    @Override
    protected void addSecurityHeaderInfo(SecurityHeaderType header) {
    }

    @Override
    protected Object createBody(ObjectFactory wstFactory) throws ParserException {
        RequestSecurityTokenType request = wstFactory.createRequestSecurityTokenType();
        request.setTokenType("urn:oasis:names:tc:SAML:2.0:assertion");
        request.setRequestType(RENEW_REQUEST_TYPE);
        request.setLifetime(this.createLifetimeElement(this._tokenLifetimeSec));
        request.setRenewTarget(wstFactory.createRenewTargetType());
        return request;
    }

    @Override
    protected void postProcessRequest(SoapMessage message) throws ParserException {
        this.insertSamlToken(message, "http://docs.oasis-open.org/ws-sx/ws-trust/200512", RENEW_TARGET_ELEMENT_NAME, this._token);
    }

    @Override
    protected String createRedactedDescription() {
        return this.getClass().getSimpleName() + " [token=" + Util.createRedactedDescription(this._token) + "tokenLifetimeSec=" + this._tokenLifetimeSec + "]";
    }
}

