/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.wstrust.client.impl.processors.request;

import com.vmware.identity.wstrust.client.impl.SoapMessage;
import com.vmware.identity.wstrust.client.impl.Util;
import com.vmware.identity.wstrust.client.impl.exception.ParserException;
import com.vmware.identity.wstrust.client.impl.processors.request.RequestBuilderImpl;
import com.vmware.vim.sso.client.SamlToken;
import javax.xml.bind.JAXBContext;
import org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.ValidateTargetType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SecurityHeaderType;

public final class ValidateTokenRequestBuilder
extends RequestBuilderImpl {
    private static final String REQUEST_TYPE_VALIDATE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate";
    private static final String SOAP_ACTION_VALIDATE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Validate";
    private static final String TOKEN_TYPE_STATUS = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status";
    private static final String VALIDATE_TARGET_ELEMENT_NAME = "ValidateTarget";
    private final SamlToken _token;

    public ValidateTokenRequestBuilder(SamlToken token, JAXBContext jaxbContext, int requestValidityInSeconds) {
        super(jaxbContext, requestValidityInSeconds, SOAP_ACTION_VALIDATE);
        assert (token != null);
        this._token = token;
    }

    @Override
    protected void addSecurityHeaderInfo(SecurityHeaderType header) {
    }

    @Override
    protected Object createBody(ObjectFactory wstFactory) throws ParserException {
        RequestSecurityTokenType request = wstFactory.createRequestSecurityTokenType();
        request.setRequestType(REQUEST_TYPE_VALIDATE);
        request.setTokenType(TOKEN_TYPE_STATUS);
        request.setValidateTarget(new ValidateTargetType());
        return request;
    }

    @Override
    protected void postProcessRequest(SoapMessage message) throws ParserException {
        this.insertSamlToken(message, "http://docs.oasis-open.org/ws-sx/ws-trust/200512", VALIDATE_TARGET_ELEMENT_NAME, this._token);
    }

    @Override
    protected String createRedactedDescription() {
        return this.getClass().getSimpleName() + " [token=" + Util.createRedactedDescription(this._token) + "]";
    }
}

