/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl;

import com.vmware.provider.VecsLoadStoreParameter;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.exception.CertificateValidationException;
import com.vmware.vim.sso.client.exception.ServerCommunicationException;
import com.vmware.vim.sso.client.impl.SiteAffinityServiceDiscovery;
import com.vmware.vim.sso.client.impl.SoapBinding;
import com.vmware.vim.sso.client.impl.SoapFault;
import com.vmware.vim.sso.client.impl.SoapMessage;
import com.vmware.vim.sso.client.impl.ValidateUtil;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import com.vmware.vim.sso.client.impl.exception.SoapFaultException;
import com.vmware.vim.sso.client.impl.ssl.ConfigurableSSLSocketFactory;
import com.vmware.vim.sso.client.impl.ssl.StsSslTrustManager;
import com.vmware.vim.sso.client.impl.ssl.UntrustedSslCertificateException;
import com.vmware.vim.sso.client.tracer.GlobalTracer;
import com.vmware.vim.sso.client.tracer.TracingFeature;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.ws.spi.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapBindingImpl
implements SoapBinding {
    private static final String STORE_NAME = "TRUSTED_ROOTS";
    private static final String KEYSTORE_TYPE = "VKS";
    private static final String WS_TRUST_NAMESPACE_WSDL = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/wsdl";
    private static final String STS_SERVICE = "STSService";
    private static final String STS_SERVICE_PORT = "STSService_Port";
    private static final String WS_OVER_SSL_RESOURCE = "com/vmware/vim/sso/client/impl/ssl/ws_over_ssl.properties";
    private static final QName serviceName = new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512/wsdl", "STSService");
    private static final QName portName = new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512/wsdl", "STSService_Port");
    private static final Logger _log = LoggerFactory.getLogger(SoapBindingImpl.class);
    private final SecurityTokenServiceConfig.ConnectionConfig _connConfig;
    private final SiteAffinityServiceDiscovery serviceDiscovery;
    private KeyStore trustStore;

    public SoapBindingImpl(SecurityTokenServiceConfig.ConnectionConfig connConfig) {
        block4: {
            assert (connConfig != null);
            this._connConfig = connConfig;
            this.serviceDiscovery = new SiteAffinityServiceDiscovery(this._connConfig);
            if (this._connConfig.isSiteAffinityUsed()) {
                try {
                    this.trustStore = KeyStore.getInstance(KEYSTORE_TYPE);
                    this.trustStore.load((KeyStore.LoadStoreParameter)new VecsLoadStoreParameter(STORE_NAME));
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn(String.format("Could not load VECS keystore: %s", e.toString()));
                }
            }
        }
    }

    @Override
    public SoapMessage sendMessage(SoapMessage message) throws ServerCommunicationException, ParserException, SoapFaultException, CertificateValidationException {
        Span span;
        URL connectionURL = this.serviceDiscovery.getServiceLocation();
        if (TracingFeature.ON && (span = GlobalTracer.get().activeSpan()) != null) {
            span.setTag(Tags.HTTP_URL.getKey(), connectionURL.toString());
        }
        Dispatch<SOAPMessage> dispatch = this.createDispatch(message.getSoapAction(), connectionURL);
        if (_log.isDebugEnabled()) {
            _log.debug("Sending SOAP request to the STS server");
        }
        SOAPMessage response = this.sendMessage(dispatch, message.getMessage(), connectionURL);
        if (_log.isDebugEnabled()) {
            _log.debug("Received SOAP response from the STS server");
        }
        return new SoapMessage(response, message.getSoapAction());
    }

    private Dispatch<SOAPMessage> createDispatch(String soapAction, URL serviceURL) throws ServerCommunicationException {
        Service service = Service.create((QName)serviceName);
        service.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", serviceURL.toString());
        Dispatch dispatch = null;
        try {
            dispatch = service.createDispatch(portName, SOAPMessage.class, Service.Mode.MESSAGE);
        }
        catch (WebServiceException e) {
            String errMsg = "Error communicating to the remote server " + serviceURL;
            _log.error(errMsg, (Throwable)e);
            throw new ServerCommunicationException(errMsg, e);
        }
        this.setSoapAction((Dispatch<SOAPMessage>)dispatch, soapAction);
        if ("https".equalsIgnoreCase(serviceURL.getProtocol())) {
            this.establishSslTrust((BindingProvider)dispatch, serviceURL, new TrustManager[]{new StsSslTrustManager(this._connConfig, this.trustStore)});
        }
        return dispatch;
    }

    private void setSoapAction(Dispatch<SOAPMessage> dispatch, String soapAction) {
        Map requestContext = dispatch.getRequestContext();
        requestContext.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
        requestContext.put("javax.xml.ws.soap.http.soapaction.uri", soapAction);
    }

    private SOAPMessage sendMessage(Dispatch<SOAPMessage> dispatch, SOAPMessage request, URL serviceURL) throws SoapFaultException, ServerCommunicationException, CertificateValidationException {
        Tracer tracer;
        Span span = null;
        if (TracingFeature.ON && (span = (tracer = GlobalTracer.get()).activeSpan()) != null) {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new RequestBuilderInjectAdapter(headers));
            Map requestContext = dispatch.getRequestContext();
            Object existingHeaders = requestContext.get("javax.xml.ws.http.request.headers");
            if (existingHeaders != null && existingHeaders instanceof Map) {
                ((Map)existingHeaders).putAll(headers);
            } else {
                requestContext.put("javax.xml.ws.http.request.headers", headers);
            }
        }
        try {
            tracer = (SOAPMessage)dispatch.invoke((Object)request);
            return tracer;
        }
        catch (SOAPFaultException e) {
            _log.error("SOAP fault", (Throwable)e);
            SoapBindingImpl.traceException(span, (Exception)((Object)e));
            throw new SoapFaultException("", new SoapFault(e.getFault()));
        }
        catch (WebServiceException e) {
            SSLHandshakeException ex;
            if (e.getCause() instanceof SSLHandshakeException && (ex = (SSLHandshakeException)e.getCause()).getCause() instanceof UntrustedSslCertificateException) {
                this.logAndThrow((UntrustedSslCertificateException)ex.getCause());
            }
            String errMsg = "Error communicating to the remote server " + serviceURL;
            _log.error(errMsg, (Throwable)e);
            SoapBindingImpl.traceException(span, (Exception)((Object)e));
            throw new ServerCommunicationException(errMsg, e);
        }
        finally {
            if (span != null) {
                span.finish();
            }
        }
    }

    private void establishSslTrust(BindingProvider bindingProvider, final URL serviceURL, TrustManager[] sslTrust) {
        assert (!ValidateUtil.isEmpty(sslTrust));
        SSLSocketFactory socketFactory = null;
        try {
            SSLContext sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(null, sslTrust, null);
            socketFactory = sslCtx.getSocketFactory();
        }
        catch (Exception e) {
            String errMsg = "Cannot create default SSL socket factory";
            _log.error(errMsg, (Throwable)e);
            throw new IllegalStateException(errMsg, e);
        }
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put(this.getSslSocketFactoryProperty(), new ConfigurableSSLSocketFactory(socketFactory){

            @Override
            protected Socket configureSocket(Socket s) {
                if (s instanceof SSLSocket) {
                    SSLSocket ssl = (SSLSocket)s;
                    SNIHostName sniHostName = SoapBindingImpl.getSNIHostName(serviceURL);
                    if (null != sniHostName) {
                        SSLParameters sslParameters = new SSLParameters();
                        sslParameters.setServerNames(Collections.singletonList(sniHostName));
                        ssl.setSSLParameters(sslParameters);
                    }
                }
                return s;
            }
        });
    }

    private static SNIHostName getSNIHostName(URL url) {
        String host = url.getHost();
        if (null != host) {
            try {
                return new SNIHostName(host);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getSslSocketFactoryProperty() {
        Logger log = LoggerFactory.getLogger(SoapBindingImpl.class);
        String wsProviderClass = Provider.provider().getClass().getName();
        InputStream is = null;
        try {
            is = SoapBindingImpl.class.getClassLoader().getResourceAsStream(WS_OVER_SSL_RESOURCE);
            Properties resource = new Properties();
            resource.load(is);
            String socketFactoryProperty = resource.getProperty(wsProviderClass);
            if (socketFactoryProperty == null) {
                log.warn(String.format("SSO client cannot connect to STS over SSL because WS provider '%s' is NOT configured.", wsProviderClass));
            } else if (log.isDebugEnabled()) {
                log.debug(String.format("WS provider '%s' configured with SSL. Socket factory property is '%s'", wsProviderClass, socketFactoryProperty));
            }
            String string = socketFactoryProperty;
            return string;
        }
        catch (IOException e) {
            String message = "Cannot load WS over SSL resource file";
            log.error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void logAndThrow(UntrustedSslCertificateException e) throws CertificateValidationException {
        _log.error(e.getMessage(), (Throwable)e);
        throw new CertificateValidationException(e.getMessage(), e.getServerCertificateChain(), e.getServerCertificateThumbprint());
    }

    private static void traceException(Span span, Exception e) {
        if (span == null) {
            return;
        }
        HashMap<String, Object> errorLogs = new HashMap<String, Object>();
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.object", e);
        span.log(errorLogs).setTag(Tags.ERROR.getKey(), Boolean.TRUE.booleanValue());
    }

    static class RequestBuilderInjectAdapter
    implements TextMap {
        Map<String, List<String>> headers;

        RequestBuilderInjectAdapter(Map<String, List<String>> headers) {
            this.headers = headers;
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            throw new UnsupportedOperationException("Should be used only with tracer#inject()");
        }

        public void put(String key, String value) {
            this.headers.put(key, Collections.singletonList(value));
        }
    }
}

