/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.dr.recovery;

import com.vmware.vim.binding.dr.recovery.RecoveryOptions;
import com.vmware.vim.binding.dr.recovery.RecoveryResult;
import com.vmware.vim.binding.dr.version.version0;
import com.vmware.vim.binding.dr.version.version16;
import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.task;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.util.Calendar;

@managed
@versionClass(value=version0.class)
@wsdlName(value="DrRecoveryRecoveryHistoryManager")
public interface RecoveryHistoryManager
extends ManagedObject {
    @readonly
    @name(value="historyKeys")
    @privilege(value="VcDr.Internal.com.vmware.vcDr.InternalAccess")
    @versionClass(value=version0.class)
    @optional
    @list
    public void getHistoryKeys(@optional Future<long[]> var1);

    @versionClass(value=version0.class)
    @wsdlName(value="RetrieveHistoryInfoCount")
    @privilege(value="System.View")
    public void retrieveHistoryInfoCount(Future<Integer> var1);

    @versionClass(value=version0.class)
    @wsdlName(value="RetrieveHistoryInfo_Task")
    @privilege(value="System.View")
    @task
    @list
    public void retrieveHistoryInfo(@name(value="start") @versionClass(value=version0.class) int var1, @name(value="count") @versionClass(value=version0.class) int var2, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="RetrieveRecoveryResultCount")
    @privilege(value="System.View")
    @faults(value={"DrRecoveryFaultHistoryKeyNotFound"})
    public void retrieveRecoveryResultCount(@name(value="historyKey") @versionClass(value=version0.class) long var1, Future<Integer> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="RetrieveRecoveryResult")
    @privilege(value="System.View")
    @list
    @faults(value={"DrRecoveryFaultHistoryKeyNotFound", "DrRecoveryFaultRunKeyNotFound"})
    public void retrieveRecoveryResult(@name(value="historyKey") @versionClass(value=version0.class) long var1, @name(value="startRunKey") @versionClass(value=version0.class) @optional Long var3, @name(value="length") @versionClass(value=version0.class) int var4, @optional @list Future<RecoveryResult[]> var5);

    @versionClass(value=version0.class)
    @wsdlName(value="CountDetailedRecoveryResults")
    @privilege(value="System.View")
    @faults(value={"DrRecoveryFaultRunKeyNotFound"})
    public void countDetailedRecoveryResults(@name(value="runKey") @versionClass(value=version0.class) long var1, Future<Integer> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="GetDetailedRecoveryResult_Task")
    @privilege(value="System.View")
    @task
    @faults(value={"DrRecoveryFaultRunKeyNotFound", "InvalidArgument"})
    public void getDetailedRecoveryResult(@name(value="runKey") @versionClass(value=version0.class) long var1, @name(value="offset") @versionClass(value=version0.class) int var3, @name(value="maxLines") @versionClass(value=version0.class) int var4, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var5);

    @versionClass(value=version0.class)
    @wsdlName(value="RetrieveHistoryWindowCount")
    @privilege(value="System.View")
    @faults(value={"InvalidArgument"})
    public void retrieveHistoryWindowCount(@name(value="dateStart") @versionClass(value=version0.class) Calendar var1, @name(value="dateEnd") @versionClass(value=version0.class) Calendar var2, Future<Integer> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="RetrieveHistoryWindow_Task")
    @privilege(value="System.View")
    @task
    @list
    @faults(value={"InvalidArgument"})
    public void retrieveHistoryWindow(@name(value="dateStart") @versionClass(value=version0.class) Calendar var1, @name(value="dateEnd") @versionClass(value=version0.class) Calendar var2, @name(value="start") @versionClass(value=version0.class) int var3, @name(value="count") @versionClass(value=version0.class) int var4, @name(value="historyKey") @versionClass(value=version0.class) @optional Long var5, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var6);

    @versionClass(value=version0.class)
    @wsdlName(value="GetRecoveryRunReport_Task")
    @privilege(value="System.View")
    @task
    @map
    @faults(value={"InvalidArgument", "DrRecoveryFaultHistoryKeyNotFound"})
    public void GetRecoveryRunReport(@name(value="dateStart") @versionClass(value=version0.class) Calendar var1, @name(value="dateEnd") @versionClass(value=version0.class) Calendar var2, @name(value="historyKey") @versionClass(value=version0.class) @optional Long var3, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var4);

    @versionClass(value=version0.class)
    @wsdlName(value="RetrieveMostRecentExecution_Task")
    @privilege(value="System.View")
    @task
    @faults(value={"DrRecoveryFaultHistoryKeyNotFound"})
    public void retrieveMostRecentExecution(@name(value="historyKey") @versionClass(value=version0.class) long var1, @name(value="mode") @versionClass(value=version0.class) @optional RecoveryResult.RecoveryOp var3, @name(value="successfulOnly") @versionClass(value=version0.class) @optional Boolean var4, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var5);

    @versionClass(value=version0.class)
    @wsdlName(value="GetResultXslt")
    @privilege(value="System.View")
    public void GetResultXslt(Future<String> var1);

    @versionClass(value=version0.class)
    @wsdlName(value="RemoveRecoveryWindowResults")
    @privilege(value="VcDr.RecoveryHistoryManager.com.vmware.vcDr.Delete")
    @faults(value={"InvalidArgument"})
    public void removeRecoveryWindowResults(@name(value="dateStart") @versionClass(value=version0.class) Calendar var1, @name(value="dateEnd") @versionClass(value=version0.class) Calendar var2, @name(value="deletedPlansOnly") @versionClass(value=version0.class) boolean var3, Future<Integer> var4);

    @versionClass(value=version0.class)
    @wsdlName(value="RunKeys_Task")
    @privilege(value="VcDr.Internal.com.vmware.vcDr.InternalAccess")
    @task
    @list
    @faults(value={"DrRecoveryFaultHistoryKeyNotFound"})
    public void runKeys(@name(value="historyKey") @versionClass(value=version0.class) long var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var3);

    @versionClass(value=version0.class)
    @wsdlName(value="SyncResult_Task")
    @privilege(value="VcDr.Internal.com.vmware.vcDr.InternalAccess")
    @task
    @faults(value={"DrRecoveryFaultHistoryKeyNotFound", "DrRecoveryFaultRunKeyNotFound"})
    public void SyncResult(@name(value="historyKey") @versionClass(value=version0.class) long var1, @name(value="runKey") @versionClass(value=version0.class) long var3, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var5);

    @versionClass(value=version0.class)
    @wsdlName(value="DrRecoveryRecoveryHistoryManagerCompressedResult")
    @data
    @propertyOrder(value={"historyKey", "runKey", "operation", "options", "planName", "planDescription", "planUserAuthority", "planCancelAuthority", "startTimeMinutes", "startTime", "stopTime", "executionTimeInSeconds", "totalPausedTimeInSeconds", "resultState", "warningCount", "errorCount", "numXmlLines", "originalSizeInBytes", "compressedResults", "poweredOnVms", "errorStateVms", "successfullyRecoveredVms", "ipCustomizedVms", "errorIpCustomizedVms", "poweredOffVms", "warnings", "errors"})
    public static class CompressedResult
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public long historyKey;
        public long runKey;
        public int operation;
        public RecoveryOptions options;
        public String planName;
        public String planDescription;
        public String planUserAuthority;
        public String planCancelAuthority;
        public int startTimeMinutes;
        public Calendar startTime;
        public Calendar stopTime;
        public long executionTimeInSeconds;
        public long totalPausedTimeInSeconds;
        public RecoveryResult.ResultState resultState;
        public int warningCount;
        public int errorCount;
        public int numXmlLines;
        public int originalSizeInBytes;
        public String[] compressedResults;
        public Integer poweredOnVms;
        public Integer errorStateVms;
        public Integer successfullyRecoveredVms;
        public Integer ipCustomizedVms;
        public Integer errorIpCustomizedVms;
        public Integer poweredOffVms;
        public Exception[] warnings;
        public Exception[] errors;

        public CompressedResult() {
        }

        public CompressedResult(long historyKey, long runKey, int operation, RecoveryOptions options, String planName, String planDescription, String planUserAuthority, String planCancelAuthority, int startTimeMinutes, Calendar startTime, Calendar stopTime, long executionTimeInSeconds, long totalPausedTimeInSeconds, RecoveryResult.ResultState resultState, int warningCount, int errorCount, int numXmlLines, int originalSizeInBytes, String[] compressedResults, Integer poweredOnVms, Integer errorStateVms, Integer successfullyRecoveredVms, Integer ipCustomizedVms, Integer errorIpCustomizedVms, Integer poweredOffVms, Exception[] warnings, Exception[] errors) {
            this.historyKey = historyKey;
            this.runKey = runKey;
            this.operation = operation;
            this.options = options;
            this.planName = planName;
            this.planDescription = planDescription;
            this.planUserAuthority = planUserAuthority;
            this.planCancelAuthority = planCancelAuthority;
            this.startTimeMinutes = startTimeMinutes;
            this.startTime = startTime;
            this.stopTime = stopTime;
            this.executionTimeInSeconds = executionTimeInSeconds;
            this.totalPausedTimeInSeconds = totalPausedTimeInSeconds;
            this.resultState = resultState;
            this.warningCount = warningCount;
            this.errorCount = errorCount;
            this.numXmlLines = numXmlLines;
            this.originalSizeInBytes = originalSizeInBytes;
            this.compressedResults = compressedResults;
            this.poweredOnVms = poweredOnVms;
            this.errorStateVms = errorStateVms;
            this.successfullyRecoveredVms = successfullyRecoveredVms;
            this.ipCustomizedVms = ipCustomizedVms;
            this.errorIpCustomizedVms = errorIpCustomizedVms;
            this.poweredOffVms = poweredOffVms;
            this.warnings = warnings;
            this.errors = errors;
        }

        @versionClass(value=version0.class)
        public long getHistoryKey() {
            return this.historyKey;
        }

        @versionClass(value=version0.class)
        public void setHistoryKey(long historyKey) {
            this.historyKey = historyKey;
        }

        @versionClass(value=version0.class)
        public long getRunKey() {
            return this.runKey;
        }

        @versionClass(value=version0.class)
        public void setRunKey(long runKey) {
            this.runKey = runKey;
        }

        @versionClass(value=version0.class)
        public int getOperation() {
            return this.operation;
        }

        @versionClass(value=version0.class)
        public void setOperation(int operation) {
            this.operation = operation;
        }

        @optional
        @versionClass(value=version0.class)
        public RecoveryOptions getOptions() {
            return this.options;
        }

        @optional
        @versionClass(value=version0.class)
        public void setOptions(RecoveryOptions options) {
            this.options = options;
        }

        @versionClass(value=version0.class)
        public String getPlanName() {
            return this.planName;
        }

        @versionClass(value=version0.class)
        public void setPlanName(String planName) {
            this.planName = planName;
        }

        @optional
        @versionClass(value=version0.class)
        public String getPlanDescription() {
            return this.planDescription;
        }

        @optional
        @versionClass(value=version0.class)
        public void setPlanDescription(String planDescription) {
            this.planDescription = planDescription;
        }

        @versionClass(value=version0.class)
        public String getPlanUserAuthority() {
            return this.planUserAuthority;
        }

        @versionClass(value=version0.class)
        public void setPlanUserAuthority(String planUserAuthority) {
            this.planUserAuthority = planUserAuthority;
        }

        @optional
        @versionClass(value=version0.class)
        public String getPlanCancelAuthority() {
            return this.planCancelAuthority;
        }

        @optional
        @versionClass(value=version0.class)
        public void setPlanCancelAuthority(String planCancelAuthority) {
            this.planCancelAuthority = planCancelAuthority;
        }

        @versionClass(value=version0.class)
        public int getStartTimeMinutes() {
            return this.startTimeMinutes;
        }

        @versionClass(value=version0.class)
        public void setStartTimeMinutes(int startTimeMinutes) {
            this.startTimeMinutes = startTimeMinutes;
        }

        @versionClass(value=version0.class)
        public Calendar getStartTime() {
            return this.startTime;
        }

        @versionClass(value=version0.class)
        public void setStartTime(Calendar startTime) {
            this.startTime = startTime;
        }

        @versionClass(value=version0.class)
        public Calendar getStopTime() {
            return this.stopTime;
        }

        @versionClass(value=version0.class)
        public void setStopTime(Calendar stopTime) {
            this.stopTime = stopTime;
        }

        @versionClass(value=version0.class)
        public long getExecutionTimeInSeconds() {
            return this.executionTimeInSeconds;
        }

        @versionClass(value=version0.class)
        public void setExecutionTimeInSeconds(long executionTimeInSeconds) {
            this.executionTimeInSeconds = executionTimeInSeconds;
        }

        @versionClass(value=version0.class)
        public long getTotalPausedTimeInSeconds() {
            return this.totalPausedTimeInSeconds;
        }

        @versionClass(value=version0.class)
        public void setTotalPausedTimeInSeconds(long totalPausedTimeInSeconds) {
            this.totalPausedTimeInSeconds = totalPausedTimeInSeconds;
        }

        @versionClass(value=version0.class)
        public RecoveryResult.ResultState getResultState() {
            return this.resultState;
        }

        @versionClass(value=version0.class)
        public void setResultState(RecoveryResult.ResultState resultState) {
            this.resultState = resultState;
        }

        @versionClass(value=version0.class)
        public int getWarningCount() {
            return this.warningCount;
        }

        @versionClass(value=version0.class)
        public void setWarningCount(int warningCount) {
            this.warningCount = warningCount;
        }

        @versionClass(value=version0.class)
        public int getErrorCount() {
            return this.errorCount;
        }

        @versionClass(value=version0.class)
        public void setErrorCount(int errorCount) {
            this.errorCount = errorCount;
        }

        @versionClass(value=version0.class)
        public int getNumXmlLines() {
            return this.numXmlLines;
        }

        @versionClass(value=version0.class)
        public void setNumXmlLines(int numXmlLines) {
            this.numXmlLines = numXmlLines;
        }

        @versionClass(value=version0.class)
        public int getOriginalSizeInBytes() {
            return this.originalSizeInBytes;
        }

        @versionClass(value=version0.class)
        public void setOriginalSizeInBytes(int originalSizeInBytes) {
            this.originalSizeInBytes = originalSizeInBytes;
        }

        @map
        @optional
        @versionClass(value=version0.class)
        public String[] getCompressedResults() {
            return this.compressedResults;
        }

        @map
        @optional
        @versionClass(value=version0.class)
        public void setCompressedResults(String[] compressedResults) {
            this.compressedResults = compressedResults;
        }

        @optional
        @versionClass(value=version16.class)
        public Integer getPoweredOnVms() {
            return this.poweredOnVms;
        }

        @optional
        @versionClass(value=version16.class)
        public void setPoweredOnVms(Integer poweredOnVms) {
            this.poweredOnVms = poweredOnVms;
        }

        @optional
        @versionClass(value=version16.class)
        public Integer getErrorStateVms() {
            return this.errorStateVms;
        }

        @optional
        @versionClass(value=version16.class)
        public void setErrorStateVms(Integer errorStateVms) {
            this.errorStateVms = errorStateVms;
        }

        @optional
        @versionClass(value=version16.class)
        public Integer getSuccessfullyRecoveredVms() {
            return this.successfullyRecoveredVms;
        }

        @optional
        @versionClass(value=version16.class)
        public void setSuccessfullyRecoveredVms(Integer successfullyRecoveredVms) {
            this.successfullyRecoveredVms = successfullyRecoveredVms;
        }

        @optional
        @versionClass(value=version16.class)
        public Integer getIpCustomizedVms() {
            return this.ipCustomizedVms;
        }

        @optional
        @versionClass(value=version16.class)
        public void setIpCustomizedVms(Integer ipCustomizedVms) {
            this.ipCustomizedVms = ipCustomizedVms;
        }

        @optional
        @versionClass(value=version16.class)
        public Integer getErrorIpCustomizedVms() {
            return this.errorIpCustomizedVms;
        }

        @optional
        @versionClass(value=version16.class)
        public void setErrorIpCustomizedVms(Integer errorIpCustomizedVms) {
            this.errorIpCustomizedVms = errorIpCustomizedVms;
        }

        @optional
        @versionClass(value=version16.class)
        public Integer getPoweredOffVms() {
            return this.poweredOffVms;
        }

        @optional
        @versionClass(value=version16.class)
        public void setPoweredOffVms(Integer poweredOffVms) {
            this.poweredOffVms = poweredOffVms;
        }

        @list
        @optional
        @versionClass(value=version16.class)
        public Exception[] getWarnings() {
            return this.warnings;
        }

        @list
        @optional
        @versionClass(value=version16.class)
        public void setWarnings(Exception[] warnings) {
            this.warnings = warnings;
        }

        @list
        @optional
        @versionClass(value=version16.class)
        public Exception[] getErrors() {
            return this.errors;
        }

        @list
        @optional
        @versionClass(value=version16.class)
        public void setErrors(Exception[] errors) {
            this.errors = errors;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(1160);
            objString.append("(dr.recovery.CompressedResult) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("historyKey = ");
            objString.append(this.getHistoryKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("runKey = ");
            objString.append(this.getRunKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("operation = ");
            objString.append(this.getOperation());
            objString.append(",\n");
            objString.append("   ");
            objString.append("options = ");
            if (this.getOptions() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getOptions())), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("planName = ");
            objString.append(this.getPlanName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("planDescription = ");
            objString.append(this.getPlanDescription());
            objString.append(",\n");
            objString.append("   ");
            objString.append("planUserAuthority = ");
            objString.append(this.getPlanUserAuthority());
            objString.append(",\n");
            objString.append("   ");
            objString.append("planCancelAuthority = ");
            objString.append(this.getPlanCancelAuthority());
            objString.append(",\n");
            objString.append("   ");
            objString.append("startTimeMinutes = ");
            objString.append(this.getStartTimeMinutes());
            objString.append(",\n");
            objString.append("   ");
            objString.append("startTime = ");
            objString.append(this.getStartTime());
            objString.append(",\n");
            objString.append("   ");
            objString.append("stopTime = ");
            objString.append(this.getStopTime());
            objString.append(",\n");
            objString.append("   ");
            objString.append("executionTimeInSeconds = ");
            objString.append(this.getExecutionTimeInSeconds());
            objString.append(",\n");
            objString.append("   ");
            objString.append("totalPausedTimeInSeconds = ");
            objString.append(this.getTotalPausedTimeInSeconds());
            objString.append(",\n");
            objString.append("   ");
            objString.append("resultState = ");
            objString.append((Object)this.getResultState());
            objString.append(",\n");
            objString.append("   ");
            objString.append("warningCount = ");
            objString.append(this.getWarningCount());
            objString.append(",\n");
            objString.append("   ");
            objString.append("errorCount = ");
            objString.append(this.getErrorCount());
            objString.append(",\n");
            objString.append("   ");
            objString.append("numXmlLines = ");
            objString.append(this.getNumXmlLines());
            objString.append(",\n");
            objString.append("   ");
            objString.append("originalSizeInBytes = ");
            objString.append(this.getOriginalSizeInBytes());
            objString.append(",\n");
            objString.append("   ");
            objString.append("compressedResults = ");
            if (this.getCompressedResults() == null) {
                objString.append("null");
            } else {
                objString.append("(STRING) [\n");
                for (i = 0; i < this.getCompressedResults().length; ++i) {
                    objString.append("      ");
                    objString.append(this.getCompressedResults()[i]);
                    if (i < this.getCompressedResults().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("poweredOnVms = ");
            objString.append(this.getPoweredOnVms());
            objString.append(",\n");
            objString.append("   ");
            objString.append("errorStateVms = ");
            objString.append(this.getErrorStateVms());
            objString.append(",\n");
            objString.append("   ");
            objString.append("successfullyRecoveredVms = ");
            objString.append(this.getSuccessfullyRecoveredVms());
            objString.append(",\n");
            objString.append("   ");
            objString.append("ipCustomizedVms = ");
            objString.append(this.getIpCustomizedVms());
            objString.append(",\n");
            objString.append("   ");
            objString.append("errorIpCustomizedVms = ");
            objString.append(this.getErrorIpCustomizedVms());
            objString.append(",\n");
            objString.append("   ");
            objString.append("poweredOffVms = ");
            objString.append(this.getPoweredOffVms());
            objString.append(",\n");
            objString.append("   ");
            objString.append("warnings = ");
            if (this.getWarnings() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.MethodFault) [\n");
                for (i = 0; i < this.getWarnings().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getWarnings()[i]), (boolean)true));
                    if (i < this.getWarnings().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("errors = ");
            if (this.getErrors() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.MethodFault) [\n");
                for (i = 0; i < this.getErrors().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getErrors()[i]), (boolean)true));
                    if (i < this.getErrors().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrRecoveryRecoveryHistoryManagerDetailedRecoveryResult")
    @data
    @propertyOrder(value={"runKey", "offset", "xmlData"})
    public static class DetailedRecoveryResult
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public long runKey;
        public int offset;
        public String[] xmlData;

        public DetailedRecoveryResult() {
        }

        public DetailedRecoveryResult(long runKey, int offset, String[] xmlData) {
            this.runKey = runKey;
            this.offset = offset;
            this.xmlData = xmlData;
        }

        @versionClass(value=version0.class)
        public long getRunKey() {
            return this.runKey;
        }

        @versionClass(value=version0.class)
        public void setRunKey(long runKey) {
            this.runKey = runKey;
        }

        @versionClass(value=version0.class)
        public int getOffset() {
            return this.offset;
        }

        @versionClass(value=version0.class)
        public void setOffset(int offset) {
            this.offset = offset;
        }

        @map
        @optional
        @versionClass(value=version0.class)
        public String[] getXmlData() {
            return this.xmlData;
        }

        @map
        @optional
        @versionClass(value=version0.class)
        public void setXmlData(String[] xmlData) {
            this.xmlData = xmlData;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(200);
            objString.append("(dr.recovery.DetailedRecoveryResult) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("runKey = ");
            objString.append(this.getRunKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("offset = ");
            objString.append(this.getOffset());
            objString.append(",\n");
            objString.append("   ");
            objString.append("xmlData = ");
            if (this.getXmlData() == null) {
                objString.append("null");
            } else {
                objString.append("(STRING) [\n");
                for (i = 0; i < this.getXmlData().length; ++i) {
                    objString.append("      ");
                    objString.append(this.getXmlData()[i]);
                    if (i < this.getXmlData().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version0.class)
    @wsdlName(value="DrRecoveryRecoveryHistoryManagerHistoryInfo")
    @data
    @propertyOrder(value={"historyKey", "name", "plan"})
    public static class HistoryInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public long historyKey;
        public String name;
        public ManagedObjectReference plan;

        public HistoryInfo() {
        }

        public HistoryInfo(long historyKey, String name2, ManagedObjectReference plan) {
            this.historyKey = historyKey;
            this.name = name2;
            this.plan = plan;
        }

        @versionClass(value=version0.class)
        public long getHistoryKey() {
            return this.historyKey;
        }

        @versionClass(value=version0.class)
        public void setHistoryKey(long historyKey) {
            this.historyKey = historyKey;
        }

        @versionClass(value=version0.class)
        public String getName() {
            return this.name;
        }

        @versionClass(value=version0.class)
        public void setName(String name2) {
            this.name = name2;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan")
        @optional
        @versionClass(value=version0.class)
        public ManagedObjectReference getPlan() {
            return this.plan;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.recovery.RecoveryPlan")
        @optional
        @versionClass(value=version0.class)
        public void setPlan(ManagedObjectReference plan) {
            this.plan = plan;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(200);
            objString.append("(dr.recovery.HistoryInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("historyKey = ");
            objString.append(this.getHistoryKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("name = ");
            objString.append(this.getName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("plan = ");
            if (this.getPlan() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + this.getPlan()), (boolean)false));
            }
            objString.append("\n}");
            return objString.toString();
        }
    }
}

