/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.oauth2;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationUtils;
import com.vmware.srm.client.infrastructure.authentication.oauth2.OAuth2AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.authentication.oauth2.OAuth2AuthenticationUtils;
import com.vmware.srm.client.infrastructure.http.BaseAsyncController;
import com.vmware.srm.client.infrastructure.init.InitFilter;
import com.vmware.srm.client.infrastructure.init.workflow.Configurator;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.vim.sso.client.SamlToken;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2LoginServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2LoginServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String errorCode = request.getParameter("error");
        if (errorCode != null) {
            LOGGER.error("OAuth2 response contains error: '{}'", (Object)errorCode);
            response.sendError(500);
            return;
        }
        String code = request.getParameter("code");
        Validate.notNull((Object)code, (String)"code");
        if (AuthenticationUtils.isAuthenticated(request)) {
            response.sendRedirect("/dr/");
            return;
        }
        Configurator configurator = InitFilter.getConfigurator(request);
        OAuth2AsyncExchangeController controller = new OAuth2AsyncExchangeController(request, response, code, configurator);
        controller.start(Config.get().getResponseTimeout());
    }

    private static class OAuth2AsyncExchangeController
    extends BaseAsyncController {
        private final String _authCode;
        private final Configurator _configurator;

        private OAuth2AsyncExchangeController(HttpServletRequest request, HttpServletResponse response, String authCode, Configurator configurator) {
            super(request, response);
            this._authCode = authCode;
            this._configurator = configurator;
        }

        @Override
        protected BaseAsyncController.HttpProcessStage createPipeline() {
            return this.getExchangeCodeForJwtToken();
        }

        private BaseAsyncController.HttpProcessStage getExchangeCodeForJwtToken() {
            Promise oAuth2Promise = this._configurator.getOAuth2Strategy().thenApply(OAuth2AuthenticationStrategy.class::cast);
            return () -> oAuth2Promise.thenCompose(strategy -> {
                Validate.notNull((Object)strategy, (String)"OAuth2 strategy not available");
                return OAuth2AuthenticationUtils.exchangeAuthCodeForJwtToken(this._authCode, strategy.getTokenEndpoint(), strategy.getClientId(), strategy.getClientSecret(), strategy.getAppRedirectUrl(), strategy.getQueryParams());
            }).toStream().flatMap(response -> oAuth2Promise.thenApply(strategy -> this.getExchangeJwtForSamlStage((OAuth2AuthenticationStrategy)strategy, oAuth2TokenResponse.accessToken, oAuth2TokenResponse.idToken)));
        }

        private BaseAsyncController.HttpProcessStage getExchangeJwtForSamlStage(OAuth2AuthenticationStrategy strategy, String jwtToken, String idToken) {
            return () -> OAuth2AuthenticationUtils.exchangeJwtForSamlToken(strategy.getSsoRegistration(), strategy.getVapiEndpoint(), strategy.getSsoContext(), jwtToken, idToken).toStream().map(token -> this.getSetupSessionStage(strategy, (SamlToken)token));
        }

        private BaseAsyncController.HttpProcessStage getSetupSessionStage(OAuth2AuthenticationStrategy strategy, SamlToken token) {
            return () -> AuthenticationUtils.setupSession(strategy.getSsoContext(), strategy, null, token, null, OAuth2AuthenticationStrategy.getRedirect(this._request), this._request, this._response).toStream().flatMap(unused -> Streams.empty());
        }
    }
}

