/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.localization.catalogManager;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogLoader {
    public static Lookup EMPTY = new LookupImpl();
    private static final Logger LOGGER = LoggerFactory.getLogger(CatalogLoader.class);
    static final Locale EN_LOCALE = LocaleUtils.toLocale((String)"en");
    static final Locale ES_LOCALE = LocaleUtils.toLocale((String)"es");
    static final Locale DE_LOCALE = LocaleUtils.toLocale((String)"de");
    static final Locale ZH_CN_LOCALE = LocaleUtils.toLocale((String)"zh_CN");
    static final Locale ZH_TW_LOCALE = LocaleUtils.toLocale((String)"zh_TW");
    static final Locale JA_LOCALE = LocaleUtils.toLocale((String)"ja");
    static final Locale KO_LOCALE = LocaleUtils.toLocale((String)"ko");
    static final Locale FR_LOCALE = LocaleUtils.toLocale((String)"fr");
    private static final IOFileFilter FILE_FILTER = new SuffixFileFilter(".vmsg", IOCase.INSENSITIVE);
    private final File _rootDir;

    private static Lookup createLookup() {
        return new LookupImpl();
    }

    private static Locale folderNameToLocale(String folderName) {
        switch (folderName) {
            case "en": {
                return EN_LOCALE;
            }
            case "es": {
                return ES_LOCALE;
            }
            case "de": {
                return DE_LOCALE;
            }
            case "zh_CN": {
                return ZH_CN_LOCALE;
            }
            case "zh_TW": {
                return ZH_TW_LOCALE;
            }
            case "ja": {
                return JA_LOCALE;
            }
            case "ko": {
                return KO_LOCALE;
            }
            case "fr": {
                return FR_LOCALE;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static ResourceBundle loadResourceBundle(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CatalogLoader(String rootFolderName) {
        Validate.notEmpty((String)rootFolderName);
        this._rootDir = new File(rootFolderName);
    }

    public Lookup load() {
        Collection files = FileUtils.listFiles((File)this._rootDir, (IOFileFilter)FILE_FILTER, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        Lookup lookup = CatalogLoader.createLookup();
        for (File file : files) {
            ResourceBundle rb;
            Locale locale = CatalogLoader.folderNameToLocale(file.getParentFile().getName());
            if (locale == null) {
                LOGGER.warn("Skipping file '" + file + "'.");
                continue;
            }
            try {
                rb = CatalogLoader.loadResourceBundle(file);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load file '" + file + "'.", (Throwable)e);
                continue;
            }
            Map resourceMap = (Map)lookup.get(locale);
            Validate.notNull((Object)resourceMap, (String)"resources");
            Enumeration<String> keys = rb.getKeys();
            while (keys.hasMoreElements()) {
                String value;
                String key = keys.nextElement();
                String prev = resourceMap.put(key, value = rb.getString(key));
                if (prev == null) continue;
                LOGGER.trace("Overriding '{}' with '{}'. Key '{}'.", new Object[]{prev, value, key});
            }
        }
        return lookup;
    }

    static final class LookupImpl
    extends HashMap<Locale, Map<String, String>>
    implements Lookup {
        LookupImpl() {
            super(8);
            this.put(EN_LOCALE, new HashMap());
            this.put(ES_LOCALE, new HashMap());
            this.put(DE_LOCALE, new HashMap());
            this.put(ZH_CN_LOCALE, new HashMap());
            this.put(ZH_TW_LOCALE, new HashMap());
            this.put(JA_LOCALE, new HashMap());
            this.put(KO_LOCALE, new HashMap());
            this.put(FR_LOCALE, new HashMap());
        }
    }

    static interface Lookup
    extends Map<Locale, Map<String, String>> {
    }
}

