/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.requestHandlers.datasource.impl;

import com.vmware.srm.client.infrastructure.requestHandlers.datasource.FilterData;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.PageData;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.SortData;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.SortOrder;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.impl.FilterDataImpl;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.impl.PageDataImpl;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.impl.SortDataImpl;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;

public class FilterSortPageRequestProcessor {
    public static final String FILTER_PROPERTY_URL_PARAM = "filterprop";
    public static final String FILTER_URL_PARAM = "filter";
    public static final String SORT_PROPERTY_URL_PARAM = "sortprop";
    public static final String SORT_URL_PARAM = "sort";
    public static final String PAGE_START_INDEX_URL_PARAM = "pagefrom";
    public static final String PAGE_SIZE_URL_PARAM = "pagesize";
    public static final String DEFAULT_FILTER = "";
    public static final SortOrder DEFAULT_SORT_ORDER = SortOrder.Ascending;
    public static final long DEFAULT_START_INDEX = 0L;
    public static final int DEFAULT_PAGE_SIZE = 10;

    public FilterSortPageData process(HttpServletRequest request) throws UnsupportedEncodingException, NumberFormatException {
        FilterData filterData = this.processFilterData(request);
        SortData sortData = this.processSortData(request);
        PageData pageData = this.processPageData(request);
        if (filterData == null && sortData == null && pageData == null) {
            return null;
        }
        return new FilterSortPageData(filterData, sortData, pageData);
    }

    FilterData processFilterData(HttpServletRequest request) throws UnsupportedEncodingException {
        String filterProperty = request.getParameter(FILTER_PROPERTY_URL_PARAM);
        if (filterProperty == null) {
            return null;
        }
        String filter = request.getParameter(FILTER_URL_PARAM);
        if (filter == null) {
            filter = DEFAULT_FILTER;
        }
        return new FilterDataImpl(filterProperty, filter);
    }

    SortData processSortData(HttpServletRequest request) throws UnsupportedEncodingException {
        String sortProperty = request.getParameter(SORT_PROPERTY_URL_PARAM);
        if (sortProperty == null) {
            return null;
        }
        String sort = request.getParameter(SORT_URL_PARAM);
        if (sort == null) {
            return new SortDataImpl(sortProperty, DEFAULT_SORT_ORDER);
        }
        return new SortDataImpl(sortProperty, SortOrder.valueOf(sort));
    }

    PageData processPageData(HttpServletRequest request) throws NumberFormatException, UnsupportedEncodingException {
        int pageSize;
        String startIndexAsString = request.getParameter(PAGE_START_INDEX_URL_PARAM);
        String pageSizeAsString = request.getParameter(PAGE_SIZE_URL_PARAM);
        if (startIndexAsString == null && pageSizeAsString == null) {
            return null;
        }
        long startIndex = startIndexAsString != null ? Long.parseLong(startIndexAsString) : 0L;
        int n = pageSize = pageSizeAsString != null ? Integer.parseInt(pageSizeAsString) : 10;
        if (startIndex < 0L) {
            throw new IllegalArgumentException("startIndex should be non-negative number");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize should be positive number");
        }
        return new PageDataImpl(startIndex, pageSize);
    }

    public static final class FilterSortPageData {
        public final FilterData filterData;
        public final SortData sortData;
        public final PageData pageData;

        FilterSortPageData(FilterData filterData, SortData sortData, PageData pageData) {
            this.filterData = filterData;
            this.sortData = sortData;
            this.pageData = pageData;
        }
    }
}

