/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.oauth2;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationUtils;
import com.vmware.srm.client.infrastructure.http.HttpUtils;
import com.vmware.srm.client.infrastructure.oauth2.OAuth2Context;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2AuthenticationStrategy
implements AuthenticationStrategy {
    private static final String LOG_OFF_PATH = "/app/logout.jsp";
    private static final String CLIENT_ID_PARAM = "client_id";
    private static final String REDIRECT_URI_PARAM = "redirect_uri";
    private static final String STATE_PARAM = "state";
    private static final int MAX_REQUESTS = 1000;
    private static final Map<String, String> REDIRECT_PATH_BY_UUID = new LinkedHashMap<String, String>(){

        @Override
        protected final boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1000;
        }
    };
    private final OAuth2Context _oauth2Context;
    private final SsoContext _ssoContext;

    public OAuth2AuthenticationStrategy(OAuth2Context oauth2Context, SsoContext ssoContext) {
        this._oauth2Context = oauth2Context;
        this._ssoContext = ssoContext;
    }

    @Override
    public Promise<Void> startLogin(HttpServletRequest request, HttpServletResponse response, String redirectPath) throws IOException {
        if (AuthenticationUtils.isAuthenticated(request)) {
            String msg = L10N.localize("sessionAlreadyAuthenticated", new Object[0]);
            response.sendError(400, msg);
            return Promises.reject((Exception)new RuntimeException(msg));
        }
        response.sendRedirect(this.buildAuthCodeRequestUrl(redirectPath));
        return Promises.resolve(null);
    }

    @Override
    public Promise<Void> startLogout(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            response.sendError(401);
            return Promises.reject((Exception)new RuntimeException(L10N.localize("sessionNotAuthenticated", new Object[0])));
        }
        AuthenticationUtils.destroySession(session);
        response.setHeader("Content-type", "text/html");
        HttpUtils.setNoCache(response);
        RequestDispatcher view = request.getRequestDispatcher(LOG_OFF_PATH);
        view.include((ServletRequest)request, (ServletResponse)response);
        return Promises.resolve(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getRedirect(HttpServletRequest request) {
        String redirect;
        String state = request.getParameter(STATE_PARAM);
        Map<String, String> map = REDIRECT_PATH_BY_UUID;
        synchronized (map) {
            redirect = REDIRECT_PATH_BY_UUID.remove(state);
        }
        if (redirect == null) {
            throw new RuntimeException("Invalid request");
        }
        return redirect;
    }

    LsppServiceEndpoint getVapiEndpoint() {
        return this._oauth2Context.getVapiEndpoint();
    }

    LsppService getSsoRegistration() {
        return this._ssoContext.getSsoRegistration();
    }

    SsoContext getSsoContext() {
        return this._ssoContext;
    }

    URI getTokenEndpoint() {
        return this._oauth2Context.getTokenEndpoint();
    }

    Map<String, List<String>> getQueryParams() {
        return this._oauth2Context.getAuthQueryParams();
    }

    URI getAppRedirectUrl() {
        return this._oauth2Context.getAppOAuth2RedirectUrl();
    }

    String getClientId() {
        return this._oauth2Context.getClientId();
    }

    String getClientSecret() {
        return this._oauth2Context.getClientSecret();
    }

    private String buildAuthCodeRequestUrl(String redirectPath) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)this._oauth2Context.getAuthEndpoint()).queryParam(CLIENT_ID_PARAM, new Object[]{this._oauth2Context.getClientId()}).queryParam(REDIRECT_URI_PARAM, new Object[]{this._oauth2Context.getAppOAuth2RedirectUrl()}).queryParam(STATE_PARAM, new Object[]{this.genarateStateParam(redirectPath)});
        for (Map.Entry<String, List<String>> e : this._oauth2Context.getAuthQueryParams().entrySet()) {
            for (String paramValue : e.getValue()) {
                builder = builder.queryParam(e.getKey(), new Object[]{paramValue});
            }
        }
        return builder.build().toUriString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String genarateStateParam(String redirectPath) {
        String key = UUID.randomUUID().toString();
        Map<String, String> map = REDIRECT_PATH_BY_UUID;
        synchronized (map) {
            REDIRECT_PATH_BY_UUID.put(key, redirectPath);
        }
        return key;
    }
}

