/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.http;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpResponse;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AsyncByteConsumer;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpResponseConsumer
extends AsyncByteConsumer<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncHttpResponseConsumer.class);
    private HttpServletResponse _response;
    private WriteListenerPromise _writeListenerPromise;

    public AsyncHttpResponseConsumer(HttpServletResponse response) throws IOException {
        this._response = response;
        this._writeListenerPromise = new WriteListenerPromise(response.getOutputStream());
        this._writeListenerPromise.init();
    }

    public Promise<Void> getResultPromise() {
        return this._writeListenerPromise;
    }

    protected void onByteReceived(ByteBuffer buf, IOControl ioControl) throws IOException {
        LOGGER.trace("Read '{}' bytes.", (Object)buf.remaining());
        this._writeListenerPromise.write(buf, ioControl);
    }

    protected void onResponseReceived(HttpResponse response) {
    }

    protected Void buildResult(HttpContext context) {
        return null;
    }

    protected void releaseResources() {
        Exception exc = this.getException();
        if (exc == null) {
            LOGGER.trace("Reading completed.");
            this._writeListenerPromise.complete();
        } else {
            LOGGER.warn("Reading failed: ", (Throwable)exc);
            this._writeListenerPromise.onError(exc);
        }
    }

    protected void onClose() {
    }

    class WriteListenerPromise
    extends PromiseImpl<Void>
    implements WriteListener {
        private final ServletOutputStream _output;
        private byte[] _inputBuffer;
        private IOControl _ioControl;
        private boolean _readComplete;

        WriteListenerPromise(ServletOutputStream output) {
            this._output = output;
        }

        void init() {
            this._output.setWriteListener((WriteListener)this);
        }

        synchronized void write(ByteBuffer byteBuffer, IOControl ioControl) throws IOException {
            Validate.isTrue((this._inputBuffer == null ? 1 : 0) != 0, (String)"Buffer not written.");
            this._ioControl = ioControl;
            this._inputBuffer = new byte[byteBuffer.remaining()];
            byteBuffer.get(this._inputBuffer);
            try {
                this.onWritePossible();
            }
            catch (Exception exc) {
                LOGGER.warn("Writing failed: ", (Throwable)exc);
                this.setError(exc);
                this._ioControl.shutdown();
            }
        }

        public synchronized void onWritePossible() throws IOException {
            if (this.isComplete()) {
                LOGGER.warn("Promise completed. Shutting down io control.");
                if (this._ioControl != null) {
                    this._ioControl.shutdown();
                }
                return;
            }
            if (this._readComplete) {
                if (this._inputBuffer == null || this.write(this._inputBuffer)) {
                    LOGGER.trace("Completed writing.");
                    this._inputBuffer = null;
                    try {
                        AsyncHttpResponseConsumer.this._response.flushBuffer();
                    }
                    finally {
                        this.setResult(null);
                    }
                }
                return;
            }
            if (this._ioControl == null) {
                return;
            }
            if (this.write(this._inputBuffer)) {
                this._inputBuffer = null;
                this._ioControl.requestInput();
            } else {
                this._ioControl.suspendInput();
            }
        }

        private boolean write(byte[] buffer) throws IOException {
            if (!this._output.isReady()) {
                LOGGER.trace("Not ready to write '{}' bytes.", (Object)buffer.length);
                return false;
            }
            LOGGER.trace("Writing '{}' bytes", (Object)buffer.length);
            this._output.write(buffer, 0, buffer.length);
            return true;
        }

        public synchronized void onError(Throwable t) {
            LOGGER.warn("Error while writing GET proxy response.", t);
            this.setError(Exceptions.wrap((Throwable)t));
            if (this._ioControl != null) {
                try {
                    this._ioControl.shutdown();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to shutdown proxy GET ioControl.", (Throwable)e);
                }
            }
        }

        public synchronized void complete() {
            if (this._readComplete) {
                return;
            }
            this._readComplete = true;
            try {
                this.onWritePossible();
            }
            catch (Exception exc) {
                LOGGER.warn("Writing failed: ", (Throwable)exc);
                this.setError(exc);
            }
        }
    }
}

