/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.http.io;

import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;

public class AsyncClientUtils {
    private static CloseableHttpAsyncClient createClientInt(KeyStore keyStore, ThumbprintVerifier verifier, long socketTimeout) throws IOException, GeneralSecurityException {
        return AsyncClientUtils.createClientInt((NHttpClientConnectionManager)AsyncClientUtils.createConnectionManager(keyStore, verifier), socketTimeout);
    }

    private static CloseableHttpAsyncClient createClientInt(NHttpClientConnectionManager connectionManager, long socketTimeout) {
        return HttpAsyncClients.custom().setConnectionManager(connectionManager).setDefaultRequestConfig(AsyncClientUtils.createRequestConfig(null, socketTimeout)).build();
    }

    private static PoolingNHttpClientConnectionManager createConnectionManager(KeyStore keyStore, ThumbprintVerifier verifier) throws IOException, GeneralSecurityException {
        ThumbprintTrustManager trustManager = new ThumbprintTrustManager(keyStore, verifier);
        return AsyncClientUtils.createConnectionManager(trustManager);
    }

    private static ConnectingIOReactor createIOReactor() throws IOReactorException {
        Config config = Config.get();
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout((int)config.getSocketTimeout()).setConnectTimeout((int)config.getConnectTimeout()).build();
        return new DefaultConnectingIOReactor(ioReactorConfig);
    }

    private static PoolingNHttpClientConnectionManager createConnectionManager(ThumbprintTrustManager trustManager) throws IOException, GeneralSecurityException {
        TrustManager[] trustAllCerts = new TrustManager[]{trustManager};
        SSLContext ctx = SSLContext.getInstance("TLSv1.2");
        ctx.init(null, trustAllCerts, null);
        ConnectingIOReactor ioReactor = AsyncClientUtils.createIOReactor();
        Registry<SchemeIOSessionStrategy> schemeRegistry = AsyncClientUtils.createSchemeRegistry(ctx, trustManager);
        return new PoolingNHttpClientConnectionManager(ioReactor, schemeRegistry);
    }

    private static Registry<SchemeIOSessionStrategy> createSchemeRegistry(SSLContext sslContext, ThumbprintTrustManager trustManager) {
        RegistryBuilder builder = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE);
        builder.register("https", (Object)new SSLIOSessionStrategy(sslContext, (X509HostnameVerifier)new ThumbprintTrustManager.HostnameVerifier(trustManager)));
        return builder.build();
    }

    public static RequestConfig createRequestConfig(URI proxy) {
        return AsyncClientUtils.createRequestConfig(proxy, Config.get().getSocketTimeout());
    }

    public static RequestConfig createRequestConfig(URI proxy, long socketTimeout) {
        HttpHost proxyHost = null;
        if (proxy != null) {
            proxyHost = new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getScheme());
        }
        return RequestConfig.custom().setExpectContinueEnabled(false).setSocketTimeout((int)socketTimeout).setConnectTimeout((int)Config.get().getConnectTimeout()).setCookieSpec("standard").setProxy(proxyHost).build();
    }

    static CloseableHttpAsyncClient createClient(KeyStore sslStore, ThumbprintVerifier verifier) {
        return AsyncClientUtils.createClient(sslStore, verifier, Config.get().getSocketTimeout());
    }

    static CloseableHttpAsyncClient createClient(KeyStore sslStore, ThumbprintVerifier verifier, long socketTimeout) {
        try {
            return AsyncClientUtils.createClientInt(sslStore, verifier, socketTimeout);
        }
        catch (Exception e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
    }
}

