/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.logging;

import com.vmware.srm.client.infrastructure.jmx.LoggerManager;
import com.vmware.srm.client.infrastructure.logging.LoggerManagerRequest;
import com.vmware.srm.client.topology.impl.init.Config;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerManagerContextListener
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerManagerContextListener.class);
    private volatile LoggerManagerServer _server = null;

    public void contextInitialized(ServletContextEvent contextEvent) {
        ServerSocket socket;
        if (!Config.get().getLoggerManagerEnabled()) {
            return;
        }
        try {
            socket = new ServerSocket(Config.get().getLoggerManagerPort(), 1, InetAddress.getLoopbackAddress());
        }
        catch (IOException e) {
            LOGGER.error("Failed to start LoggerManager server:", (Throwable)e);
            return;
        }
        this._server = new LoggerManagerServer(socket);
        this._server.start();
    }

    public void contextDestroyed(ServletContextEvent contextEvent) {
        if (this._server == null) {
            return;
        }
        this._server.stopServer();
        this._server = null;
    }

    private static final class LoggerManagerServer
    extends Thread {
        private static final String NAME = "Dr-Logger-Manager-Server";
        private volatile boolean _isRunning = true;
        private final ServerSocket _socket;
        private final LoggerManager _loggerManager = new LoggerManager();

        LoggerManagerServer(ServerSocket socket) {
            super(NAME);
            this._socket = socket;
        }

        @Override
        public void run() {
            LOGGER.info("Started LoggerManagerServer on port {}.", (Object)this._socket.getLocalPort());
            while (true) {
                Socket clientSocket;
                try {
                    clientSocket = this._socket.accept();
                    clientSocket.setSoTimeout(10000);
                }
                catch (SocketTimeoutException ste) {
                    LOGGER.warn("Timedout reading from socket:", (Throwable)ste);
                    continue;
                }
                catch (IOException e) {
                    if (!this._isRunning) break;
                    LOGGER.warn("accept failed:", (Throwable)e);
                    break;
                }
                this.processRequest(clientSocket);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processRequest(Socket clientSocket) {
            LoggerManagerRequest request;
            try {
                request = this.readRequest(clientSocket.getInputStream());
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read request:", (Throwable)e);
                return;
            }
            finally {
                try {
                    clientSocket.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close client socket:", (Throwable)e);
                }
            }
            try {
                this._loggerManager.updateLogger(request.getCategory(), request.getLogLevel());
                LOGGER.info("Updated log level with {}", (Object)request);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to update log level with '{}'", (Object)request, (Object)e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private LoggerManagerRequest readRequest(InputStream is) throws IOException {
            try (ValidatingObjectInputStream vois = new ValidatingObjectInputStream((InputStream)new BufferedInputStream(is));){
                vois.accept(new Class[]{LoggerManagerRequest.class});
                LoggerManagerRequest loggerManagerRequest = (LoggerManagerRequest)vois.readObject();
                return loggerManagerRequest;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        void stopServer() {
            this._isRunning = false;
            try {
                this._socket.close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close server socket:", (Throwable)e);
                this.interrupt();
            }
        }
    }
}

