/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.pc.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.StreamImpl;
import com.vmware.dr.ui.tools.utilities.StringUtils;
import com.vmware.srm.client.infrastructure.exceptions.ExceptionUtil;
import com.vmware.srm.client.infrastructure.pc.utils.ErrorPcResultItem;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.infrastructure.pc.utils.PcResultImpl;
import com.vmware.srm.client.infrastructure.pc.utils.RetrievePropertiesImpl;
import com.vmware.srm.client.infrastructure.pc.utils.SuccessPcResultItem;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.impl.utils.IndexUtils;
import com.vmware.srm.client.topology.impl.vmomi.srm.SrmServiceImpl;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.types.DataObjectType;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCUtil {
    private static final String ARRAY_LENGTH_TAG = "length";
    private static final Logger LOGGER = LoggerFactory.getLogger(PCUtil.class);
    private static final String PERFORMANCE_LOGGER_NAME = "com.vmware.srm.client.performance.propertycollector";
    private static final Logger PERFORMANCE_LOGGER = LoggerFactory.getLogger((String)"com.vmware.srm.client.performance.propertycollector");

    public static PropertyCollector.FilterSpec createFilterSpec(ManagedObjectReference moRef, String ... properties) {
        Validate.notNull((Object)moRef, (String)"moRef");
        Validate.notEmpty((Object[])properties, (String)"properties");
        return PCUtil.createFilterSpec(Arrays.asList(moRef), properties);
    }

    public static PropertyCollector.FilterSpec createFilterSpec(Collection<ManagedObjectReference> moRefs, String ... properties) {
        Validate.notEmpty(moRefs, (String)"moRefs");
        Validate.notEmpty((Object[])properties, (String)"properties");
        Map guidToMoRefMap = IndexUtils.indexByGuid(moRefs);
        if (guidToMoRefMap.size() > 1) {
            throw new IllegalArgumentException("The ManagedObjects in 'moRefs' argument belong to more than 1 server.");
        }
        Collection objSpecs = CollectionUtils.collect(moRefs, (Transformer)new Transformer(){

            public Object transform(Object input) {
                ManagedObjectReference moref = (ManagedObjectReference)input;
                PropertyCollector.ObjectSpec spec = new PropertyCollector.ObjectSpec();
                spec.obj = moref;
                return spec;
            }
        });
        Map typeToMoRefMap = IndexUtils.indexBy(moRefs, (IndexUtils.Indexer)new IndexUtils.Indexer<String, ManagedObjectReference>(){

            public String getKey(ManagedObjectReference value) {
                return value.getType();
            }
        });
        LinkedList<PropertyCollector.PropertySpec> propSpecs = new LinkedList<PropertyCollector.PropertySpec>();
        for (String type : typeToMoRefMap.keySet()) {
            PropertyCollector.PropertySpec propSpec = new PropertyCollector.PropertySpec();
            propSpec.type = PCUtil.getTypeName(type);
            propSpec.pathSet = PCUtil.getRelevantProperties(type, properties);
            propSpecs.add(propSpec);
        }
        PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec();
        filterSpec.objectSet = objSpecs.toArray(new PropertyCollector.ObjectSpec[objSpecs.size()]);
        filterSpec.propSet = propSpecs.toArray(new PropertyCollector.PropertySpec[propSpecs.size()]);
        filterSpec.reportMissingObjectsInResults = true;
        return filterSpec;
    }

    public static PropertyCollector.FilterSpec createFilterSpec(PropertyCollector.ObjectSpec[] objSpecs, PropertyCollector.PropertySpec ... props) {
        Validate.notEmpty((Object[])objSpecs, (String)"objSpec");
        Validate.notEmpty((Object[])props, (String)"props");
        PropertyCollector.FilterSpec spec = new PropertyCollector.FilterSpec();
        spec.reportMissingObjectsInResults = true;
        spec.objectSet = objSpecs;
        spec.propSet = props;
        return spec;
    }

    public static PropertyCollector.FilterSpec createFilterSpec(PropertyCollector.ObjectSpec objSpec, PropertyCollector.PropertySpec ... props) {
        Validate.notNull((Object)objSpec, (String)"objSpec");
        return PCUtil.createFilterSpec(new PropertyCollector.ObjectSpec[]{objSpec}, props);
    }

    public static PropertyCollector.FilterSpec createFilterSpec(Collection<PropertyCollector.ObjectSpec> objSpec, PropertyCollector.PropertySpec ... props) {
        Validate.notEmpty(objSpec, (String)"objSpec");
        return PCUtil.createFilterSpec(objSpec.toArray(new PropertyCollector.ObjectSpec[objSpec.size()]), props);
    }

    public static PropertyCollector.PropertySpec createPropertySpec(String type, String ... props) {
        Validate.notEmpty((String)type, (String)"type");
        return new PropertyCollector.PropertySpec(PCUtil.getTypeName(type), null, props);
    }

    public static Set<String> getAllProperties(String wsdlType) {
        Validate.notEmpty((String)wsdlType, (String)"wsdlType");
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(wsdlType);
        Validate.notNull((Object)vmodlType, (String)(wsdlType + " not found in VmodlTypeMap."));
        if (vmodlType.getKind() != VmodlType.Kind.MANAGED_OBJECT) {
            throw new IllegalArgumentException(wsdlType + " is not ManagedObject.");
        }
        ManagedProperty[] props = ((ManagedObjectType)vmodlType).getManagedProperties();
        HashSet<String> result = new HashSet<String>();
        for (ManagedProperty prop : props) {
            result.add(prop.getName());
        }
        return result;
    }

    public static String[] getRelevantProperties(String wsdlType, String[] props) {
        Validate.notEmpty((String)wsdlType, (String)"wsdlType");
        Validate.notEmpty((Object[])props, (String)"props");
        int colonIndex = wsdlType.indexOf(58);
        if (colonIndex != -1) {
            wsdlType = wsdlType.substring(colonIndex + 1);
        }
        VmodlType moRefType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(wsdlType);
        Validate.notNull((Object)moRefType, (String)(wsdlType + " not found in VmodlTypeMap."));
        LinkedList<String> result = new LinkedList<String>();
        String[] stringArray = props;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            VmodlType vmodlType = moRefType;
            String prop = stringArray[i];
            if (!PCUtil.hasProperty(vmodlType, prop)) continue;
            result.add(prop);
        }
        return result.toArray(new String[result.size()]);
    }

    public static ManagedProperty getManagedProperty(String wsdlType, String prop) {
        Validate.notEmpty((String)wsdlType, (String)"wsdlType");
        Validate.notEmpty((String)prop, (String)"prop");
        VmodlType moRefType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(wsdlType);
        Validate.notNull((Object)moRefType, (String)(wsdlType + " not found in VmodlTypeMap."));
        if (moRefType.getKind() != VmodlType.Kind.MANAGED_OBJECT) {
            throw new IllegalArgumentException(wsdlType + " is not ManagedObjectType.");
        }
        return ((ManagedObjectType)moRefType).getManagedProperty(prop);
    }

    private static boolean hasProperty(VmodlType vmodlType, String prop) {
        if (prop.endsWith(".")) {
            LOGGER.warn("Property cannot end with a dot - [{}].", (Object)prop);
            return false;
        }
        String[] nestedProps = prop.split("\\.");
        for (int i = 0; i < nestedProps.length; ++i) {
            String current = nestedProps[i];
            if (vmodlType.getKind() == VmodlType.Kind.ARRAY) {
                if (current.equals(ARRAY_LENGTH_TAG)) {
                    return i == nestedProps.length - 1;
                }
                LOGGER.warn("Nested property [{}] for array of '{}' is not supported", (Object)current, (Object)((VmodlArrayType)vmodlType).getComponentType());
                return false;
            }
            VmodlField managedProperty = PCUtil.getVmodlProperty(vmodlType, current);
            if (managedProperty == null) {
                LOGGER.debug("Property '{}' is not relevant for type '{}'.", (Object)current, (Object)vmodlType);
                return false;
            }
            vmodlType = managedProperty.getType();
        }
        return true;
    }

    public static VmodlField getVmodlProperty(VmodlType vmodlType, String prop) {
        Validate.notNull((Object)vmodlType, (String)"vmodlType");
        Validate.notNull((Object)prop, (String)"prop");
        switch (vmodlType.getKind()) {
            case MANAGED_OBJECT: {
                return ((ManagedObjectType)vmodlType).getManagedProperty(prop);
            }
            case DATA_OBJECT: {
                return ((DataObjectType)vmodlType).getProperty(prop);
            }
        }
        LOGGER.warn("The type '{}' found while processing [{}] property is unhandled.", (Object)vmodlType, (Object)prop);
        return null;
    }

    public static TypeName getTypeName(String wsdlType) {
        Validate.notNull((Object)wsdlType, (String)"wsdlType");
        VmodlType type = VmodlTypeMap.Factory.getTypeMap().getVmodlType(wsdlType);
        if (type == null) {
            throw new IllegalArgumentException("Unknown vmodl type: " + wsdlType);
        }
        return new TypeNameImpl(type);
    }

    public static Promise<PcResult> retrieveProperties(ServersView view, ManagedObjectReference moRef, String ... properties) {
        Validate.notNull((Object)moRef, (String)"moRef");
        return PCUtil.retrieveProperties(view, new HashSet<ManagedObjectReference>(Collections.singletonList(moRef)), properties);
    }

    public static Promise<PcResult> retrieveProperties(ServersView view, Set<ManagedObjectReference> moRefs, String ... properties) {
        Validate.notNull((Object)view, (String)"view");
        Validate.notEmpty(moRefs, (String)"moRefs array is either null or empty.");
        Validate.notEmpty((Object[])properties, (String)"properties array is either null or empty.");
        Map serverGuidToMoRefMap = IndexUtils.indexByGuid(moRefs);
        StreamImpl serversStream = new StreamImpl();
        Promise<PcResult> pcResult = PCUtil.retrievePcResult(view, moRefs, (StreamImpl<ServerSpecs>)serversStream);
        for (Map.Entry entry : serverGuidToMoRefMap.entrySet()) {
            String guid = (String)entry.getKey();
            PropertyCollector.FilterSpec filterSpec = PCUtil.createFilterSpec((Collection)entry.getValue(), properties);
            serversStream.publishNext((Object)new ServerSpecs(guid, filterSpec));
        }
        serversStream.publishComplete();
        return pcResult;
    }

    public static Promise<PcResult> retrieveProperties(ServersView view, PropertyCollector.FilterSpec ... specs) {
        Validate.notNull((Object)view, (String)"view");
        Validate.notEmpty((Object[])specs, (String)"specs");
        Map<String, Collection<PropertyCollector.FilterSpec>> specsByServer = PCUtil.getSpecsByServer(specs);
        StreamImpl serversStream = new StreamImpl();
        Promise<PcResult> pcResult = PCUtil.retrievePcResult(view, PCUtil.getMoRefsFromSpec(specs), (StreamImpl<ServerSpecs>)serversStream);
        for (Map.Entry<String, Collection<PropertyCollector.FilterSpec>> entry : specsByServer.entrySet()) {
            String guid = entry.getKey();
            Collection<PropertyCollector.FilterSpec> filterSpecs = entry.getValue();
            serversStream.publishNext((Object)new ServerSpecs(guid, filterSpecs));
        }
        serversStream.publishComplete();
        return pcResult;
    }

    public static <T> Promise<T> retrieveProperty(ServersView view, ManagedObjectReference moRef, String property) {
        Promise<PcResult> pcResult = PCUtil.retrieveProperties(view, moRef, property);
        return pcResult.thenApply(result -> result.getProperty(moRef, property));
    }

    public static <T> Promise<T> tryRetrieveProperty(ServersView view, ManagedObjectReference moRef, String property, Function<Throwable, RuntimeException> errorHandler) {
        Promise<PcResult> pcResult = PCUtil.retrieveProperties(view, moRef, property);
        return pcResult.thenApply(result -> result.tryGetProperty(moRef, property, errorHandler));
    }

    public static <T> Promise<T> tryRetrieveProperty(ServersView view, ManagedObjectReference moRef, String property) {
        return PCUtil.tryRetrieveProperty(view, moRef, property, e -> null);
    }

    private static Promise<PcResult> retrievePcResult(ServersView view, Collection<ManagedObjectReference> moRefs, StreamImpl<ServerSpecs> serversStream) {
        Stream resultItemsStream = serversStream.flatMap(serverSpecs -> {
            PromiseImpl result = new PromiseImpl();
            view.getServerBy(serverSpecs.getGuid()).onSuccess(server -> server.getStatus().onSuccess(status -> {
                if (status != Server.Status.ok) {
                    result.setResult((Object)new ErrorPcResultItem(serverSpecs.getGuid(), ExceptionUtil.getNoConnectionError(server.url())));
                    LOGGER.warn("Server {} has status {}", server, status);
                    return;
                }
                PERFORMANCE_LOGGER.debug("Server specs - {}", serverSpecs);
                RetrievePropertiesImpl retrieveImpl = new RetrievePropertiesImpl(server.guid(), server.service(), serverSpecs.getFilterSpecs());
                retrieveImpl.retrieveProperties().onSuccess(resultCollection -> result.setResult((Object)new SuccessPcResultItem(serverSpecs.getGuid(), (Collection<PropertyCollector.RetrieveResult>)resultCollection))).onError(error -> {
                    result.setResult((Object)new ErrorPcResultItem(serverSpecs.getGuid(), (Exception)error));
                    LOGGER.warn("Retrieve properties failed for [{}].", serverSpecs, error);
                });
            }).onError(error -> {
                result.setResult((Object)new ErrorPcResultItem(serverSpecs.getGuid(), (Exception)error));
                LOGGER.warn("Retrieve status for '{}' failed.", server, error);
            })).onError(error -> {
                result.setResult((Object)new ErrorPcResultItem(serverSpecs.getGuid(), (Exception)error));
                LOGGER.warn("Retrieve PC result failed for server guid '{}'", (Object)serverSpecs.getGuid(), error);
            });
            return result;
        });
        return resultItemsStream.reduce((Object)new PcResultImpl(moRefs), (pcResult, item) -> item.applyResult((PcResultImpl)pcResult)).thenApply(pcResult -> {
            pcResult.checkForNotFoundMoRefs();
            return pcResult;
        });
    }

    private static Map<String, Collection<PropertyCollector.FilterSpec>> getSpecsByServer(PropertyCollector.FilterSpec ... specs) {
        Hashtable<String, Collection<PropertyCollector.FilterSpec>> serverGuidToFilterSpecsMap = new Hashtable<String, Collection<PropertyCollector.FilterSpec>>(specs.length);
        for (PropertyCollector.FilterSpec spec : specs) {
            Validate.notEmpty((Object[])spec.objectSet, (String)"No ManagedObjects present in the FilterSpec!");
            Map serverGuidToMoRefMap = IndexUtils.indexBy(Arrays.asList(spec.objectSet), (IndexUtils.Indexer)new IndexUtils.Indexer<String, PropertyCollector.ObjectSpec>(){

                public String getKey(PropertyCollector.ObjectSpec value) {
                    return value.obj.getServerGuid();
                }
            });
            if (serverGuidToMoRefMap.size() > 1) {
                throw new IllegalArgumentException("The ManagedObjects in 'spec.objectSet' belong to more than 1 server.");
            }
            String guid = (String)serverGuidToMoRefMap.keySet().iterator().next();
            ArrayList<PropertyCollector.FilterSpec> specsForServer = (ArrayList<PropertyCollector.FilterSpec>)serverGuidToFilterSpecsMap.get(guid);
            if (specsForServer == null) {
                specsForServer = new ArrayList<PropertyCollector.FilterSpec>(Arrays.asList(spec));
                serverGuidToFilterSpecsMap.put(guid, specsForServer);
                continue;
            }
            specsForServer.add(spec);
        }
        return serverGuidToFilterSpecsMap;
    }

    private static Collection<ManagedObjectReference> getMoRefsFromSpec(PropertyCollector.FilterSpec ... specs) {
        HashSet<ManagedObjectReference> moRefs = new HashSet<ManagedObjectReference>();
        for (PropertyCollector.FilterSpec spec : specs) {
            moRefs.addAll(PCUtil.getMoRefsFromSpec(spec));
        }
        return moRefs;
    }

    private static Collection<ManagedObjectReference> getMoRefsFromSpec(PropertyCollector.FilterSpec spec) {
        HashSet<ManagedObjectReference> moRefs = new HashSet<ManagedObjectReference>();
        for (PropertyCollector.ObjectSpec objSpec : spec.objectSet) {
            if (objSpec.skip != null && objSpec.skip.booleanValue()) continue;
            moRefs.add(objSpec.obj);
        }
        return moRefs;
    }

    static {
        try {
            SrmServiceImpl.VMODL_INIT.waitToComplete();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private static class ServerSpecs {
        private final String _guid;
        private final Collection<PropertyCollector.FilterSpec> _specs;

        public ServerSpecs(String guid, PropertyCollector.FilterSpec spec) {
            this(guid, Arrays.asList(spec));
        }

        public ServerSpecs(String guid, Collection<PropertyCollector.FilterSpec> specs) {
            this._guid = guid;
            this._specs = specs;
        }

        public String getGuid() {
            return this._guid;
        }

        public Collection<PropertyCollector.FilterSpec> getFilterSpecs() {
            return this._specs;
        }

        public String toString() {
            return "ServerSpecs {" + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_guid = ", (Object)this._guid)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_specs = ", this._specs)), (boolean)false) + "\n}";
        }
    }
}

