/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.requestHandlers.impl;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.requestHandlers.context.impl.RequestContextImpl;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.FilterData;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.PageData;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.SortData;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.impl.FilterSortPageRequestProcessor;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.SitePairRequestProcessor;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.tuple.Tuple2;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsPairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmPairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;

public class ContextHelper {
    private static final SitePairRequestProcessor SITE_PAIR_PROCESS = new SitePairRequestProcessor();
    private static final FilterSortPageRequestProcessor FSP_PROCESS = new FilterSortPageRequestProcessor();

    Promise<RequestContextImpl> create(Topology topology, ExtensionServersView view, HttpServletRequest request, DispatchCaller caller) {
        return Promises.resolve((Object)this).thenCompose(helper -> helper.createInner(topology, view, request, caller));
    }

    private Promise<RequestContextImpl> createInner(Topology topology, ExtensionServersView view, HttpServletRequest request, DispatchCaller caller) {
        FilterSortPageRequestProcessor.FilterSortPageData fspData;
        SitePairRequestProcessor.SitePairRequestData sitePairData = SITE_PAIR_PROCESS.process(request);
        try {
            fspData = FSP_PROCESS.process(request);
        }
        catch (UnsupportedEncodingException | NumberFormatException e) {
            throw new RuntimeException(e);
        }
        VisitorImpl v = new VisitorImpl(caller, topology, view, fspData);
        sitePairData.mode.accept(v, sitePairData);
        return v.context;
    }

    private Promise<Tuple2<SrmServer, SrmPairSetup>> processSrm(ExtensionServersView view, String srmGuid, String pairSrmGuid) {
        return this.process(view, srmGuid, pairSrmGuid);
    }

    private Promise<Tuple2<HmsServer, HmsPairSetup>> processHms(ExtensionServersView view, String hmsGuid, String pairHmsGuid) {
        return this.process(view, hmsGuid, pairHmsGuid);
    }

    private <T extends ExtensionServer<?>, S extends PairSetup<T>> Promise<Tuple2<T, S>> process(ExtensionServersView view, String extGuid, String pairExtGuid) {
        return view.getServerBy(extGuid).thenApply(server -> (ExtensionServer)server).thenCompose(ext -> this.process(ext, pairExtGuid));
    }

    private <T extends ExtensionServer<?>, S extends PairSetup<T>> Promise<Tuple2<T, S>> process(T ext, String pairExtGuid) {
        return ext.getPairs().filter(pair -> pair.pairServerGuid().equals(pairExtGuid)).collect().thenApply(pairs -> {
            if (pairs.isEmpty()) {
                throw new Topology.TopologyException("Server '" + ext + "' is not paired to a server with guid '" + pairExtGuid + "'");
            }
            PairSetup pair = (PairSetup)pairs.iterator().next();
            return new Tuple2<ExtensionServer, PairSetup>(pair.server(), pair);
        });
    }

    private final class VisitorImpl
    implements SitePairRequestProcessor.ModeVisitor {
        private final DispatchCaller _caller;
        private final Topology _topology;
        private final ExtensionServersView _view;
        private final FilterData _filterData;
        private final SortData _sortData;
        private final PageData _pageData;
        Promise<RequestContextImpl> context;

        public VisitorImpl(DispatchCaller caller, Topology topology, ExtensionServersView view, FilterSortPageRequestProcessor.FilterSortPageData fspData) {
            this._caller = caller;
            this._topology = topology;
            this._view = view;
            if (fspData == null) {
                this._filterData = null;
                this._sortData = null;
                this._pageData = null;
            } else {
                this._filterData = fspData.filterData;
                this._sortData = fspData.sortData;
                this._pageData = fspData.pageData;
            }
        }

        @Override
        public void visitAll(SitePairRequestProcessor.SitePairRequestData data) {
            Validate.notEmpty((String)data.srmGuid, (String)"Srm guid");
            Validate.notEmpty((String)data.pairSrmGuid, (String)"Pair Srm guid");
            Validate.notEmpty((String)data.hmsGuid, (String)"Hms guid");
            Validate.notEmpty((String)data.pairHmsGuid, (String)"Pair Hms guid");
            Promise srmData = ContextHelper.this.processSrm(this._view, data.srmGuid, data.pairSrmGuid);
            Promise hmsData = ContextHelper.this.processHms(this._view, data.hmsGuid, data.pairHmsGuid);
            this.context = srmData.thenCombine(hmsData, (srm, hms) -> new RequestContextImpl(this._topology, this._view, (SrmServer)srm.getFirst(), (SrmPairSetup)srm.getSecond(), (HmsServer)hms.getFirst(), (HmsPairSetup)hms.getSecond(), this._filterData, this._sortData, this._pageData){

                @Override
                public <T extends DrData> Promise<T> dispatch(String path, DrData arg) {
                    return VisitorImpl.this._caller.call(path, arg, this);
                }
            });
        }

        @Override
        public void visitSrm(SitePairRequestProcessor.SitePairRequestData data) {
            Validate.notEmpty((String)data.srmGuid, (String)"Srm guid");
            Validate.notEmpty((String)data.pairSrmGuid, (String)"Pair Srm guid");
            Promise srmData = ContextHelper.this.processSrm(this._view, data.srmGuid, data.pairSrmGuid);
            this.context = srmData.thenApply(srm -> new RequestContextImpl(this._topology, this._view, (SrmServer)srm.getFirst(), (SrmPairSetup)srm.getSecond(), this._filterData, this._sortData, this._pageData){

                @Override
                public <T extends DrData> Promise<T> dispatch(String path, DrData arg) {
                    return VisitorImpl.this._caller.call(path, arg, this);
                }
            });
        }

        @Override
        public void visitHms(SitePairRequestProcessor.SitePairRequestData data) {
            Validate.notEmpty((String)data.hmsGuid, (String)"Hms guid");
            Validate.notEmpty((String)data.pairHmsGuid, (String)"Pair Hms guid");
            Promise hmsData = ContextHelper.this.processHms(this._view, data.hmsGuid, data.pairHmsGuid);
            this.context = hmsData.thenApply(hms -> new RequestContextImpl(this._topology, this._view, (HmsServer)hms.getFirst(), (HmsPairSetup)hms.getSecond(), this._filterData, this._sortData, this._pageData){

                @Override
                public <T extends DrData> Promise<T> dispatch(String path, DrData arg) {
                    return VisitorImpl.this._caller.call(path, arg, this);
                }
            });
        }

        @Override
        public void visitHmsRobo(SitePairRequestProcessor.SitePairRequestData data) {
            Validate.notEmpty((String)data.hmsGuid, (String)"Hms guid");
            Promise hmsData = ContextHelper.this.processHms(this._view, data.hmsGuid, data.hmsGuid);
            this.context = hmsData.thenApply(hms -> new RequestContextImpl(this._topology, this._view, (HmsServer)hms.getFirst(), (HmsPairSetup)hms.getSecond(), this._filterData, this._sortData, this._pageData){

                @Override
                public <T extends DrData> Promise<T> dispatch(String path, DrData arg) {
                    return VisitorImpl.this._caller.call(path, arg, this);
                }
            });
        }

        @Override
        public void visitFree(SitePairRequestProcessor.SitePairRequestData data) {
            this.context = Promises.resolve((Object)new RequestContextImpl(this._topology, this._view, this._filterData, this._sortData, this._pageData){

                @Override
                public <T extends DrData> Promise<T> dispatch(String path, DrData arg) {
                    return VisitorImpl.this._caller.call(path, arg, this);
                }
            });
        }
    }

    public static interface DispatchCaller {
        public Promise<? extends DrData> call(String var1, DrData var2, RequestContextImpl var3);
    }
}

