/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.requestHandlers.impl;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.PromiseResult;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import com.vmware.dr.ui.tools.utilities.AsyncConsumer;
import com.vmware.dr.ui.tools.utilities.OpIdAccessor;
import com.vmware.dr.ui.tools.utilities.threadcontexthelpers.LogContextSetter;
import com.vmware.srm.client.infrastructure.authentication.SessionWrapper;
import com.vmware.srm.client.infrastructure.exceptions.ExceptionUtil;
import com.vmware.srm.client.infrastructure.http.AsyncController;
import com.vmware.srm.client.infrastructure.http.HttpUtils;
import com.vmware.srm.client.infrastructure.requestHandlers.DrRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.FreeRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.HmsRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.SrmRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.DrRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FilterSortPageContext;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FreeRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FreeRequestContextWithFSP;
import com.vmware.srm.client.infrastructure.requestHandlers.context.HmsRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.context.HmsRequestContextWithFSP;
import com.vmware.srm.client.infrastructure.requestHandlers.context.SrmRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.context.SrmRequestContextWithFSP;
import com.vmware.srm.client.infrastructure.requestHandlers.context.impl.RequestContextImpl;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.FilterSortPageHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.datasource.impl.FilterSortPageResponseProcessor;
import com.vmware.srm.client.infrastructure.requestHandlers.impl.ContextHelper;
import com.vmware.srm.client.infrastructure.requestHandlers.impl.RequestHandlersLookup;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrClientProtocolException;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.reactive.impl.request.RequestContext;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServersView;
import com.vmware.srm.client.topology.impl.core.TopologyImpl;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.record.VmomiCallRecorder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.TimeoutException;
import javax.servlet.AsyncEvent;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DispatcherServlet.class);
    public static final String JSON_REQUEST = "json-request";
    private static final AsyncConsumer<Runnable> RECORDER = new AsyncConsumer<Runnable>(Runnable::run){

        protected void handleError(Throwable t, Runnable item) {
            LOGGER.warn("Record task '{}' failed.", (Object)item, (Object)t);
        }
    };
    static final String REQUEST_CONTEXT_ATTRIB = "com.vmware.dr.requestcontext";
    private volatile Config _config;
    private volatile RequestHandlersLookup _lookup;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this._config = Config.get();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create config: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        this._lookup = RequestHandlersLookup.create(config);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        TopologyImpl topology = SessionWrapper.getTopology(session);
        if (topology == null) {
            response.sendError(401);
            session.invalidate();
            return;
        }
        String path = HttpUtils.getPath(request);
        DrRequestHandler<?> handler = this.getRequestHandler(path);
        if (handler == null) {
            response.sendError(404);
            return;
        }
        Runnable task = () -> this.lambda$doPost$166(path, request, response, (Topology)topology, handler);
        LogContextSetter.withLogContext((Runnable)task, (String)"drRequestPath", (String)path).run();
    }

    private AsyncController<?> createController(HttpServletRequest request, HttpServletResponse response, Topology topology, DrRequestHandler<?> handler) {
        ExtensionServersView view = (ExtensionServersView)topology.getView();
        if (handler instanceof SrmRequestHandler) {
            return new SrmController(request, response, topology, view, (SrmRequestHandler)handler);
        }
        if (handler instanceof HmsRequestHandler) {
            return new HmsController(request, response, topology, view, (HmsRequestHandler)handler);
        }
        if (handler instanceof FreeRequestHandler) {
            return new FreeController(request, response, topology, view, (FreeRequestHandler)handler);
        }
        throw new IllegalArgumentException("handler");
    }

    private Promise<? extends DrData> invoke(DrRequestHandler<?> handler, DrData arg, RequestContextImpl impl) {
        if (handler instanceof SrmRequestHandler) {
            SrmRequestHandler srmHandler = (SrmRequestHandler)handler;
            return srmHandler.handle(arg, impl.asSrmContext());
        }
        if (handler instanceof HmsRequestHandler) {
            HmsRequestHandler hmsHandler = (HmsRequestHandler)handler;
            return hmsHandler.handle(arg, impl.asHmsContext());
        }
        if (handler instanceof FreeRequestHandler) {
            FreeRequestHandler freeHandler = (FreeRequestHandler)handler;
            return freeHandler.handle(arg, impl.asFreeContext());
        }
        throw new IllegalArgumentException("handler");
    }

    private DrRequestHandler<?> getRequestHandler(String path) {
        return this._lookup.get(path);
    }

    private /* synthetic */ void lambda$doPost$166(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Topology topology, DrRequestHandler drRequestHandler) {
        LOGGER.info("Processing request to '{}'", (Object)string);
        AsyncController<?> controller = this.createController(httpServletRequest, httpServletResponse, topology, drRequestHandler);
        controller.start(this._config.getResponseTimeout());
    }

    private final class FreeController
    extends ControllerImpl<FreeRequestContextWithFSP, FreeRequestContext> {
        FreeController(HttpServletRequest request, HttpServletResponse response, Topology topology, ExtensionServersView view, FreeRequestHandler handler) {
            super(request, response, topology, view, handler);
        }

        @Override
        protected FreeRequestContextWithFSP getContext(RequestContextImpl impl) {
            return impl.asFreeContext();
        }
    }

    private final class HmsController
    extends ControllerImpl<HmsRequestContextWithFSP, HmsRequestContext> {
        HmsController(HttpServletRequest request, HttpServletResponse response, Topology topology, ExtensionServersView view, HmsRequestHandler handler) {
            super(request, response, topology, view, handler);
        }

        @Override
        protected HmsRequestContextWithFSP getContext(RequestContextImpl impl) {
            return impl.asHmsContext();
        }
    }

    private final class SrmController
    extends ControllerImpl<SrmRequestContextWithFSP, SrmRequestContext> {
        SrmController(HttpServletRequest request, HttpServletResponse response, Topology topology, ExtensionServersView view, SrmRequestHandler handler) {
            super(request, response, topology, view, handler);
        }

        @Override
        protected SrmRequestContextWithFSP getContext(RequestContextImpl impl) {
            return impl.asSrmContext();
        }
    }

    private abstract class ControllerImpl<T extends DrRequestContext<?> & FilterSortPageContext, V extends DrRequestContext<?>>
    extends AsyncController<T> {
        private final DrRequestHandler<V> _handler;
        private final ContextHelper _helper;
        private final Topology _topology;
        private final ExtensionServersView _view;
        private final Logger _handlerLogger;
        volatile RequestContext<Promise<? extends DrData>> _requestContext;

        ControllerImpl(HttpServletRequest request, HttpServletResponse response, Topology topology, ExtensionServersView view, DrRequestHandler<V> handler) {
            super(request, response, handler.getInputArgType());
            this._helper = new ContextHelper();
            this._handler = handler;
            this._topology = topology;
            this._view = view;
            this._handlerLogger = LoggerFactory.getLogger(this._handler.getClass());
        }

        protected abstract T getContext(RequestContextImpl var1);

        @Override
        public void onError(AsyncEvent event) {
            super.onError(event);
            RequestContext<Promise<? extends DrData>> rc = this._requestContext;
            if (rc == null) {
                return;
            }
            rc.end(Exceptions.wrap((Throwable)event.getThrowable()));
        }

        @Override
        public void onTimeout(AsyncEvent event) {
            super.onTimeout(event);
            RequestContext<Promise<? extends DrData>> rc = this._requestContext;
            if (rc == null) {
                return;
            }
            rc.end(Exceptions.wrap((Throwable)new TimeoutException()));
        }

        @Override
        public void onComplete(AsyncEvent event) {
            super.onComplete(event);
            RequestContext<Promise<? extends DrData>> rc = this._requestContext;
            if (rc == null) {
                return;
            }
            rc.end();
        }

        @Override
        protected final Promise<? extends DrData> getResponseValue(DrData input, T context) {
            Promise result;
            if (this._handlerLogger.isDebugEnabled()) {
                Promises.resolve((Object)input).onSuccess(hi -> this._handlerLogger.debug("DrRequestHandlerInput:\n{}", hi));
            } else if (this._handlerLogger.isInfoEnabled() && input != null && input.hasShortStringImpl()) {
                Promises.resolve((Object)input).onSuccess(hi -> this._handlerLogger.info("[INPUT]: {}", (Object)hi.toShortString()));
            }
            long startCall = System.currentTimeMillis();
            DrRequestHandler handler = this.applyFilterSortPage(context);
            this._requestContext = RequestContext.create(() -> handler.handle(input, context));
            this._request.setAttribute(DispatcherServlet.REQUEST_CONTEXT_ATTRIB, this._requestContext);
            try {
                result = (Promise)this._requestContext.start();
            }
            catch (Exception e) {
                result = Promises.reject((Exception)e);
            }
            result.materialize().onSuccess(pr -> {
                if (pr.isSuccessful()) {
                    this._requestContext.end();
                } else {
                    this._requestContext.end(pr.getError());
                }
            });
            result.materialize().onSuccess(pr -> this.traceEndCall((PromiseResult<DrData>)pr, startCall));
            if (this._handlerLogger.isDebugEnabled()) {
                result.onSuccess(resultData -> this._handlerLogger.debug("DrRequestHandlerResult:\n{}.", resultData));
            } else if (this._handlerLogger.isInfoEnabled()) {
                result.onSuccess(resultData -> {
                    if (resultData != null && resultData.hasShortStringImpl()) {
                        this._handlerLogger.info("[RESULT]: {}", (Object)resultData.toShortString());
                    }
                });
            }
            if (this._handlerLogger.isWarnEnabled()) {
                result.onError(resultErr -> this._handlerLogger.warn("DrRequestHandlerError:\n", (Throwable)resultErr));
            }
            return result.materialize().thenCompose(promiseResult -> {
                if (promiseResult.isSuccessful()) {
                    return Promises.resolve((Object)promiseResult.getResult());
                }
                return ExceptionUtil.checkNoPermission(promiseResult.getError(), (ServersView)this._view).thenCompose(Promises::reject);
            });
        }

        protected final Promise<RequestContextImpl> create() {
            return this._helper.create(this._topology, this._view, this._request, this::doDispatch).materialize().thenApply(result -> {
                if (!result.isSuccessful()) {
                    throw new AsyncController.ContextFailedException(result.getError());
                }
                return (RequestContextImpl)result.getResult();
            });
        }

        @Override
        protected final Promise<? extends T> getContext() {
            return this.create().thenApply(this::getContext);
        }

        private Promise<? extends DrData> doDispatch(String path, DrData arg, RequestContextImpl impl) {
            DrRequestHandler inner = DispatcherServlet.this.getRequestHandler(path);
            if (inner == null) {
                return Promises.reject((Exception)new DrClientProtocolException("No handler for path '" + path + "' found."));
            }
            return Promises.resolve((Object)((Object)DispatcherServlet.this)).thenCompose(dispatch -> ((DispatcherServlet)dispatch).invoke(inner, arg, impl));
        }

        private void traceEndCall(PromiseResult<? extends DrData> result, long startCall) {
            LOGGER.trace("[Perf] {} answered for {} millis.", (Object)this._handler.getHandlerName(), (Object)(System.currentTimeMillis() - startCall));
        }

        private DrRequestHandler<T> applyFilterSortPage(T context) {
            if (((FilterSortPageContext)context).getFilterData() == null && ((FilterSortPageContext)context).getPageData() == null && ((FilterSortPageContext)context).getSortData() == null) {
                return this._handler;
            }
            if (this._handler instanceof FilterSortPageHandler) {
                return this._handler;
            }
            return new FilterSortPageResponseProcessor(this._handler);
        }

        @Override
        protected void sendInternalServerError(Exception exc, HttpServletResponse response) {
            if (exc instanceof AsyncController.ContextFailedException) {
                response.setStatus(205);
                try {
                    response.flushBuffer();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to send response: ", (Throwable)e);
                }
            } else {
                super.sendInternalServerError(exc, response);
            }
        }

        @Override
        protected DrData processInput(byte[] content) {
            try {
                DrData drData = super.processInput(content);
                return drData;
            }
            finally {
                if (VmomiCallRecorder.isEnabled()) {
                    this.recordJson(content, OpIdAccessor.get());
                }
            }
        }

        private void recordJson(byte[] content, String opId) {
            if (StringUtils.isEmpty((String)opId)) {
                LOGGER.warn("No opID available for '{}'", (Object)this);
                return;
            }
            RECORDER.accept(() -> {
                File opIdDir = new File(VmomiCallRecorder.getRecordPath(), opId);
                opIdDir.mkdirs();
                File jsonFile = new File(opIdDir, DispatcherServlet.JSON_REQUEST);
                try {
                    Files.write(jsonFile.toPath(), content, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to write to '{}'.", (Object)jsonFile);
                }
            });
        }
    }
}

