/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks.adapt;

import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.Subscriber;
import com.vmware.dr.ui.tools.reactive.Subscription;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.tasks.TaskUtil;
import com.vmware.srm.client.infrastructure.tasks.TasksFacade;
import com.vmware.srm.client.infrastructure.tasks.create.TaskHandle;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.vmomi.availability.PcUpdatesService;
import com.vmware.srm.client.topology.client.vmomi.updates.PcUpdateResult;
import com.vmware.srm.client.topology.client.vmomi.updates.UpdatesManager;
import com.vmware.srm.client.topology.impl.utils.IndexUtils;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCTaskAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PCTaskAdapter.class);
    private final ServersView _view;

    public PCTaskAdapter(ServersView view) {
        this._view = view;
    }

    public final <T> TaskHandle<T> start(ManagedObjectReference taskRef) {
        Validate.notNull((Object)taskRef, (String)"Task is null.");
        AtomicReference handleRef = new AtomicReference();
        Consumer consumer = taskHandle -> {
            handleRef.set(taskHandle);
            LOGGER.info("Created {} for {}.", (Object)taskHandle.getRef(), (Object)taskRef);
            this.subscribeForUpdates(taskRef.getServerGuid(), (TaskHandle)taskHandle, Collections.singleton(taskRef));
        };
        TasksFacade.createManagedTask(consumer);
        return (TaskHandle)handleRef.get();
    }

    public final TaskHandle<Void> start(Set<ManagedObjectReference> taskRefs) {
        AtomicReference handleRef = new AtomicReference();
        Consumer consumer = taskHandle -> {
            handleRef.set(taskHandle);
            if (CollectionUtils.isEmpty((Collection)taskRefs)) {
                taskHandle.complete(null);
                return;
            }
            Map guidToMoRefMap = IndexUtils.indexByGuid((Collection)taskRefs);
            if (guidToMoRefMap.size() > 1) {
                throw new IllegalArgumentException("The ManagedObjects in 'taskRefs' belong to more than 1 server.");
            }
            LOGGER.info("Created {} for {} tasks.", (Object)taskHandle.getRef(), (Object)taskRefs.size());
            this.subscribeForUpdates((String)guidToMoRefMap.keySet().iterator().next(), (TaskHandle)taskHandle, taskRefs);
        };
        TasksFacade.createManagedTask(consumer);
        return (TaskHandle)handleRef.get();
    }

    private <T> void subscribeForUpdates(String serverGuid, TaskHandle<T> taskHandle, Set<ManagedObjectReference> taskRefs) {
        Subscription subscription = this.getUpdatesStream(serverGuid, taskRefs).subscribe(taskRefs.size() == 1 ? new SingleTaskSubscriber<T>(taskHandle) : new MultiTaskSubscriber<T>(taskHandle, taskRefs.size()));
        taskHandle.materialize().thenApply(pr -> {
            LOGGER.info("Task {} completed. Cancel subscription.", (Object)taskHandle.getRef());
            subscription.cancel();
            return null;
        });
    }

    Stream<PcUpdateResult> getUpdatesStream(String serverGuid, Set<ManagedObjectReference> taskRefs) {
        return Streams.from((Publisher[])new Publisher[]{this._view.getServerBy(serverGuid)}).flatMap(server -> {
            UpdatesManager updatesManager = ((PcUpdatesService)server.service()).getUpdatesManager();
            return updatesManager.createUpdatesStream(PCUtil.createFilterSpec(taskRefs, "info"), false);
        });
    }

    private static int computeProgress(int completedTask, int allTasks) {
        return (int)((double)completedTask / (double)allTasks * 100.0);
    }

    static class MultiTaskSubscriber<T>
    extends BaseUpdatesSubscriber<T> {
        private final int _tasksCount;

        MultiTaskSubscriber(TaskHandle<T> taskHandle, int tasksCount) {
            super(taskHandle);
            this._tasksCount = tasksCount;
        }

        @Override
        protected void processUpdates(PcUpdateResult pcUpdateResult) {
            Set completedTasks = pcUpdateResult.getChanges().stream().map(change -> (TaskInfo)change.val).reduce(new HashSet(), (completed, taskInfo) -> {
                if (taskInfo.error != null) {
                    LOGGER.warn("Received failed task update:\n{}", taskInfo);
                    this._taskHandle.fail(taskInfo.error);
                }
                if (TaskUtil.isComplete(taskInfo) && completed.add(taskInfo.getTask())) {
                    this._taskHandle.setProgress(PCTaskAdapter.computeProgress(completed.size(), this._tasksCount));
                }
                return completed;
            }, (hs1, hs2) -> {
                hs1.addAll(hs2);
                return hs1;
            });
            LOGGER.trace("Tasks completed: {}.", (Object)completedTasks.size());
            if (completedTasks.size() < this._tasksCount) {
                LOGGER.trace("Number of completed task is less than all tasks: '{}'", (Object)this._taskHandle.getRef());
            }
            if (completedTasks.size() == this._tasksCount) {
                LOGGER.info("All tasks completed successfully.");
                this._taskHandle.complete(null);
            }
        }

        @Override
        protected void completeHandle() {
            this._taskHandle.complete(null);
        }
    }

    static class SingleTaskSubscriber<T>
    extends BaseUpdatesSubscriber<T> {
        SingleTaskSubscriber(TaskHandle<T> taskHandle) {
            super(taskHandle);
        }

        @Override
        protected void processUpdates(PcUpdateResult pcUpdateResult) {
            TaskInfo taskInfo = this._taskHandle.getTaskInfo();
            pcUpdateResult.getChanges().forEach(change -> {
                TaskInfo taskUpdate = (TaskInfo)change.val;
                taskInfo.state = taskUpdate.state;
                taskInfo.progress = taskUpdate.progress;
                taskInfo.result = taskUpdate.result;
                taskInfo.error = taskUpdate.error;
                this._taskHandle.setKey(taskUpdate.key);
            });
            if (taskInfo.state.equals((Object)TaskInfo.State.success)) {
                this._taskHandle.complete(taskInfo.result);
            } else if (TaskInfo.State.error.equals((Object)taskInfo.state)) {
                this._taskHandle.fail(taskInfo.error);
            } else {
                LOGGER.info("Task {} progress: {}", (Object)this._taskHandle.getRef(), (Object)taskInfo.progress);
                this._taskHandle.setProgress(taskInfo.progress);
            }
        }

        @Override
        protected void completeHandle() {
            this._taskHandle.complete(this._taskHandle.getTaskInfo().result);
        }
    }

    static abstract class BaseUpdatesSubscriber<T>
    implements Subscriber<PcUpdateResult> {
        protected final TaskHandle<T> _taskHandle;

        BaseUpdatesSubscriber(TaskHandle<T> taskHandle) {
            Validate.notNull(taskHandle, (String)"taskHandle can not be null.");
            this._taskHandle = taskHandle;
        }

        public void onNext(PcUpdateResult pcUpdateResult) {
            if (this._taskHandle.isCancelled()) {
                LOGGER.info("Task was cancelled.");
                return;
            }
            if (this.failIfMissingObjects(pcUpdateResult, this._taskHandle)) {
                return;
            }
            this.processUpdates(pcUpdateResult);
        }

        public void onComplete(boolean cancelled) {
            if (cancelled) {
                this._taskHandle.cancel();
            } else {
                this.completeHandle();
            }
        }

        public void onError(Exception e) {
            this._taskHandle.fail(e);
        }

        protected abstract void processUpdates(PcUpdateResult var1);

        protected abstract void completeHandle();

        private boolean failIfMissingObjects(PcUpdateResult pcUpdateResult, TaskHandle<?> taskHandle) {
            AtomicBoolean hasMissingObjects = new AtomicBoolean(false);
            pcUpdateResult.getMissingObjects().stream().findFirst().ifPresent(missingObject -> {
                LOGGER.warn("MONF returned for task {}.", (Object)missingObject.obj);
                taskHandle.fail(missingObject.fault);
                hasMissingObjects.set(true);
            });
            return hasMissingObjects.get();
        }
    }
}

