/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.wstrust.client;

import com.vmware.identity.wstrust.client.impl.ValidateUtil;
import java.net.URL;
import java.security.Key;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityTokenServiceConfig {
    private static final int REQUEST_VALIDITY_IN_SECONDS = 600;
    private final ConnectionConfig _connConfig;
    private X509Certificate[] _trustedRootCertificates;
    private final ExecutorService _executorService;
    private final HolderOfKeyConfig _holderOfKeyConfig;

    public SecurityTokenServiceConfig(ConnectionConfig connConfig, X509Certificate[] trustedRootCertificates, ExecutorService executorService) {
        this(connConfig, trustedRootCertificates, executorService, null);
    }

    public SecurityTokenServiceConfig(ConnectionConfig connConfig, X509Certificate[] trustedRootCertificates, ExecutorService executorService, HolderOfKeyConfig holderOfKeyConfig) {
        ValidateUtil.validateNotNull(connConfig, "STS connection configuration");
        this._connConfig = connConfig;
        this._trustedRootCertificates = trustedRootCertificates;
        this._executorService = executorService != null ? executorService : Executors.newSingleThreadExecutor();
        this._holderOfKeyConfig = holderOfKeyConfig;
    }

    public synchronized X509Certificate[] getTrustedRootCertificates() {
        return this._trustedRootCertificates;
    }

    public synchronized void setTrustedRootCertificates(X509Certificate[] trustedRootCertificates) {
        this._trustedRootCertificates = trustedRootCertificates;
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    public HolderOfKeyConfig getHolderOfKeyConfig() {
        return this._holderOfKeyConfig;
    }

    public ConnectionConfig getConnectionConfig() {
        return this._connConfig;
    }

    public int getRequestValidityInSeconds() {
        return 600;
    }

    public static class ConnectionConfig {
        private final Logger log = LoggerFactory.getLogger(ConnectionConfig.class);
        private final URL _url;
        private final X509Certificate[] _trustedRootCert;
        private final String _trustedCertThumbprint;
        private final CertStore _crlCertStore;

        public ConnectionConfig(URL url, X509Certificate[] trustedRootCert, String trustedCertThumbprint) {
            this(url, trustedRootCert, trustedCertThumbprint, null);
        }

        public ConnectionConfig(URL url, X509Certificate[] trustedRootCert, String trustedCertThumbprint, CertStore crlCertStore) {
            ValidateUtil.validateNotNull(url, "STS service URL");
            this._url = url;
            if (!ConnectionConfig.isHttpsOrLocalhost(url)) {
                this.log.warn("This configuration will establish untrusted connection with the STS server.It is acceptable for developing purposes only!");
            }
            this._trustedRootCert = trustedRootCert == null ? new X509Certificate[]{} : trustedRootCert;
            this._trustedCertThumbprint = ValidateUtil.isEmpty(trustedCertThumbprint) ? null : trustedCertThumbprint;
            this._crlCertStore = crlCertStore;
        }

        public URL getUrl() {
            return this._url;
        }

        public X509Certificate[] getTrustedRootCertificates() {
            return this._trustedRootCert;
        }

        public String getTrustedCertificateThumbprint() {
            return this._trustedCertThumbprint;
        }

        public CertStore getCrlCertStore() {
            return this._crlCertStore;
        }

        private static boolean isHttpsOrLocalhost(URL url) {
            return "https".equals(url.getProtocol()) || "localhost".equals(url.getHost()) || "127.0.0.1".equals(url.getHost());
        }
    }

    public static class HolderOfKeyConfig {
        private static final String INVALID_ARGUMENTS_ERR_MGS = "Input parameters cannot be null";
        private final Key _privateKey;
        private final X509Certificate _certificate;
        private final Provider _securityProvider;
        private final Logger _log = LoggerFactory.getLogger(HolderOfKeyConfig.class);

        public HolderOfKeyConfig(Key privateKey, X509Certificate certificate, Provider securityProvider) {
            if (privateKey == null) {
                this._log.error(INVALID_ARGUMENTS_ERR_MGS);
                throw new IllegalArgumentException(INVALID_ARGUMENTS_ERR_MGS);
            }
            this._privateKey = privateKey;
            this._certificate = certificate;
            this._securityProvider = securityProvider;
        }

        public Key getPrivateKey() {
            return this._privateKey;
        }

        public X509Certificate getCertificate() {
            return this._certificate;
        }

        public Provider getSecurityProvider() {
            return this._securityProvider;
        }
    }
}

