/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.wstrust.client.impl;

import com.vmware.identity.wstrust.client.impl.SoapFault;
import com.vmware.identity.wstrust.client.impl.exception.ParserException;
import com.vmware.identity.wstrust.client.impl.exception.SoapFaultException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SoapMessage {
    private final Node _body;
    private final Node _header;
    private final SOAPMessage _message;
    private final String _action;
    private static final String CREATION_ERROR_MSG = "Error creating SOAP message";
    private static final String PARSING_ERROR_MSG = "Error parsing SOAP message";
    private static final String SOAP_FAULT_FOUND = "SOAP fault found in the message";
    private final Logger _log = LoggerFactory.getLogger(SoapMessage.class);

    public SoapMessage(Node body, Node header, String soapAction) throws ParserException {
        assert (body != null);
        assert (header != null);
        assert (soapAction != null);
        this._log.debug("Creating SoapMessage from body and header");
        this._message = this.createMessage(body, header);
        this._action = soapAction;
        try {
            this._body = this._message.getSOAPBody();
            this._header = this._message.getSOAPHeader();
        }
        catch (SOAPException e) {
            throw new ParserException("Cannot init header and body", e);
        }
    }

    public SoapMessage(SOAPMessage message, String soapAction) throws ParserException, SoapFaultException {
        assert (message != null);
        assert (soapAction != null);
        this._log.debug("Creating SoapMessage from SOAPMessage");
        this.parseForSOAPFault(message);
        this._message = message;
        this._body = this.parseBody(message);
        this._header = null;
        this._action = soapAction;
    }

    public Node getBody() {
        return this._body;
    }

    public Node getHeader() {
        return this._header;
    }

    public SOAPMessage getMessage() {
        return this._message;
    }

    public String getSoapAction() {
        return this._action;
    }

    private SOAPMessage createMessage(Node body, Node header) throws ParserException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        SOAPMessage message = null;
        try {
            message = MessageFactory.newInstance().createMessage();
            Document adoptedBody = dbf.newDocumentBuilder().newDocument();
            adoptedBody.appendChild(adoptedBody.importNode(body, true));
            message.getSOAPBody().addDocument(adoptedBody);
            this.fixDOM1Attr(message.getSOAPBody(), (Document)message.getSOAPPart());
            Node adoptedHeader = message.getSOAPPart().importNode(header, true);
            message.getSOAPHeader().appendChild(adoptedHeader);
        }
        catch (ParserConfigurationException e) {
            this._log.error(CREATION_ERROR_MSG, (Throwable)e);
            throw new ParserException(CREATION_ERROR_MSG, e);
        }
        catch (SOAPException e) {
            this._log.error(CREATION_ERROR_MSG, (Throwable)e);
            throw new ParserException(CREATION_ERROR_MSG, e);
        }
        return message;
    }

    private void fixDOM1Attr(SOAPBody soapBody, Document soapDoc) {
        Node contextAttr;
        NamedNodeMap attributes;
        Element suspected = this.findWstElement(soapBody, "RequestSecurityToken");
        Element element = suspected = suspected != null ? suspected : this.findWstElement(soapBody, "RequestSecurityTokenResponse");
        if (suspected != null && (attributes = suspected.getAttributes()) != null && (contextAttr = attributes.getNamedItem("Context")) != null && contextAttr.getNamespaceURI() == null) {
            Attr contextAttrNS = soapDoc.createAttributeNS(null, contextAttr.getNodeName());
            contextAttrNS.setNodeValue(contextAttr.getNodeValue());
            attributes.setNamedItemNS(contextAttrNS);
        }
    }

    private Element findWstElement(SOAPBody soapBody, String name) {
        NodeList foundElements = soapBody.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", name);
        return foundElements != null && foundElements.getLength() == 1 ? (Element)foundElements.item(0) : null;
    }

    private Node parseBody(SOAPMessage message) throws ParserException {
        try {
            return message.getSOAPBody().getFirstChild();
        }
        catch (SOAPException e) {
            this._log.error(PARSING_ERROR_MSG, (Throwable)e);
            throw new ParserException(PARSING_ERROR_MSG, e);
        }
    }

    private void parseForSOAPFault(SOAPMessage message) throws ParserException, SoapFaultException {
        try {
            if (message.getSOAPBody().hasFault()) {
                this._log.error(SOAP_FAULT_FOUND);
                throw new SoapFaultException(SOAP_FAULT_FOUND, new SoapFault(message.getSOAPBody().getFault()));
            }
        }
        catch (SOAPException e) {
            this._log.error(PARSING_ERROR_MSG, (Throwable)e);
            throw new ParserException(PARSING_ERROR_MSG, e);
        }
    }
}

