/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.wstrust.client.impl.processors.response;

import com.vmware.identity.wstrust.client.exception.InternalError;
import com.vmware.identity.wstrust.client.impl.exception.ParserException;
import com.vmware.identity.wstrust.client.impl.processors.response.ResponseHandlerImpl;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.MalformedTokenException;
import javax.xml.bind.JAXBContext;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public final class ValidateTokenReponseHandler
extends ResponseHandlerImpl<Boolean> {
    private static final String TOKEN_TYPE_STATUS = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status";
    private static final String STATUS_CODE_VALID = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid";
    private final Logger _log = LoggerFactory.getLogger(ValidateTokenReponseHandler.class);

    public ValidateTokenReponseHandler(JAXBContext context) throws InternalError {
        super(context);
    }

    @Override
    public Boolean parseResponse(Node response) throws ParserException, InvalidTokenException {
        RequestSecurityTokenResponseType parsedResponse = this.parseStsResponse(response, RequestSecurityTokenResponseType.class, false);
        if (parsedResponse == null) {
            throw new MalformedTokenException("Unable to find a response to the token validation request");
        }
        if (!TOKEN_TYPE_STATUS.equalsIgnoreCase(parsedResponse.getTokenType())) {
            String message = "Unexpected token type value in the response. Got: " + parsedResponse.getTokenType() + " Expected: " + TOKEN_TYPE_STATUS;
            this._log.debug(message);
            throw new MalformedTokenException(message);
        }
        return parsedResponse.getStatus().getCode().equalsIgnoreCase(STATUS_CODE_VALID);
    }
}

